/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.tape;

import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.tape.common.model.GUIException;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.tape.GUIEntityFactory;

public class IOPortInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (reqData.getActionId() == 70) {
                this.getIoPortIdsByLibrary(reqData, response);
            } else if (reqData.getActionId() == 71) {
                this.getIoPortsByLibrary(reqData, response);
            }
        }
        catch (Exception ex) {
            Server.setResponseError(response, ex);
            response.errorMessage = ex.getMessage();
            response.responseData = null;
        }
        return response;
    }

    private void getIoPortIdsByLibrary(GUIRequestData reqData, Response response) throws GUIException {
        String libraryId = (String)((Object)reqData.getParameter("library.id"));
        response.responseData = this.entityFactory.getIoPortIdsByLibrary(libraryId);
    }

    private void getIoPortsByLibrary(GUIRequestData reqData, Response response) throws GUIException {
        String libraryId = (String)((Object)reqData.getParameter("library.id"));
        response.responseData = this.entityFactory.getIoPortsByLibrary(libraryId);
    }
}

