/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.handler.scheduler.JobHndlrThread;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;

public class JobHndlr
implements RequestHandler,
ThreadSafe {
    private static final Map<Integer, JobRun> serverJobTable = new HashMap<Integer, JobRun>();
    private static final ServerJobExtensionManager serverJobManager = new ServerJobExtensionManager();

    public Response handle(Request request, Transceiver transceiver) {
        VMJobResults jobResults;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if ((jobResults = ((VMTransceiver)transceiver).getJobData(request)) == null) {
            Response traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobHndlr.class.getName(), (String)"handle", traceResult);
            }
            return traceResult;
        }
        JobRun jobRun = jobResults.getJobRun();
        String userName = null;
        userName = request.userName;
        if (userName == null || userName.length() == 0) {
            userName = jobRun.getSchedCreator();
        }
        String[] cmdLine = jobRun.getCommandLine();
        String jobCommand = cmdLine[0];
        int parmsLength = cmdLine.length - 1;
        String[] parms = new String[parmsLength];
        if (cmdLine.length > 0) {
            System.arraycopy(cmdLine, 1, parms, 0, parmsLength);
        }
        StringBuffer auditMsgBuffer = new StringBuffer("Username=" + userName);
        auditMsgBuffer.append("\n Running " + jobCommand);
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)JobHndlr.class.getName(), (String)"handle", (String)auditMsgBuffer.toString());
        }
        ServerJob job = null;
        try {
            job = (ServerJob)serverJobManager.getExtensionImpl(jobCommand, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        new TSThread((Runnable)new JobHndlrThread(job, jobResults, parms, jobCommand), this.getClass().getName()).start();
        Response traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobHndlr.class.getName(), (String)"handle", traceResult);
        }
        return traceResult;
    }

    public static boolean jobNeedsLogFile(JobRun jobRun) {
        boolean needsLogFile = true;
        String[] commandLine = jobRun.getCommandLine();
        if (commandLine != null && commandLine.length != 0) {
            String jobCommand = commandLine[0];
            needsLogFile = Boolean.parseBoolean(serverJobManager.getExtensionAttribute(jobCommand, "logged"));
        }
        return needsLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToJobTable(JobRun jRun) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobHndlr.class.getName(), (String)"addToJobTable", (String)"jRun");
        }
        Map<Integer, JobRun> map = serverJobTable;
        synchronized (map) {
            Integer i = new Integer(jRun.getRunNumber());
            serverJobTable.put(i, jRun);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobHndlr.class.getName(), (String)"addToJobTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromJobTable(JobRun jRun) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobHndlr.class.getName(), (String)"removeFromJobTable", (String)"jRun");
        }
        Map<Integer, JobRun> map = serverJobTable;
        synchronized (map) {
            Integer i = new Integer(jRun.getRunNumber());
            serverJobTable.remove(i);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobHndlr.class.getName(), (String)"removeFromJobTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runningOrNot(Integer jobNumber) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobHndlr.class.getName(), (String)"runningOrNot", (String)"jobNumber");
        }
        boolean value = false;
        Map<Integer, JobRun> map = serverJobTable;
        synchronized (map) {
            value = serverJobTable.containsKey(jobNumber);
        }
        boolean traceResult = value;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobHndlr.class.getName(), (String)"runningOrNot", (boolean)traceResult);
        }
        return traceResult;
    }

    private static class ServerJobExtensionManager
    extends AbstractExtensionMgr {
        public static final String ATTR_IMPL = "impl";
        public static final String ATTR_LOGGED = "logged";

        private ServerJobExtensionManager() {
        }

        public String getExtensionPointId() {
            return "org.eclipse.aperi.server.data.serverJob";
        }
    }
}

