/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.scheduler.JobHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class JobHndlrThread
implements Runnable {
    private VMJobResults jobResults = null;
    private ServerJob job = null;
    private String[] parms = null;
    private String className = null;

    public JobHndlrThread(ServerJob job, VMJobResults jobResults, String[] parms, String className) {
        this.jobResults = jobResults;
        this.job = job;
        this.parms = parms;
        this.className = className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int completionCode = 8;
        this.jobResults.setThreadLog();
        Connection dbc = null;
        JobRun jobRun = this.jobResults.getJobRun();
        try {
            dbc = Server.getConnection();
            if (dbc == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)JobHndlr.class.getName(), (String)"handle");
                }
                throw new GeneralException(MessageLog.getMessage((String)"GEN0050E", null));
            }
            this.job.initialize(dbc);
            completionCode = this.job.run(this.jobResults, this.parms);
        }
        catch (UndeclaredThrowableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            MessageLog.logException((String)"SRV0703E", (Exception)e, (Object)this.className);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            MessageLog.logException((String)"STS0079E", (Exception)((Object)e), (Object)this.className);
        }
        catch (RuntimeException rte) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobHndlr.class.getName(), (String)"handle", (Throwable)rte);
            }
            MessageLog.logException((String)"STS0079E", (Exception)rte, (Object)this.className);
        }
        finally {
            Server.returnConnection(dbc);
            this.jobResults.restoreThreadLog();
            if (completionCode != -4096) {
                this.jobResults.jobCompleted(completionCode);
                JobHndlr.removeFromJobTable(jobRun);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobHndlr.class.getName(), (String)"handle", (Object)"");
        }
    }
}

