/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleSubmit;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobComplete;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;

public class SchDeviceJobDoneHandler
implements RequestHandler {
    private static final String UPDATE_RUNS = "update t_runs set number_jobs = ?, successful_jobs = ?, finish_time = ?, status = ? where device_server_run_id = ?";
    private static final String GET_JOB_RUNS = "select submit_status, return_code, finish_time from t_run_jobs where device_server_run_id = ?";
    private static final String SELECT_TRUN = "select schedule_id, run_number, device_server_id  from t_runs where device_server_run_id = ?";
    private static final String AGE_RUNS = "delete from t_runs where schedule_id = ? and run_number < ?";
    private static final String AGE_JOB_RUNS = "delete from t_run_jobs where schedule_id = ? and sid_run_number < ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobDoneHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType(DeviceJobComplete.class, (Request)request, (Response)(response = new Response(0, null)))) {
            DeviceJobComplete djc = (DeviceJobComplete)request.requestData;
            try {
                this.getDataTRun(djc);
                if (djc.dataScheduleID > 0 && djc.dataScheduleID >= 113 && djc.dataScheduleID <= 117) {
                    this.analyzeRunJobs(djc);
                    this.updateComplete(djc);
                    if (djc.status >= 0) {
                        this.ageRows(djc);
                    }
                }
            }
            finally {
                DeviceJobHndlr.updateTRunJobs(djc.dataScheduleID, djc.dataScheduleRunID, djc.deviceJobID, djc.deviceServerID);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchDeviceJobDoneHandler.class.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataTRun(DeviceJobComplete djc) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobDoneHandler.class.getName(), (String)"getDataTRun", (String)"djc");
        }
        Connection dbc = Server.getConnection();
        try {
            PreparedStatement selectStmt = dbc.prepareStatement(SELECT_TRUN);
            selectStmt.setInt(1, djc.deviceJobID);
            ResultSet rs = selectStmt.executeQuery();
            if (rs.next()) {
                djc.dataScheduleID = rs.getInt(1);
                djc.dataScheduleRunID = rs.getInt(2);
                djc.deviceServerID = rs.getInt(3);
            }
            rs.close();
            selectStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            Object[] args = new Object[]{"select", "t_runs", "SchDeviceJobDoneHandler.getDataTRun"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchDeviceJobDoneHandler.class.getName(), (String)"getDataTRun");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeRunJobs(DeviceJobComplete djc) {
        int nbrRuns = 0;
        int nbrRunsComplete = 0;
        long high_time = 0L;
        byte status = 0;
        int retcode = 0;
        int overallStatus = 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobDoneHandler.class.getName(), (String)"analyzeRunJobs", (String)"djc");
        }
        Connection dbc = Server.getConnection();
        try {
            PreparedStatement selectStmt = dbc.prepareStatement(GET_JOB_RUNS);
            selectStmt.setInt(1, djc.deviceJobID);
            ResultSet rs = selectStmt.executeQuery();
            while (rs.next()) {
                status = SQLUtil.getByte(rs, 1);
                retcode = rs.getInt(2);
                long finish_time = rs.getLong(3);
                ++nbrRuns;
                if (finish_time > high_time) {
                    high_time = finish_time;
                }
                if (retcode == 4 || retcode == 0) {
                    ++nbrRunsComplete;
                }
                if (retcode == 8) {
                    overallStatus = 0;
                    continue;
                }
                if (retcode != 4 || overallStatus == 0) continue;
                overallStatus = 3;
            }
            djc.status = overallStatus;
            djc.nbrRuns = nbrRuns;
            djc.nbrRunsComplete = nbrRunsComplete;
            djc.finish_time = high_time;
            rs.close();
            selectStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            Object[] args = new Object[]{"select", "t_runs", "SchDeviceJobDoneHandler.getDataTRun"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchDeviceJobDoneHandler.class.getName(), (String)"analyzeRunJobs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComplete(DeviceJobComplete djc) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobDoneHandler.class.getName(), (String)"updateComplete", (String)"djc");
        }
        Connection dbc = Server.getConnection();
        try {
            PreparedStatement insertStmt = dbc.prepareStatement(UPDATE_RUNS);
            insertStmt.setInt(1, djc.nbrRuns);
            insertStmt.setInt(2, djc.nbrRunsComplete);
            insertStmt.setLong(3, djc.finish_time);
            SQLUtil.setByte(insertStmt, 4, (byte)djc.status);
            insertStmt.setInt(5, djc.deviceJobID);
            insertStmt.executeUpdate();
            insertStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            Object[] args = new Object[]{"update", "t_runs", "SchDeviceJobDoneHandler.processComplete"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchDeviceJobDoneHandler.class.getName(), (String)"updateComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ageRows(DeviceJobComplete djc) {
        int retention = Server.getSettings().csRetainCopies;
        int firstRunNbr = djc.dataScheduleRunID - retention + 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobDoneHandler.class.getName(), (String)"ageRows", (String)"djc");
        }
        Connection dbc = Server.getConnection();
        try {
            PreparedStatement deleteStmt = dbc.prepareStatement(AGE_JOB_RUNS);
            deleteStmt.setInt(1, djc.dataScheduleID);
            deleteStmt.setInt(2, firstRunNbr);
            deleteStmt.executeUpdate();
            deleteStmt.close();
            deleteStmt = dbc.prepareStatement(AGE_RUNS);
            deleteStmt.setInt(1, djc.dataScheduleID);
            deleteStmt.setInt(2, firstRunNbr);
            deleteStmt.executeUpdate();
            deleteStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            Object[] args = new Object[]{"delete", "t_runs", "SchDeviceJobDoneHandler.ageRows"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchDeviceJobDoneHandler.class.getName(), (String)"ageRows");
        }
    }
}

