/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import org.eclipse.aperi.TStorm.server.guireq.DeviceJobStatusRequest;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.server.handler.scheduler.SchDeviceJobStatusHandlerThread;
import org.eclipse.aperi.xmsg.MessageLog;

public class SchDeviceJobStatusHandler
implements RequestHandler {
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        AsyncResult result = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchDeviceJobStatusHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType(DeviceJobStatusRequest.class, (Request)request, (Response)(response = new Response(0, null)))) {
            DeviceJobStatusRequest djsr = (DeviceJobStatusRequest)request.requestData;
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IJobMgmtService iJob = (IJobMgmtService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
            if (iJob == null) {
                response.errorMessage = MessageLog.getMessage((String)"SRV0451E", (Object)"IJobMgmtService");
                response.status = (short)12;
                return response;
            }
            String runNbr = Integer.toString(djsr.deviceRunID);
            int schedNumber = djsr.scheduleID;
            try {
                if (djsr.waitForComplete) {
                    response.status = (short)-99;
                    SchDeviceJobStatusHandlerThread devJobHndlrT = new SchDeviceJobStatusHandlerThread(iJob, runNbr, transceiver, dr);
                    Thread actionThread = new Thread((Runnable)devJobHndlrT, this.getClass().getName());
                    actionThread.start();
                } else {
                    result = iJob.getJobStatus(runNbr);
                }
                response.responseData = result;
            }
            catch (RemoteException e) {
                MessageLog.logException((String)"SRV0451E", (Exception)((Object)e), (Object)"handle");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"handle", (int)8);
                }
                response.errorMessage = MessageLog.getMessage((String)"SRV0703E", (Object)"waitForJobToComplete()");
                response.status = (short)12;
            }
            catch (OutOfMemoryError ome) {
                MessageLog.logException((String)"SRV0770E", (Exception)new Exception(ome.getCause()), (Object)"handle");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"handle", (int)8);
                }
                response.errorMessage = MessageLog.getMessageNoID((String)"SRV0770E");
                response.status = (short)12;
            }
            catch (Exception ute) {
                MessageLog.logException((String)"SRV0451E", (Exception)ute, (Object)"handle");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"handle", (int)8);
                }
                ute.printStackTrace();
                response.errorMessage = ute.getLocalizedMessage();
                response.status = (short)12;
            }
            catch (Throwable ute) {
                MessageLog.logException((String)"SRV0451E", (Exception)new Exception(ute), (Object)"handle");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeviceJobHndlr.class.getName(), (String)"handle", (int)8);
                }
                ute.printStackTrace();
                response.errorMessage = ute.getLocalizedMessage();
                response.status = (short)12;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchDeviceJobStatusHandler.class.getName(), (String)"handle", (Object)response);
        }
        return response;
    }
}

