/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.fabric.interfaces.IFabricInternalService;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;

public class ZoneDeviceHandler
extends DeviceJobHndlr {
    private String userName = null;

    public int deviceAPI(DeviceRequest request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneDeviceHandler.class.getName(), (String)"deviceAPI", (String)"request, response");
        }
        HashMap reqData = (HashMap)request.requestData;
        this.userName = request.userName;
        response = Response.getResponse((short)0, null);
        int jobID = GuiZoneConstants.INVALID_JOBID;
        try {
            if (reqData.containsKey(GuiZoneConstants.SAVE_ZONEDEF)) {
                ZoneDefinition zDef = (ZoneDefinition)reqData.get(GuiZoneConstants.ZONE_DEFINITION);
                Token token = (Token)reqData.get(GuiZoneConstants.TOKEN);
                Integer flag = (Integer)reqData.get(GuiZoneConstants.FLAG);
                StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
                auditMsgBuffer.append("\n Fabric Mgr: Create/Update Zone ");
                auditMsgBuffer.append("\n flag = ");
                auditMsgBuffer.append(flag);
                auditMsgBuffer.append("\n Zone Definition = ");
                auditMsgBuffer.append(zDef.toString());
                auditMsgBuffer.append("\n");
                if (TraceLogger.enableAudit) {
                    TraceLogger.auditMessage((String)ZoneDeviceHandler.class.getName(), (String)"deviceAPI()", (String)String.valueOf(auditMsgBuffer));
                }
                DeviceRequest dr = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(dr);
                AsyncResult result = null;
                IFabricInternalService iAMS = (IFabricInternalService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricInternalService.class, (String)"FabricManagerService");
                if (iAMS != null) {
                    result = iAMS.setZoneInfo(token, zDef, flag.intValue());
                }
                if (result != null) {
                    if (result.getReturnException() != null) {
                        throw result.getReturnException();
                    }
                    jobID = Integer.parseInt(result.getJobId());
                }
            }
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ZoneDeviceHandler.class.getName(), (String)"deviceAPI", (Throwable)ex);
            }
            response.status = (short)12;
            response.errorMessage = ex instanceof SRMRuntimeException ? ((SRMRuntimeException)ex).getLocalizedMessage() : ex.getMessage();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneDeviceHandler.class.getName(), (String)"deviceAPI", (int)jobID);
        }
        return jobID;
    }
}

