/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.AlertLogReq;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.handler.server.AlertLogResolver;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertLogHndlr
implements RequestHandler,
ThrowAway {
    private Connection dbc;
    private static final String[] productClasses = new String[]{AlertLogResolver.class.getName(), null, null, AlertLogResolver.class.getName()};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        String userName = null;
        if (!RequestChecker.isDesiredType(AlertLogReq.class, (Request)request, (Response)response)) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        AlertLogReq requestData = (AlertLogReq)request.requestData;
        this.dbc = Server.getConnection();
        TAlertLog accessor = new TAlertLog(this.dbc);
        Map<Short, ExtAlertLog> map = null;
        boolean madeIt = false;
        try {
            if (requestData.displayActive > 0) {
                if (requestData.displayActive == 1) {
                    userName = request.userName;
                }
                map = accessor.selectActive(requestData.productCode, userName);
            } else {
                map = requestData.alertID > 0 ? accessor.select(requestData.alertID) : (requestData.objectType >= 0 ? accessor.select(requestData.objectType, requestData.objectID, requestData.productCode, requestData.subProductCode) : accessor.select(requestData.productCode));
            }
            ExtAlertLog records = map.get((short)5);
            if (records != null) {
                this.getJobs(records);
            }
            if ((records = map.get((short)18)) != null) {
                this.getTapeDetails(records);
            }
            if (requestData.productCode == -1) {
                for (int i = 0; i < productClasses.length; ++i) {
                    String className = productClasses[i];
                    if (className == null) continue;
                    this.getProductData(className, map);
                }
            } else if (requestData.productCode == -2) {
                for (ExtAlertLog record : map.values()) {
                    String className;
                    int productID = record.alProductID;
                    if (productID > 3) {
                        productID = 0;
                    }
                    if ((className = productClasses[productID]) == null) continue;
                    this.getProductData(className, map);
                    break;
                }
            } else {
                this.getProductData(productClasses[requestData.productCode], map);
            }
            madeIt = true;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        finally {
            Server.returnConnection(this.dbc);
        }
        if (madeIt) {
            userName = request.userName;
            int[] counts = new int[productClasses.length];
            ExtAlertLog[] byProduct = new ExtAlertLog[productClasses.length];
            for (ExtAlertLog record : map.values()) {
                while (record != null) {
                    record.alNotifyUser = userName.equals(record.alNotifyUser) ? userName : null;
                    int index = record.alProductID;
                    if (index > 3) {
                        index = 0;
                    }
                    int n = index;
                    counts[n] = counts[n] + 1;
                    ExtAlertLog next = record.alnExt;
                    record.alnExt = byProduct[index];
                    byProduct[index] = record;
                    record = next;
                }
            }
            int nRecords = 0;
            ExtAlertLog[][] packed = new ExtAlertLog[counts.length][];
            for (int i = 0; i < counts.length; ++i) {
                nRecords = 0;
                ExtAlertLog head = byProduct[i];
                ExtAlertLog[] byProductPacked = new ExtAlertLog[counts[i]];
                while (head != null) {
                    ExtAlertLog record;
                    record = head.alnExt;
                    head.alnExt = null;
                    byProductPacked[nRecords] = head;
                    ++nRecords;
                    head = record;
                }
                packed[i] = byProductPacked;
            }
            response.responseData = packed;
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private void getJobs(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogHndlr.class.getName(), (String)"getJobs", (String)"records");
        }
        NameList stuff = new NameList();
        TSchedule accessor = new TSchedule(this.dbc);
        accessor.prepareSelectByID();
        while (records != null) {
            accessor.selectByID(records.alResourceID, stuff);
            records.alResourceType = stuff.nlInfo;
            records.setAlObjectName(stuff.nlName);
            records = records.alnExt;
        }
        accessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"getJobs");
        }
    }

    private void getTapeDetails(ExtAlertLog records) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogHndlr.class.getName(), (String)"getTapeDetails", (String)"records");
        }
        DBConnection mConn = new DBConnection(this.dbc);
        while (records != null) {
            block6: {
                TapeLibrary lib = null;
                Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                mWhereClause.put(TapeLibrary.getColumnInfo((String)"TAPE_LIBRARY_ID"), new Integer(records.alResourceID).toString());
                try {
                    TapeLibrary.TapeLibraryCursor mCursor = TapeLibrary.getCursor((DBConnection)mConn, mWhereClause, null);
                    if (mCursor.next()) {
                        lib = mCursor.getAttributes();
                        records.setAlObjectName(lib.getDisplayName());
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block6;
                    TraceLogger.exception((String)AlertLogHndlr.class.getName(), (String)"getTapeDetails", (Throwable)e);
                }
            }
            records = records.alnExt;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"getTapeDetails");
        }
    }

    private void getProductData(String className, Map<Short, ExtAlertLog> map) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertLogHndlr.class.getName(), (String)"getProductData", (String)"className, array");
        }
        try {
            Class<?> clazz = Class.forName(className);
            ProductAlertLogHndlr productHndlr = (ProductAlertLogHndlr)clazz.newInstance();
            productHndlr.getProductData(this, map, this.dbc);
        }
        catch (ClassNotFoundException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogHndlr.class.getName(), (String)"getProductData", (Throwable)e);
            }
            String errMsg = MessageLog.getMessageWithException((String)"STS0161E", (Exception)e, (Object)className);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"getProductData");
            }
            throw new GeneralException(errMsg);
        }
        catch (InstantiationException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogHndlr.class.getName(), (String)"getProductData", (Throwable)e);
            }
            String errMsg = MessageLog.getMessageWithException((String)"STS0161E", (Exception)e, (Object)className);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"getProductData");
            }
            throw new GeneralException(errMsg);
        }
        catch (IllegalAccessException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertLogHndlr.class.getName(), (String)"getProductData", (Throwable)e);
            }
            String errMsg = MessageLog.getMessageWithException((String)"STS0161E", (Exception)e, (Object)className);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"getProductData");
            }
            throw new GeneralException(errMsg);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertLogHndlr.class.getName(), (String)"getProductData");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProductAlertLogHndlr {
        public void getProductData(AlertLogHndlr var1, Map<Short, ExtAlertLog> var2, Connection var3) throws GeneralException;
    }
}

