/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TReportPrefs;
import org.eclipse.aperi.repository.table.TStatTotals;
import org.eclipse.aperi.repository.table.TUserPrefs;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.Roles;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.SignonResp;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.guireq.UserPreferencesSM;
import org.eclipse.aperi.server.req.SignonReq;
import org.eclipse.aperi.xmsg.LocalizableException;

public class SignonHndlr
implements RequestHandler,
ThrowAway {
    private native boolean validate(String var1, String var2) throws LocalizableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver comm) {
        boolean administrator;
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SignonHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (!RequestChecker.isDesiredType(SignonReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SignonHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        SignonReq sr = (SignonReq)request.requestData;
        try {
            administrator = this.validateUser(sr.id, sr.pwd);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SignonHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SignonHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        Connection dbc = Server.getConnection();
        if (dbc == null) {
            Server.setResponseError(response, "GEN0050E");
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SignonHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        try {
            UserPreferences prefs = new TUserPrefs(dbc).getUserPref(sr.id);
            prefs.administrator = administrator;
            prefs.sm = new UserPreferencesSM();
            prefs.sm.reportPrefs = new TReportPrefs(dbc).getPrefs(sr.id);
            SignonResp responseData = new SignonResp();
            responseData.prefs = prefs;
            TAlertLog accessor = new TAlertLog(dbc);
            responseData.activeAlerts = accessor.selectActiveIDs(sr.id);
            responseData.adminGroup = Server.adminGroup;
            responseData.sortOrderNotASCII = SQLUtil.sortOrderNotASCII;
            TStatTotals totalsAccessor = new TStatTotals(dbc);
            responseData.dashTotalsRow = totalsAccessor.select(sr.id);
            Roles roles = Roles.getInstance();
            responseData.userRoles = roles.getUserRoles(sr.id);
            responseData.deviceServerInstalled = false;
            DeviceServerManager dsm = Server.getDeviceServerManager();
            if (dsm != null) {
                responseData.deviceServerInstalled = dsm.getServerCount() > 0;
            }
            response.responseData = responseData;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SignonHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SignonHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, e);
        }
        finally {
            Server.returnConnection(dbc);
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SignonHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    public boolean validateUser(String user, String password) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SignonHndlr.class.getName(), (String)"validateUser", (String)"user, password");
        }
        boolean traceResult = this.validate(user, password);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SignonHndlr.class.getName(), (String)"validateUser", (boolean)traceResult);
        }
        return traceResult;
    }
}

