/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.jobs.Aggregation;

public abstract class AggregationMap {
    protected Connection dbc;
    protected HashMap parents = new HashMap();
    protected Aggregation networkAggregation;
    protected Aggregation aggregateList = null;
    protected MutableInteger hashKey = new MutableInteger();
    protected Aggregation factory;

    protected AggregationMap(Connection dbc) {
        this.dbc = dbc;
    }

    protected abstract void aggregate(Aggregation var1);

    protected void aggregateArrayMap(Aggregation additive, MutableInteger hashKey, HashMap map) {
        Object hashValue;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"aggregateArrayMap", (String)"additive, hashKey, map");
        }
        if ((hashValue = map.get(hashKey)) != null) {
            if (hashValue instanceof Aggregation) {
                this.addTo((Aggregation)hashValue, additive);
            } else {
                Aggregation[] array = (Aggregation[])hashValue;
                for (int i = 0; i < array.length; ++i) {
                    this.addTo(array[i], additive);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"aggregateArrayMap");
        }
    }

    public Aggregation getAggregateList() {
        return this.aggregateList;
    }

    public void clearAggregateList() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"clearAggregateList", (String)"");
        }
        while (this.aggregateList != null) {
            this.aggregateList.clear();
            this.aggregateList = this.aggregateList.agNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"clearAggregateList");
        }
    }

    protected Aggregation getUGAggregationList() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"getUGAggregationList", (String)"");
        }
        Aggregation list = this.networkAggregation;
        list.agNext = null;
        for (Aggregation a : this.parents.values()) {
            a.agNext = list;
            list = a;
        }
        Aggregation traceResult = list;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"getUGAggregationList", (Object)traceResult);
        }
        return traceResult;
    }

    protected void replaceMapValues(HashMap map, HashMap parentMap) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"replaceMapValues", (String)"map, parentMap");
        }
        for (Map.Entry entry : map.entrySet()) {
            Aggregation newValue;
            Object oldValue = entry.getValue();
            if (oldValue instanceof Aggregation) {
                newValue = this.getAggregation(parentMap, ((Aggregation)oldValue).agResourceID);
                entry.setValue(newValue);
                continue;
            }
            Aggregation[] array = (Aggregation[])oldValue;
            for (int ix = 0; ix < array.length; ++ix) {
                newValue = this.getAggregation(parentMap, array[ix].agResourceID);
                entry.setValue(newValue);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"replaceMapValues");
        }
    }

    protected void aggregate(Aggregation additive, HashMap map) {
        Aggregation aggregation;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"aggregate", (String)"additive, map");
        }
        if ((aggregation = (Aggregation)map.get(this.hashKey)) != null) {
            this.addTo(aggregation, additive);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"aggregate");
        }
    }

    protected void addTo(Aggregation aggregation, Aggregation additive) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"addTo", (String)"aggregation, additive");
        }
        aggregation.add(additive);
        if (!aggregation.agUpdated) {
            aggregation.agUpdated = true;
            aggregation.agNext = this.aggregateList;
            this.aggregateList = aggregation;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"addTo");
        }
    }

    protected Aggregation getAggregation(HashMap map, int id) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"getAggregation", (String)"map, id");
        }
        this.factory.agResourceID = id;
        Aggregation aggregation = (Aggregation)map.get(this.factory);
        if (aggregation == null) {
            aggregation = this.factory.newAggregation(id);
            map.put(aggregation, aggregation);
        }
        Aggregation traceResult = aggregation;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"getAggregation", (Object)traceResult);
        }
        return traceResult;
    }

    protected void addAggregationToMap(HashMap map, Aggregation list, int listSize, int id) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AggregationMap.class.getName(), (String)"addAggregationToMap", (String)"map, list, listSize, id");
        }
        if (listSize == 0) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AggregationMap.class.getName(), (String)"addAggregationToMap");
            }
            return;
        }
        Aggregation[] hashValue = list;
        if (listSize > 1) {
            Aggregation[] aggregation = new Aggregation[listSize];
            for (int i = 0; i < listSize; ++i) {
                aggregation[i] = list;
                list = list.agNext;
            }
            hashValue = aggregation;
        }
        map.put(new MutableInteger(id), hashValue);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AggregationMap.class.getName(), (String)"addAggregationToMap");
        }
    }
}

