/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.constants.metadata.IMetadataSource;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.repository.table.TResLibraries;
import org.eclipse.aperi.repository.table.TSavedReport;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.jobs.Aggregator;
import org.eclipse.aperi.server.jobs.CimomDiscover;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.server.jobs.SnmpDiscover;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeSource
implements IMetadataSource {
    private static final Set<Short> supportedConstants;
    private static final Map<Short, Map<String, Object>> constantMetadataMap;

    private static void registerRenameLabel(short type, String labelKey) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.RenameLabel", labelKey);
    }

    private static void registerRenameTable(short type, String table) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.RenameTable", table);
    }

    private static void registerRenameIdColumn(short type, String column) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.RenameIdColumn", column);
    }

    private static void registerRenameHasAlert(short type, boolean hasAlert) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.RenameHasAlert", hasAlert);
    }

    private static void registerListAccessor(short type, Class accessor) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.ListAccessor", accessor);
    }

    private static void registerDefaultGroup(short type, int group) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.DefaultGroup", group);
    }

    private static void registerGroupLabel(short type, String labelKey) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.GroupLabel", labelKey);
    }

    private static void registerGroupTable(short type, String table) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.GroupTable", table);
    }

    private static void registerGroupIdColumn(short type, String column) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.GroupIdColumn", column);
    }

    private static void registerGroupAccessor(short type, Class accessor) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.GroupAccessor", accessor);
    }

    private static void registerJobName(short type, String jobNameKey) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.JobName", jobNameKey);
    }

    private static void registerAgentJobRunName(short type, String name) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.AgentJobRunName", name);
    }

    private static void registerAgentJobRunCommand(short type, String command) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.AgentJobRunCommand", command);
    }

    private static void registerServerJobRunRequestCode(short type, String requestCode) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.ServerJobRunRequestCode", requestCode);
    }

    private static void registerServerJobRunHandlerCode(short type, String handlerCode) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.ServerJobRunHandlerCode", handlerCode);
    }

    private static void registerServerJobRunName(short type, String name) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.ServerJobRunName", name);
    }

    private static void registerServerJobRunCommand(short type, String command) {
        ResourceTypeSource.register(type, "org.eclipse.aperi.constants.metadata.ResourceType.ServerJobRunCommand", command);
    }

    private static void register(short resourceType, String metadataKey, Object metadataValue) {
        Map<String, Object> metadata = ResourceTypeSource.getMetadata(resourceType);
        metadata.put(metadataKey, metadataValue);
    }

    private static Map<String, Object> getMetadata(Short constantValue) {
        Map<String, Object> metadata = constantMetadataMap.get(constantValue);
        if (metadata == null) {
            metadata = new HashMap<String, Object>();
            constantMetadataMap.put(constantValue, metadata);
        }
        return metadata;
    }

    public Object getValue(Object constantValue, String metadataKey) {
        Object metadataValue = ResourceTypeSource.getMetadata((Short)constantValue).get(metadataKey);
        if (metadataValue != null && (metadataKey.equals("org.eclipse.aperi.constants.metadata.ResourceType.RenameLabel") || metadataKey.equals("org.eclipse.aperi.constants.metadata.ResourceType.GroupLabel") || metadataKey.equals("org.eclipse.aperi.constants.metadata.ResourceType.JobName"))) {
            metadataValue = MessageLog.getMessageNoID((String)((String)metadataValue));
        }
        return metadataValue;
    }

    public Set<?> getSupportedConstants() {
        return supportedConstants;
    }

    public void dispose() {
    }

    static {
        constantMetadataMap = new HashMap<Short, Map<String, Object>>();
        ResourceTypeSource.registerRenameLabel((short)0, "STS0101L");
        ResourceTypeSource.registerRenameLabel((short)2, "STS0102L");
        ResourceTypeSource.registerRenameLabel((short)14, "SRV0098L");
        ResourceTypeSource.registerRenameLabel((short)16, "STS0106L");
        ResourceTypeSource.registerRenameLabel((short)17, "STS0107L");
        ResourceTypeSource.registerRenameLabel((short)20, "STS0109L");
        ResourceTypeSource.registerRenameLabel((short)35, "STS0153L");
        ResourceTypeSource.registerRenameLabel((short)36, "STS0154L");
        ResourceTypeSource.registerRenameLabel((short)67, "STS0166L");
        ResourceTypeSource.registerRenameLabel((short)89, "STS0800L");
        ResourceTypeSource.registerRenameLabel((short)90, "STS0801L");
        ResourceTypeSource.registerRenameLabel((short)133, "STS0186L");
        ResourceTypeSource.registerRenameLabel((short)113, "STS0907L");
        String groupTable = "t_group";
        String scheduleTable = "t_schedule";
        ResourceTypeSource.registerRenameTable((short)0, groupTable);
        ResourceTypeSource.registerRenameTable((short)2, groupTable);
        ResourceTypeSource.registerRenameTable((short)14, scheduleTable);
        ResourceTypeSource.registerRenameTable((short)16, scheduleTable);
        ResourceTypeSource.registerRenameTable((short)17, scheduleTable);
        ResourceTypeSource.registerRenameTable((short)20, "t_saved_report");
        ResourceTypeSource.registerRenameTable((short)35, "t_alert_definition");
        ResourceTypeSource.registerRenameTable((short)36, scheduleTable);
        ResourceTypeSource.registerRenameTable((short)67, scheduleTable);
        ResourceTypeSource.registerRenameTable((short)89, groupTable);
        ResourceTypeSource.registerRenameTable((short)90, groupTable);
        ResourceTypeSource.registerRenameTable((short)133, groupTable);
        ResourceTypeSource.registerRenameTable((short)113, groupTable);
        String groupId = "group_id";
        String scheduleId = "schedule_id";
        ResourceTypeSource.registerRenameIdColumn((short)0, groupId);
        ResourceTypeSource.registerRenameIdColumn((short)2, groupId);
        ResourceTypeSource.registerRenameIdColumn((short)14, scheduleId);
        ResourceTypeSource.registerRenameIdColumn((short)16, scheduleId);
        ResourceTypeSource.registerRenameIdColumn((short)17, scheduleId);
        ResourceTypeSource.registerRenameIdColumn((short)20, "alert_id");
        ResourceTypeSource.registerRenameIdColumn((short)35, "report_id");
        ResourceTypeSource.registerRenameIdColumn((short)36, scheduleId);
        ResourceTypeSource.registerRenameIdColumn((short)67, scheduleId);
        ResourceTypeSource.registerRenameIdColumn((short)89, groupId);
        ResourceTypeSource.registerRenameIdColumn((short)90, groupId);
        ResourceTypeSource.registerRenameIdColumn((short)133, groupId);
        ResourceTypeSource.registerRenameIdColumn((short)113, groupId);
        ResourceTypeSource.registerRenameHasAlert((short)16, true);
        ResourceTypeSource.registerRenameHasAlert((short)17, true);
        ResourceTypeSource.registerRenameHasAlert((short)67, true);
        ResourceTypeSource.registerListAccessor((short)0, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)2, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)69, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)71, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)77, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)113, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)133, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)89, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)90, TGroup.class);
        ResourceTypeSource.registerListAccessor((short)3, TResFS.class);
        ResourceTypeSource.registerListAccessor((short)1, TStatComputer.class);
        ResourceTypeSource.registerListAccessor((short)100, TStatComputer.class);
        ResourceTypeSource.registerListAccessor((short)101, TStatComputer.class);
        ResourceTypeSource.registerListAccessor((short)20, TAlertDefinition.class);
        ResourceTypeSource.registerListAccessor((short)14, TSchedule.class);
        ResourceTypeSource.registerListAccessor((short)16, TSchedule.class);
        ResourceTypeSource.registerListAccessor((short)17, TSchedule.class);
        ResourceTypeSource.registerListAccessor((short)36, TSchedule.class);
        ResourceTypeSource.registerListAccessor((short)67, TSchedule.class);
        ResourceTypeSource.registerListAccessor((short)25, TResDomain.class);
        ResourceTypeSource.registerListAccessor((short)10, TResDevAccess.class);
        ResourceTypeSource.registerListAccessor((short)35, TSavedReport.class);
        ResourceTypeSource.registerListAccessor((short)78, TResDiskArray.class);
        ResourceTypeSource.registerListAccessor((short)99, TResCluster.class);
        ResourceTypeSource.registerListAccessor((short)114, TResFabric.class);
        ResourceTypeSource.registerListAccessor((short)134, TResLibraries.class);
        ResourceTypeSource.registerDefaultGroup((short)2, 3);
        ResourceTypeSource.registerDefaultGroup((short)0, 4);
        ResourceTypeSource.registerDefaultGroup((short)78, 8);
        ResourceTypeSource.registerDefaultGroup((short)113, 9);
        ResourceTypeSource.registerDefaultGroup((short)133, 241);
        ResourceTypeSource.registerGroupLabel((short)2, "STS0102L");
        ResourceTypeSource.registerGroupLabel((short)0, "STS0101L");
        ResourceTypeSource.registerGroupLabel((short)77, "STS0172L");
        ResourceTypeSource.registerGroupLabel((short)113, "STS0907L");
        ResourceTypeSource.registerGroupLabel((short)133, "STS0908L");
        ResourceTypeSource.registerGroupLabel((short)89, "STS0800L");
        ResourceTypeSource.registerGroupLabel((short)90, "STS0801L");
        ResourceTypeSource.registerGroupLabel((short)98, "STS0811L");
        ResourceTypeSource.registerGroupLabel((short)99, "STS0812L");
        String tGroup2Res = "t_group2res";
        ResourceTypeSource.registerGroupTable((short)2, "t_res_filesystem");
        ResourceTypeSource.registerGroupTable((short)0, "t_stat_computer");
        ResourceTypeSource.registerGroupTable((short)77, "t_res_storage_subsystem");
        ResourceTypeSource.registerGroupTable((short)113, "t_res_fabric");
        ResourceTypeSource.registerGroupTable((short)133, "t_res_tape_library");
        ResourceTypeSource.registerGroupTable((short)89, tGroup2Res);
        ResourceTypeSource.registerGroupTable((short)90, tGroup2Res);
        ResourceTypeSource.registerGroupTable((short)98, tGroup2Res);
        ResourceTypeSource.registerGroupTable((short)99, tGroup2Res);
        ResourceTypeSource.registerGroupIdColumn((short)2, "filesystem_id");
        ResourceTypeSource.registerGroupIdColumn((short)0, "computer_id");
        ResourceTypeSource.registerGroupIdColumn((short)77, "subsystem_id");
        ResourceTypeSource.registerGroupIdColumn((short)113, "fabric_id");
        ResourceTypeSource.registerGroupIdColumn((short)133, "tape_library_id");
        ResourceTypeSource.registerGroupAccessor((short)2, TResFS.class);
        ResourceTypeSource.registerGroupAccessor((short)0, TStatComputer.class);
        ResourceTypeSource.registerGroupAccessor((short)77, TResDiskArray.class);
        ResourceTypeSource.registerGroupAccessor((short)113, TResFabric.class);
        ResourceTypeSource.registerGroupAccessor((short)133, TResLibraries.class);
        ResourceTypeSource.registerJobName((short)16, "STS0106L");
        ResourceTypeSource.registerJobName((short)17, "STS0107L");
        ResourceTypeSource.registerJobName((short)31, "STS0127L");
        ResourceTypeSource.registerJobName((short)32, "STS0122L");
        ResourceTypeSource.registerJobName((short)36, "STS0155L");
        ResourceTypeSource.registerJobName((short)67, "JSS0072L");
        ResourceTypeSource.registerJobName((short)73, "STS0170L");
        ResourceTypeSource.registerJobName((short)65, "STS0122L");
        ResourceTypeSource.registerJobName((short)104, "STS0122L");
        ResourceTypeSource.registerJobName((short)105, "STS0122L");
        ResourceTypeSource.registerAgentJobRunName((short)16, "probe");
        ResourceTypeSource.registerAgentJobRunName((short)32, "discovery");
        ResourceTypeSource.registerAgentJobRunName((short)36, "report");
        ResourceTypeSource.registerAgentJobRunCommand((short)16, "org.eclipse.aperi.agent.probe.ExecProbe");
        ResourceTypeSource.registerAgentJobRunCommand((short)32, "org.eclipse.aperi.agent.discovery.ExecDiscovery domain");
        ResourceTypeSource.registerAgentJobRunCommand((short)36, "org.eclipse.aperi.agent.report.ExecReport");
        ResourceTypeSource.registerServerJobRunRequestCode((short)104, "org.eclipse.aperi.server.svp.CimomSvp");
        ResourceTypeSource.registerServerJobRunRequestCode((short)105, "org.eclipse.aperi.server.svp.CimomSvp");
        ResourceTypeSource.registerServerJobRunRequestCode((short)16, "org.eclipse.aperi.server.svp.CimomSvp");
        ResourceTypeSource.registerServerJobRunRequestCode((short)17, "org.eclipse.aperi.server.svp.AgentSvp");
        ResourceTypeSource.registerServerJobRunRequestCode((short)31, "org.eclipse.aperi.server.svp.AgentSvp");
        ResourceTypeSource.registerServerJobRunHandlerCode((short)104, "org.eclipse.aperi.server.handler.scheduler.JobHndlr.CIMOM");
        ResourceTypeSource.registerServerJobRunHandlerCode((short)105, "org.eclipse.aperi.server.handler.scheduler.JobHndlr.CIMOM");
        ResourceTypeSource.registerServerJobRunHandlerCode((short)16, "org.eclipse.aperi.server.handler.scheduler.JobHndlr.CIMOM");
        ResourceTypeSource.registerServerJobRunHandlerCode((short)17, "org.eclipse.aperi.server.handler.scheduler.JobHndlr.Agent");
        ResourceTypeSource.registerServerJobRunHandlerCode((short)31, "org.eclipse.aperi.server.handler.scheduler.JobHndlr.Agent");
        ResourceTypeSource.registerServerJobRunName((short)104, "cimom_discover");
        ResourceTypeSource.registerServerJobRunName((short)105, "snmp_discover");
        ResourceTypeSource.registerServerJobRunName((short)17, "ping");
        ResourceTypeSource.registerServerJobRunName((short)31, "aggregator");
        ResourceTypeSource.registerServerJobRunCommand((short)104, CimomDiscover.class.getName());
        ResourceTypeSource.registerServerJobRunCommand((short)105, SnmpDiscover.class.getName());
        ResourceTypeSource.registerServerJobRunCommand((short)17, Ping.class.getName());
        ResourceTypeSource.registerServerJobRunCommand((short)31, Aggregator.class.getName());
        supportedConstants = Collections.unmodifiableSet(constantMetadataMap.keySet());
    }
}

