/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.svp;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentConfigParser {
    private String configFile;
    private BufferedReader reader = null;
    private StreamTokenizer tokenizer;
    private int threadPoolSize;
    private int maxThreads;
    private String currentSection;
    private final String SERVER_SECTION = "server";
    private final String GUI_SECTION = "gui";

    public AgentConfigParser(String configFile) {
        this.configFile = configFile;
    }

    public void parse() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"parse", (String)"");
        }
        try {
            this.initializeTokenizer();
            this.tokenize();
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AgentConfigParser.class.getName(), (String)"parse", (Throwable)e);
            }
            MessageLog.logException((String)"STS0003E", (Exception)e, (Object)this.configFile);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"parse");
            }
            throw new Exception();
        }
        finally {
            block15: {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block15;
                        TraceLogger.exception((String)AgentConfigParser.class.getName(), (String)"parse", (Throwable)e);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"parse");
        }
    }

    private void initializeTokenizer() throws Exception {
        this.reader = new BufferedReader(new FileReader(this.configFile));
        this.tokenizer = new StreamTokenizer(this.reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(92, 92);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.lowerCaseMode(false);
    }

    private void tokenize() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"tokenize", (String)"");
        }
        while (this.nextToken(false, 91) != -1) {
            this.nextToken(true, -3);
            this.currentSection = this.tokenizer.sval;
            this.nextToken(true, 93);
            if (this.currentSection.equalsIgnoreCase("server")) {
                this.serverSection();
                AgentSvp.srvThreadPoolSize = this.threadPoolSize;
                AgentSvp.srvMaxThreads = this.maxThreads;
                continue;
            }
            if (this.currentSection.equalsIgnoreCase("gui")) {
                this.guiSection();
                AgentSvp.guiThreadPoolSize = this.threadPoolSize;
                AgentSvp.guiMaxThreads = this.maxThreads;
                continue;
            }
            this.throwException("STS0004E", this.currentSection, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"tokenize");
        }
    }

    private int nextToken(boolean tokenRequired, int expectedTokenType) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"nextToken", (String)"tokenRequired, expectedTokenType");
        }
        if (this.tokenizer.ttype != -1) {
            this.tokenizer.nextToken();
        }
        if (this.tokenizer.ttype == -1) {
            if (tokenRequired) {
                this.throwException("STS0005E", null, null);
            }
        } else {
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                this.tokenizer.ttype = -3;
            }
            if (expectedTokenType != 0 && expectedTokenType != this.tokenizer.ttype) {
                this.throwException("STS0006E", this.tokenizer.toString(), null);
            }
        }
        int traceResult = this.tokenizer.ttype;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"nextToken", (int)traceResult);
        }
        return traceResult;
    }

    private void serverSection() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"serverSection", (String)"");
        }
        String[] keyValuePair = new String[2];
        while (this.getKeyValuePair(keyValuePair)) {
            int c;
            if (keyValuePair[0].equalsIgnoreCase("pingreceivetimeout")) {
                int timeout = this.stringToInt(keyValuePair);
                if (timeout < 3 || timeout > 60) continue;
                AgentSvp.pingReceiveTimeout = timeout;
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("savenonroot")) {
                c = 110;
                if (!Util.isEmpty((String)keyValuePair[1])) {
                    c = Character.toLowerCase(keyValuePair[1].charAt(0));
                }
                if (c != 121 && c != 49) continue;
                AgentSvp.saveNonRootExports = true;
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("abbreviatedprobe")) {
                c = 110;
                if (!Util.isEmpty((String)keyValuePair[1])) {
                    c = Character.toLowerCase(keyValuePair[1].charAt(0));
                }
                if (c != 121 && c != 49) continue;
                AgentSvp.abbreviatedProbe = true;
                continue;
            }
            this.threadParms(keyValuePair);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"serverSection");
        }
    }

    private void guiSection() throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"guiSection", (String)"");
        }
        String[] keyValuePair = new String[2];
        while (this.getKeyValuePair(keyValuePair)) {
            if (keyValuePair[0].equalsIgnoreCase("reportRowLimit")) {
                int rowLimit = this.stringToInt(keyValuePair);
                if (rowLimit <= 0 || rowLimit > 10000) continue;
                AgentSvp.reportRowLimit = rowLimit;
                continue;
            }
            if (keyValuePair[0].equalsIgnoreCase("keepCachedReport")) {
                int keepTime = this.stringToInt(keyValuePair);
                if (keepTime < 30 || keepTime > 600) continue;
                AgentSvp.keepCachedReport = keepTime;
                continue;
            }
            this.threadParms(keyValuePair);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"guiSection");
        }
    }

    private void threadParms(String[] keyValuePair) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"threadParms", (String)"keyValuePair");
        }
        if (keyValuePair[0].equalsIgnoreCase("threadpoolsize")) {
            this.threadPoolSize = this.stringToInt(keyValuePair);
            if (this.threadPoolSize < 1) {
                this.throwException("STS0007E", this.currentSection, "threadpoolsize");
            }
        } else if (keyValuePair[0].equalsIgnoreCase("maxthreads")) {
            this.maxThreads = this.stringToInt(keyValuePair);
            if (this.maxThreads < 1) {
                this.throwException("STS0007E", this.currentSection, "maxThreads");
            }
        } else {
            this.throwException("STS0008E", this.currentSection, keyValuePair[0]);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"threadParms");
        }
    }

    private boolean getKeyValuePair(String[] keyValuePair) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"getKeyValuePair", (String)"keyValuePair");
        }
        if (this.nextToken(false, 0) == -1) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"getKeyValuePair", (boolean)traceResult);
            }
            return traceResult;
        }
        if (this.tokenizer.ttype == 91) {
            this.tokenizer.pushBack();
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"getKeyValuePair", (boolean)traceResult);
            }
            return traceResult;
        }
        if (this.tokenizer.ttype != -3) {
            this.throwException("STS0006E", this.tokenizer.toString(), null);
        }
        keyValuePair[0] = this.tokenizer.sval.toLowerCase();
        this.nextToken(true, 61);
        this.nextToken(true, -3);
        keyValuePair[1] = this.tokenizer.sval;
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"getKeyValuePair", (boolean)traceResult);
        }
        return traceResult;
    }

    private int stringToInt(String[] keyValuePair) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"stringToInt", (String)"keyValuePair");
        }
        try {
            int traceResult = Integer.parseInt(keyValuePair[1]);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"stringToInt", (int)traceResult);
            }
            return traceResult;
        }
        catch (NumberFormatException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AgentConfigParser.class.getName(), (String)"stringToInt", (Throwable)e);
            }
            this.throwException("STS0007E", this.currentSection, keyValuePair[0]);
            int traceResult = -1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"stringToInt", (int)traceResult);
            }
            return traceResult;
        }
    }

    private void throwException(String msgId, String parm1, String parm2) throws Exception {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentConfigParser.class.getName(), (String)"throwException", (String)"msgId, parm1, parm2");
        }
        Object[] args = new Object[]{parm1, parm2};
        String msg = MessageLog.getMessage((String)msgId, (Object[])args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentConfigParser.class.getName(), (String)"throwException");
        }
        throw new Exception(msg.substring("                         ".length()));
    }
}

