/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.svp;

import java.io.File;
import org.eclipse.aperi.backend.SectionedConfigParser;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class CimomConfig {
    private static final int THREAD_POOL_SIZE_KEY = 0;
    private static final int MAX_THREADS_KEY = 1;
    private static final int SPAWN_THREAD_TRIGGER_KEY = 2;
    private static final String configFile = "configuration" + File.separator + "Cimom.config";
    public static final int DEFAULT_THREAD_POOL_SIZE = 2;
    public static final int DEFAULT_MAX_THREADS = 5;
    public static final int DEFAULT_SPAWN_THREAD_TRIGGER = 2;
    public static final String[] SECTION_NAMES = new String[]{"threads"};
    public String[][] threadKeys = new String[][]{{"threadPoolSize", "2"}, {"maxThreads", "5"}, {"spawnThreadTrigger", "2"}};
    public String[][][] sectionKeyWords = new String[][][]{this.threadKeys};
    public int threadPoolSize = 2;
    public int maxThreads = 5;
    public int spawnThreadTrigger = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigSettings() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CimomConfig.class.getName(), (String)"getConfigSettings", (String)"");
        }
        if (!new File(configFile).exists()) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CimomConfig.class.getName(), (String)"getConfigSettings");
            }
            return;
        }
        MessageLog.logMessage((String)"STS0001I", (Object)configFile);
        SectionedConfigParser parser = null;
        try {
            parser = new SectionedConfigParser(configFile, SECTION_NAMES, this.sectionKeyWords);
            parser.nextSection();
            this.threadPoolSize = this.getNumber(0, 2, 1, 10);
            this.maxThreads = this.getNumber(1, 5, 1, 16);
            this.spawnThreadTrigger = this.getNumber(2, 2, 1, 10);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CimomConfig.class.getName(), (String)"getConfigSettings", (Throwable)e);
            }
            e.print();
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CimomConfig.class.getName(), (String)"getConfigSettings");
        }
    }

    private int getNumber(int key, int defaultValue, int min, int max) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CimomConfig.class.getName(), (String)"getNumber", (String)"key, defaultValue, min, max");
        }
        int returnValue = defaultValue;
        boolean bad = false;
        String value = this.threadKeys[key][1];
        if (value == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CimomConfig.class.getName(), (String)"getNumber", (int)defaultValue);
            }
            return defaultValue;
        }
        try {
            returnValue = Integer.parseInt(value);
            if (returnValue < min || returnValue > max) {
                bad = true;
            }
        }
        catch (NumberFormatException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CimomConfig.class.getName(), (String)"getNumber", (Throwable)e);
            }
            bad = true;
        }
        if (bad) {
            Object[] args = new Object[]{this.threadKeys[key][0], Integer.toString(min), Integer.toString(max), Integer.toString(defaultValue)};
            MessageLog.logMessage((String)"JSS0062W", (Object[])args);
            returnValue = defaultValue;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CimomConfig.class.getName(), (String)"getNumber", (int)returnValue);
        }
        return returnValue;
    }
}

