/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.svp;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.ScheduleBounce;
import org.eclipse.aperi.scheduler.ScheduleBuild;
import org.eclipse.aperi.scheduler.ScheduleComplete;
import org.eclipse.aperi.scheduler.ScheduleRunning;
import org.eclipse.aperi.scheduler.ScheduleSubmit;
import org.eclipse.aperi.scheduler.ScheduleSubmitted;
import org.eclipse.aperi.server.RequestManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceProvider;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.SvpThreadGroup;
import org.eclipse.aperi.server.handler.scheduler.ScheduleConfig;
import org.eclipse.aperi.xmsg.MessageLog;

public class SchedulerSvp
extends ServiceProvider {
    public static final String EXTENSION_POINT_ID = "org.eclipse.aperi.server.data.schedulerHandler";
    public static ServiceQueue serviceQueue;
    public static SvpThreadGroup threadGroup;
    public static RequestManager requestManagerRoutine;
    static final String[] serviceTable;
    FileOutputStream logStream;
    PrintWriter logWriter;
    ScheduleComplete completeTask;
    ScheduleSubmit submitTask;

    public String getTypeCode() {
        return "org.eclipse.aperi.server.svp.SchedulerSvp";
    }

    public void startup(ServiceQueue sQueue) throws Exception {
        TraceLoggerFactory.startLogger((String)"ITSRM.logger.trace.Scheduler", (String)"org.eclipse.aperi.server.svp.SchedulerSvp");
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchedulerSvp.class.getName(), (String)"startup", (String)"sQueue");
        }
        serviceQueue = sQueue;
        SchCommon.clear();
        SchCommon.scheduler = this;
        try {
            SchCommon.startMillis = CurrentTime.getTimestamp().getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SchedulerSvp.class.getName(), (String)"startup", (Throwable)e);
            }
            return;
        }
        this.logWriter = Server.initMessageLog("org.eclipse.aperi.server.svp.SchedulerSvp");
        MessageLog.logMessage((String)"JSS0001I");
        if (SchCommon.autoRestart) {
            MessageLog.logMessage((String)"JSS0076L");
        }
        new ScheduleConfig();
        threadGroup = new SvpThreadGroup("Scheduler", serviceTable);
        SchCommon.submittedRoutine = new ScheduleSubmitted();
        SchCommon.runningRoutine = new ScheduleRunning();
        SchCommon.buildTask = new ScheduleBuild(threadGroup, "ScheduleBuild");
        for (int x = 0; x < SchCommon.submitThreads; ++x) {
            this.submitTask = new ScheduleSubmit(threadGroup, "ScheduleSubmit-" + x);
            this.submitTask.next = SchCommon.submitHdr;
            SchCommon.submitHdr = this.submitTask;
            this.submitTask.start();
        }
        SchCommon.buildTask.start();
        this.submitTask = SchCommon.submitHdr;
        while (!SchCommon.stopped && this.submitTask != null) {
            while (!SchCommon.stopped && !this.submitTask.initialized) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)SchedulerSvp.class.getName(), (String)"startup", (Throwable)e);
                }
            }
            this.submitTask = this.submitTask.next;
        }
        if (SchCommon.stopped) {
            if (SchCommon.bounceTask != null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SchedulerSvp.class.getName(), (String)"startup");
                }
                throw new GeneralException(MessageLog.getMessage((String)"JSS0074E", null));
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SchedulerSvp.class.getName(), (String)"startup");
            }
            throw new GeneralException(MessageLog.getMessage((String)"JSS0002E", null));
        }
        MessageLog.logMessage((String)"JSS0003I");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchedulerSvp.class.getName(), (String)"startup");
        }
    }

    public void shutdown(byte shutdownType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchedulerSvp.class.getName(), (String)"shutdown", (String)"shutdownType");
        }
        SchCommon.shutDown = true;
        SchCommon.stopped = true;
        if (shutdownType != -67) {
            SchCommon.killed = true;
        }
        TraceLoggerFactory.stopLogger((String)this.getTypeCode());
        MessageLog.logMessage((String)"JSS0004I");
        if (requestManagerRoutine != null) {
            requestManagerRoutine.dispose();
            requestManagerRoutine = null;
        }
        if (SchCommon.buildTask != null) {
            block13: {
                block12: {
                    SchCommon.buildTask.interrupt();
                    try {
                        SchCommon.buildTask.join(120000L);
                    }
                    catch (InterruptedException e) {
                        if (!TraceLogger.enableTrace) break block12;
                        TraceLogger.exception((String)SchedulerSvp.class.getName(), (String)"shutdown", (Throwable)e);
                    }
                }
                try {
                    SchCommon.buildTask.finalize();
                }
                catch (Throwable e) {
                    if (!TraceLogger.enableTrace) break block13;
                    TraceLogger.exception((String)SchedulerSvp.class.getName(), (String)"shutdown", (Throwable)e);
                }
            }
            SchCommon.buildTask = null;
        }
        this.submitTask = SchCommon.submitHdr;
        while (this.submitTask != null) {
            block14: {
                this.submitTask.interrupt();
                try {
                    this.submitTask.join(120000L);
                }
                catch (InterruptedException e) {
                    if (!TraceLogger.enableTrace) break block14;
                    TraceLogger.exception((String)SchedulerSvp.class.getName(), (String)"shutdown", (Throwable)e);
                }
            }
            this.submitTask = this.submitTask.next;
        }
        SchCommon.submitHdr = null;
        MessageLog.logMessage((String)"JSS0005I");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchedulerSvp.class.getName(), (String)"shutdown");
        }
    }

    public static boolean connectBad(Connection dbc) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchedulerSvp.class.getName(), (String)"connectBad", (String)"dbc");
        }
        boolean result = false;
        if (dbc != null) {
            try {
                dbc.rollback();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)SchedulerSvp.class.getName(), (String)"connectBad", (Throwable)e);
                }
                result = true;
            }
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchedulerSvp.class.getName(), (String)"connectBad", (boolean)traceResult);
        }
        return traceResult;
    }

    public static void bounce() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SchedulerSvp.class.getName(), (String)"bounce", (String)"");
        }
        MessageLog.logMessage((String)"JSS0075W");
        SchCommon.bounceTask = new ScheduleBounce(threadGroup, "ScheduleBounce");
        SchCommon.bounceTask.start();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SchedulerSvp.class.getName(), (String)"bounce");
        }
    }

    static {
        serviceTable = new String[]{"org.eclipse.aperi.server.svp.SchedulerSvp"};
    }
}

