/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util;

import java.net.Socket;
import java.util.Date;
import org.eclipse.aperi.common.LockRequestor;
import org.eclipse.aperi.common.LockResource;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;

public class ShowLocks {
    private static String hostName;
    private static int port;
    private static Request request;
    private static LockResource requestData;
    private static String indent;
    private static Date date;
    private static final String[] LOCK_TYPE;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: ShowLocks <server-host> <server-port>");
            System.exit(1);
        }
        hostName = args[0];
        port = Integer.parseInt(args[1]);
        requestData = new LockResource();
        request = new Request();
        ShowLocks.request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        ShowLocks.request.subType = "org.eclipse.aperi.server.handler.server.LockQueryHndlr";
        ShowLocks.request.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.server.svp.ServerSvp");
        ShowLocks.request.flags = (byte)5;
        ShowLocks.request.requestData = requestData;
        ShowLocks.print("Server Side Locks As Of: " + date);
        ShowLocks.lockQuery((short)0);
        ShowLocks.lockQuery((short)1);
        ShowLocks.lockQuery((short)2);
        ShowLocks.lockQuery((short)3);
    }

    private static void lockQuery(short productID) {
        ShowLocks.requestData.lrsProductID = productID;
        Socket connection = null;
        try {
            connection = new Socket(hostName, port);
        }
        catch (Exception e) {
            System.out.println("Unable to open socket");
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            return;
        }
        SocketTransceiver transceiver = new SocketTransceiver(connection, hostName);
        Response response = transceiver.transmitRequest(request, null);
        transceiver.close();
        LockResource results = null;
        if (response != null) {
            results = LockResource.unpack((LockResource[])((LockResource[])response.responseData));
        }
        if (results != null) {
            System.out.println("Locks for: " + LockResource.productName[productID]);
            ShowLocks.printLocks(results);
        }
    }

    private static void printLocks(LockResource lrs) {
        while (lrs != null) {
            indent = "  ";
            ShowLocks.print("Resource: " + lrs.lrsResource);
            indent = "    ";
            ShowLocks.print("Lock Holders: ");
            ShowLocks.printRequestors(lrs.lrsHolders);
            indent = "    ";
            ShowLocks.print("Lock Waiters: ");
            ShowLocks.printRequestors(lrs.lrsWaitersHead);
            ShowLocks.print("");
            lrs = lrs.lrsNext;
        }
    }

    private static void printRequestors(LockRequestor lrq) {
        indent = indent + "  ";
        while (lrq != null) {
            date.setTime(lrq.lrqTimestamp);
            ShowLocks.print("Thread: " + lrq.lrqThread + ", Type: " + LOCK_TYPE[lrq.lrqLockType]);
            ShowLocks.print("Time  : " + date + "\n");
            lrq = lrq.lrqNext;
        }
    }

    private static void print(String text) {
        System.out.println(indent + text);
    }

    static {
        indent = "";
        date = new Date();
        LOCK_TYPE = new String[]{"", "Exclusive", "Shared"};
    }
}

