/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.smtp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.LimitedWaitOutputStream;
import org.eclipse.aperi.server.util.smtp.BadRecipientException;
import org.eclipse.aperi.server.util.smtp.Email;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class SmtpTransmitter {
    private static final String CRLF = "\r\n";
    private static final int MAX_TEXT_LINE = 998;
    private static final int TIMEOUT_IN_SECONDS = 120;
    private static final String HELO_CMD = "HELO ";
    private static final String MAIL_CMD = "MAIL FROM:";
    private static final String RCPT_CMD = "RCPT TO:";
    private static final String DATA_CMD = "DATA ";
    private static final String QUIT_CMD = "QUIT ";
    private static final String RSET_CMD = "RSET ";
    private static final String[] monthTable = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private Socket socket;
    private String smtpServerName;
    private int smtpServerPort;
    private String localHostName;
    private String date;
    private BufferedReader reader;
    private BufferedWriter writer;
    private String lastCmd = "";
    private String reply;
    private int replyCode;

    public SmtpTransmitter(String smtpServerName, int smtpServerPort) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"SmtpTransmitter", (String)"smtpServerName, smtpServerPort");
        }
        this.smtpServerName = smtpServerName;
        this.smtpServerPort = smtpServerPort;
        Date currentDate = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentDate);
        int i = cal.get(2);
        String month = monthTable[i];
        int utcOffset = cal.get(15);
        utcOffset = utcOffset < 0 ? (utcOffset += cal.get(16)) : (utcOffset -= cal.get(16));
        long zone = (utcOffset /= 60000) / 60 * 100 + utcOffset % 60;
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd '" + month + "' yy HH:mm ");
        StringBuffer dateBuffer = new StringBuffer(30);
        dateBuffer.append(dateFormatter.format(currentDate));
        DecimalFormat zoneFormatter = new DecimalFormat("+0000;-0000");
        dateBuffer.append(zoneFormatter.format(zone));
        this.date = dateBuffer.toString();
        this.localHostName = HardwareID.getLocalHostName();
        try {
            this.socket = new Socket(this.smtpServerName, this.smtpServerPort);
            this.socket.setSoTimeout(120000);
            InputStream in = this.socket.getInputStream();
            this.reader = new BufferedReader(new InputStreamReader(in));
            OutputStream out = this.socket.getOutputStream();
            out = new LimitedWaitOutputStream(out, 120);
            this.writer = new BufferedWriter(new OutputStreamWriter(out));
        }
        catch (UnknownHostException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"SmtpTransmitter", (Throwable)e);
            }
            this.closeIO();
            this.throwException("GEN0113E", e);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"SmtpTransmitter", (Throwable)e);
            }
            this.closeIO();
            Object[] args = new Object[]{this.smtpServerName, new Integer(this.smtpServerPort)};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"SmtpTransmitter");
            }
            throw new NestableException("GEN0114E", args, (Exception)e);
        }
        try {
            this.getReply();
            this.checkReplyCode();
            this.sendCmd(HELO_CMD, this.localHostName);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"SmtpTransmitter", (Throwable)e);
            }
            this.close();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"SmtpTransmitter");
            }
            throw e;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"SmtpTransmitter");
        }
    }

    public void close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"close", (String)"");
        }
        if (this.reader != null && this.writer != null) {
            try {
                this.sendCmd(QUIT_CMD, null);
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"close", (Throwable)e);
                }
                e.print();
            }
        }
        this.closeIO();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"close");
        }
    }

    private void closeIO() {
        IOException ex;
        block11: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"closeIO", (String)"");
            }
            boolean closed = this.socket == null;
            ex = null;
            if (this.writer != null) {
                try {
                    this.writer.close();
                    closed = true;
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"closeIO", (Throwable)e);
                    }
                    ex = e;
                }
            }
            this.writer = null;
            if (!closed) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"closeIO", (Throwable)e);
                    }
                    if (ex == null) break block11;
                    ex = e;
                }
            }
        }
        this.socket = null;
        if (ex != null) {
            MessageLog.logException((String)"GEN0021E", (Exception)ex, (Object)this.smtpServerName);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"closeIO");
        }
    }

    public void sendMail(Email email) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"sendMail", (String)"email");
        }
        try {
            String[] recipientList = this.copyRecipients(email);
            String returnPath = email.returnPath;
            String replyTo = email.replyTo;
            this.sendPath(MAIL_CMD, returnPath);
            this.checkReplyCode();
            int elements = recipientList.length;
            String[] badRcptList = new String[elements];
            String[] badRcptReason = new String[elements];
            int badRcptIndex = 0;
            for (int i = 0; i < elements; ++i) {
                String recipient = recipientList[i];
                this.sendPath(RCPT_CMD, recipient);
                if (this.replyCode >= 550 && this.replyCode <= 553) {
                    badRcptList[badRcptIndex] = recipient;
                    badRcptReason[badRcptIndex++] = this.reply;
                    continue;
                }
                this.checkReplyCode();
            }
            if (badRcptIndex == elements) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendMail");
                }
                throw new BadRecipientException(this.smtpServerName, badRcptList, badRcptReason, false);
            }
            this.sendData(email, returnPath, replyTo, recipientList);
            this.sendCRLF();
            this.send('.');
            this.sendCRLF();
            this.getReply();
            this.checkReplyCode();
            if (badRcptIndex != 0) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendMail");
                }
                throw new BadRecipientException(this.smtpServerName, badRcptList, badRcptReason, true);
            }
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"sendMail", (Throwable)e);
            }
            try {
                this.sendCmd(RSET_CMD, null);
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendMail");
            }
            throw e;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendMail");
        }
    }

    private String[] copyRecipients(Email email) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"copyRecipients", (String)"email");
        }
        Vector<String> v = email.recipientList;
        String[] recipientList = new String[v.size()];
        for (int i = 0; i < recipientList.length; ++i) {
            recipientList[i] = v.elementAt(i);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"copyRecipients", (Object)recipientList);
        }
        return recipientList;
    }

    private void sendData(Email email, String returnPath, String replyTo, String[] recipientList) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"sendData", (String)"email, returnPath, replyTo, recipientList");
        }
        this.sendCmd(DATA_CMD, null);
        this.checkReplyCode();
        this.send("Date: ");
        this.send(this.date);
        this.sendCRLF();
        MutableBoolean unchanged = new MutableBoolean();
        this.send("From: ");
        if (email.from == null) {
            this.send(replyTo);
        } else {
            String from = SmtpTransmitter.possiblyEncodeHeaderLine(email.from, 6, unchanged);
            if (unchanged.value) {
                if (from.charAt(0) != '\"') {
                    this.send('\"');
                }
                this.send(from);
                if (from.charAt(0) != '\"') {
                    this.send('\"');
                }
            } else {
                this.send(from);
                this.send(' ');
            }
            this.send('<');
            this.send(replyTo);
            this.send('>');
        }
        this.sendCRLF();
        if (email.subject != null) {
            this.send("Subject: ");
            this.send(SmtpTransmitter.possiblyEncodeHeaderLine(email.subject, 9, unchanged));
            this.sendCRLF();
        }
        this.send("To: ");
        for (int i = 0; i < recipientList.length; ++i) {
            if (i > 0) {
                this.send(',');
                this.sendCRLF();
                this.send(' ');
            }
            this.send(recipientList[i]);
        }
        this.sendCRLF();
        this.send("Mime-Version: 1.0");
        this.sendCRLF();
        this.send("Content-Type: text/plain; charset=UTF-8");
        this.sendCRLF();
        String text = SmtpTransmitter.possiblyEncodeBody(email.text, unchanged);
        if (!unchanged.value) {
            this.send("Content-Transfer-Encoding: quoted-printable");
            this.sendCRLF();
        }
        this.sendCRLF();
        int ofst = 0;
        int nextOfst = 0;
        int length = 0;
        while (ofst < text.length()) {
            int i;
            if (text.charAt(ofst) == '.') {
                this.send('.');
            }
            if ((i = text.indexOf(10, ofst)) != -1 && i - ofst < 998) {
                length = i - ofst;
                if (length > 0 && text.charAt(i - 1) == '\r') {
                    --length;
                }
                nextOfst = i + 1;
            } else {
                length = text.length() - ofst;
                if (length <= 998) {
                    nextOfst = text.length();
                } else {
                    for (i = ofst + 998 - 1; i > ofst && !Character.isWhitespace(text.charAt(i)); --i) {
                    }
                    if (i == ofst) {
                        i = ofst + 998;
                    }
                    length = i - ofst;
                    nextOfst = i;
                }
            }
            this.send(text, ofst, length);
            this.sendCRLF();
            ofst = nextOfst;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendData");
        }
    }

    private static String possiblyEncodeHeaderLine(String s, int pos, MutableBoolean unchanged) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"possiblyEncodeHeaderLine", (String)"s, pos, unchanged");
        }
        if (SmtpTransmitter.fineAsIs(s, unchanged)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"possiblyEncodeHeaderLine", (Object)s);
            }
            return s;
        }
        int length = s.length();
        short[] array = new short[3];
        StringBuffer buf = new StringBuffer(200);
        boolean atStartOfLine = true;
        int i = 0;
        while (i < length) {
            int outputBytes;
            int c;
            int characterSize;
            if (atStartOfLine) {
                buf.append("=?UTF-8?Q?");
                pos += 10;
                atStartOfLine = false;
            }
            if ((characterSize = SmtpTransmitter.getUTF8CharacterSize(c = s.charAt(i))) != 1) {
                outputBytes = characterSize * 3;
            } else {
                switch (c) {
                    case 61: 
                    case 63: 
                    case 95: {
                        outputBytes = 3;
                        break;
                    }
                    case 32: {
                        c = 95;
                    }
                    default: {
                        outputBytes = 1;
                    }
                }
            }
            if (pos + outputBytes > 74) {
                buf.append("?=\r\n ");
                pos = 1;
                atStartOfLine = true;
                continue;
            }
            if (outputBytes == 1) {
                buf.append((char)c);
            } else {
                SmtpTransmitter.appendEscapedUTF8(buf, c, characterSize, array);
            }
            ++i;
            pos += outputBytes;
        }
        buf.append("?=");
        String traceResult = buf.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"possiblyEncodeHeaderLine", (Object)traceResult);
        }
        return traceResult;
    }

    private static String possiblyEncodeBody(String s, MutableBoolean unchanged) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"possiblyEncodeBody", (String)"s, unchanged");
        }
        if (SmtpTransmitter.fineAsIs(s, unchanged)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"possiblyEncodeBody", (Object)s);
            }
            return s;
        }
        short[] array = new short[3];
        StringBuffer buf = new StringBuffer(1000);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            boolean mustEscape;
            char c = s.charAt(i);
            int characterSize = SmtpTransmitter.getUTF8CharacterSize(c);
            boolean bl = mustEscape = characterSize > 1 || c == '=';
            if (mustEscape) {
                SmtpTransmitter.appendEscapedUTF8(buf, c, characterSize, array);
                continue;
            }
            buf.append(c);
        }
        String traceResult = buf.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"possiblyEncodeBody", (Object)traceResult);
        }
        return traceResult;
    }

    private static boolean fineAsIs(String s, MutableBoolean unchanged) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"fineAsIs", (String)"s, unchanged");
        }
        int length = s.length();
        unchanged.value = true;
        int i = 0;
        while (unchanged.value && i < length) {
            if (s.charAt(i) < '\u0080') {
                ++i;
                continue;
            }
            unchanged.value = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"fineAsIs", (boolean)unchanged.value);
        }
        return unchanged.value;
    }

    private static int getUTF8CharacterSize(int c) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"getUTF8CharacterSize", (String)"c");
        }
        int result = c < 128 ? 1 : (c < 2048 ? 2 : 3);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"getUTF8CharacterSize", (int)result);
        }
        return result;
    }

    private static void appendEscapedUTF8(StringBuffer buf, int c, int characterSize, short[] array) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"appendEscapedUTF8", (String)"buf, c, characterSize, array");
        }
        switch (characterSize) {
            case 1: {
                array[0] = (short)c;
                break;
            }
            case 2: {
                array[1] = (short)(0x80 | c & 0x3F);
                array[0] = (short)(0xC0 | (c >>= 6));
                break;
            }
            default: {
                array[2] = (short)(0x80 | c & 0x3F);
                array[1] = (short)(0x80 | (c >>= 6) & 0x3F);
                array[0] = (short)(0xE0 | (c >>= 6));
            }
        }
        for (int i = 0; i < characterSize; ++i) {
            buf.append('=');
            c = array[i];
            buf.append(SmtpTransmitter.toHexDigit(c >> 4));
            buf.append(SmtpTransmitter.toHexDigit(c & 0xF));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"appendEscapedUTF8");
        }
    }

    private static char toHexDigit(int x) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"toHexDigit", (String)"x");
        }
        char result = x < 10 ? (char)(48 + x) : (char)(65 + x - 10);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"toHexDigit", (char)result);
        }
        return result;
    }

    private void getReply() throws LocalizableException {
        block8: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"getReply", (String)"");
            }
            this.replyCode = 0;
            try {
                do {
                    this.reply = this.reader.readLine();
                    if (this.reply != null) continue;
                    this.replyCode = -1;
                    break block8;
                } while (this.reply.charAt(3) != ' ');
                for (int i = 0; i < 3; ++i) {
                    char c = this.reply.charAt(i);
                    if (c < '0' || c > '9') {
                        this.replyCode = -1;
                        break;
                    }
                    this.replyCode = 10 * this.replyCode + (c - 48);
                }
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"getReply", (Throwable)e);
                }
                this.throwException("GEN0110E", e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"getReply");
        }
    }

    private void checkReplyCode() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"checkReplyCode", (String)"");
        }
        if (this.replyCode < 200 || this.replyCode > 399) {
            if (this.reply == null) {
                this.reply = "";
            }
            Object[] args = new Object[]{this.lastCmd, this.reply};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"checkReplyCode");
            }
            throw new LocalizableException("GEN0111E", args);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"checkReplyCode");
        }
    }

    private void sendCmd(String cmd, String arg) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"sendCmd", (String)"cmd, arg");
        }
        this.lastCmd = cmd;
        this.send(cmd);
        if (arg != null) {
            this.send(arg);
        }
        this.sendCRLF();
        this.getReply();
        this.checkReplyCode();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendCmd");
        }
    }

    private void sendPath(String cmd, String path) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"sendPath", (String)"cmd, path");
        }
        this.lastCmd = cmd;
        this.send(cmd);
        this.send('<');
        this.send(path);
        this.send('>');
        this.sendCRLF();
        this.getReply();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendPath");
        }
    }

    private void send(String s) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"send", (String)"s");
        }
        this.send(s, 0, s.length());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"send");
        }
    }

    private void send(String s, int offset, int length) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"send", (String)"s, offset, length");
        }
        try {
            this.writer.write(s, offset, length);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"send", (Throwable)e);
            }
            this.throwException("GEN0112E", e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"send");
        }
    }

    private void send(char c) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"send", (String)"c");
        }
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"send", (Throwable)e);
            }
            this.throwException("GEN0112E", e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"send");
        }
    }

    private void sendCRLF() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"sendCRLF", (String)"");
        }
        try {
            this.writer.write(CRLF, 0, 2);
            this.writer.flush();
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SmtpTransmitter.class.getName(), (String)"sendCRLF", (Throwable)e);
            }
            this.throwException("GEN0112E", e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"sendCRLF");
        }
    }

    private void throwException(String msgID, Exception e) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SmtpTransmitter.class.getName(), (String)"throwException", (String)"msgID, e");
            TraceLogger.exit((String)SmtpTransmitter.class.getName(), (String)"throwException");
        }
        Object[] args = new Object[]{this.smtpServerName};
        throw new NestableException(msgID, args, e);
    }
}

