/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.Controller;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.ITokenManager;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;

public class ControlRouter
extends AbstractExtensionMgr
implements InvocationHandler {
    private static ControlRouter cControlRouter = null;
    private HashMap<Class, Controller> controllers = new HashMap();
    private ControlEngine ce = null;
    private Token internalToken = null;
    private ArrayList<String> asyncAPIs = new ArrayList();
    private ArrayList<String> nonPersistedJobAPIs = new ArrayList();
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className = ControlRouter.class.getName();
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.control.controller";
    public static final String ATTR_PROXYINTERFACE = "proxyinterface";

    private ControlRouter() {
        String methodName = "ControlRouter";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static ControlRouter getInstance() {
        if (cControlRouter == null) {
            cControlRouter = new ControlRouter();
        }
        return cControlRouter;
    }

    public static boolean startup(ControlEngine ce) {
        return ControlRouter.getInstance().startupInstance(ce);
    }

    public static Object getControllerProxy(Class c, ClassLoader cl) {
        return Proxy.newProxyInstance(cl, ControlRouter.getInstance().getProxyInterfaces(c), (InvocationHandler)ControlRouter.getInstance());
    }

    private boolean startupInstance(ControlEngine ce) {
        String methodName = "startupInstance";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        this.ce = ce;
        this.internalToken = ce.getInternalToken();
        this.refreshAPIs();
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    protected void refreshAPIs() {
        this.asyncAPIs.clear();
        this.nonPersistedJobAPIs.clear();
        this.controllers.clear();
        String[] extIds = this.getAllExtensionIds();
        for (int i = 0; i < extIds.length; ++i) {
            this.extensionAdded(extIds[i]);
        }
    }

    public Class[] getProxyInterfaces() {
        Class[] proxyInterfaceArray = new Class[this.controllers.size()];
        proxyInterfaceArray = this.controllers.keySet().toArray(proxyInterfaceArray);
        return proxyInterfaceArray;
    }

    public Class[] getProxyInterfaces(Class c) {
        Controller mController = this.controllers.get(c);
        Class[] proxyInterfaceArray = new Class[]{mController.getProxyInterfaceClass()};
        return proxyInterfaceArray;
    }

    /*
     * Loose catch block
     */
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        String methodName = "invoke";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        Class<ITokenManager> declaringClass = m.getDeclaringClass();
        Set<Class> proxyInterfaceKeys = this.controllers.keySet();
        for (Class proxyInterface : proxyInterfaceKeys) {
            Object returnObj;
            block39: {
                if (!declaringClass.isAssignableFrom(proxyInterface)) continue;
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Executing method " + m.getName());
                }
                if (declaringClass.isAssignableFrom(ITokenManager.class)) {
                    try {
                        return m.invoke((Object)this.controllers.get(proxyInterface), args);
                    }
                    catch (InvocationTargetException e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, e.getTargetException());
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e.getTargetException());
                        }
                        throw e.getTargetException();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                        }
                        throw t;
                    }
                }
                Token controlToken = null;
                Object firstParm = args[0];
                if (firstParm instanceof Token) {
                    controlToken = (Token)((Token)firstParm).clone();
                } else {
                    controlToken = (Token)this.internalToken.clone();
                    controlToken.setClient(Thread.currentThread().getName());
                }
                String APIid = this.getAPIid(proxyInterface, m.getName());
                boolean persistedJob = !this.nonPersistedJobAPIs.contains(APIid);
                boolean asyncJob = this.asyncAPIs.contains(APIid);
                try {
                    this.ce.startJob(controlToken, m.getName(), asyncJob, persistedJob);
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    throw e;
                }
                if (firstParm instanceof Token) {
                    args[0] = controlToken;
                }
                this.ce.setTokenForProxyThread(Thread.currentThread(), controlToken);
                returnObj = null;
                try {
                    block37: {
                        if (asyncJob) {
                            Controller c = this.controllers.get(proxyInterface).createController(this.ce, controlToken, m, args);
                            this.controllers.get(proxyInterface).getThreadPool().addJobToPool((Runnable)((Object)c));
                            this.ce.addAsyncThreadToJob(controlToken, (IController)c);
                            Class<?> returnType = m.getReturnType();
                            if (returnType != null) {
                                returnObj = returnType.newInstance();
                            }
                            if (returnObj != null && returnObj instanceof AsyncResult) {
                                returnObj.setRc(0);
                                returnObj.setStatus(2);
                                returnObj.setJobId(controlToken.getJobId());
                            }
                            break block37;
                        }
                        returnObj = m.invoke((Object)this.controllers.get(proxyInterface), args);
                    }
                    Object var18_24 = null;
                }
                catch (Throwable throwable) {
                    block38: {
                        Object var18_25 = null;
                        this.ce.removeTokenForProxyThread(Thread.currentThread());
                        AsyncResult result = this.ce.processReturnObj(controlToken, returnObj);
                        if (result.getStatus() != 2) {
                            try {
                                this.ce.endJob(controlToken, result.getRc(), result.getStatus(), result.getSRMMessage(), result.getReturnException(), result.getResults());
                            }
                            catch (Exception e) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block38;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                            }
                        }
                    }
                    throw throwable;
                }
                this.ce.removeTokenForProxyThread(Thread.currentThread());
                AsyncResult result = this.ce.processReturnObj(controlToken, returnObj);
                if (result.getStatus() != 2) {
                    try {
                        this.ce.endJob(controlToken, result.getRc(), result.getStatus(), result.getSRMMessage(), result.getReturnException(), result.getResults());
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                        }
                    }
                }
                break block39;
                {
                    catch (InvocationTargetException e) {
                        returnObj = new AsyncResult(-14, 0);
                        returnObj.setReturnException(new Exception(e.getTargetException()));
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, e.getTargetException());
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e.getTargetException());
                        }
                        throw e.getTargetException();
                    }
                    catch (Exception e) {
                        returnObj = new AsyncResult(-14, 0);
                        returnObj.setReturnException(e);
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        returnObj = new AsyncResult(-14, 0);
                        returnObj.setReturnException(new Exception(t));
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                        }
                        throw t;
                    }
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return returnObj;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.invokeNotRouted(proxy, m, args);
    }

    protected Object invokeNotRouted(Object proxy, Method m, Object[] args) throws Throwable {
        String methodName = "invokeNotRouted";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        throw new InternalError("Unexpected method dispatched: " + m);
    }

    private String getAPIid(Class interfaceClass, String methodName) {
        String method = "getAPIid";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, method);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, method);
        }
        return new String(interfaceClass.getName() + "::" + methodName);
    }

    public static boolean shutdown() {
        boolean result = ControlRouter.getInstance().shutdownInstance();
        cControlRouter = null;
        return result;
    }

    public boolean shutdownInstance() {
        String methodName = "shutdown";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        Collection<Controller> controllerList = this.controllers.values();
        for (Controller controller : controllerList) {
            controller.shutdown();
        }
        this.dispose();
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    protected void extensionAdded(String extensionId) {
        try {
            Controller controller = (Controller)this.getExtensionImpl(extensionId);
            controller.setControlEngine(this.ce);
            Class proxyInterface = controller.getProxyInterfaceClass();
            this.controllers.put(proxyInterface, controller);
            String[] asyncMethods = controller.getAsyncMethodNames();
            for (int m = 0; m < asyncMethods.length; ++m) {
                this.asyncAPIs.add(this.getAPIid(proxyInterface, asyncMethods[m]));
            }
            String[] methods = controller.getNonPersistedTopLevelJobAPIMethodNames();
            for (int m = 0; m < methods.length; ++m) {
                this.nonPersistedJobAPIs.add(this.getAPIid(proxyInterface, methods[m]));
            }
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
    }

    protected void extensionRemoved(String extensionId) {
        try {
            Controller controller = (Controller)this.getExtensionImpl(extensionId);
            Class proxyInterface = controller.getProxyInterfaceClass();
            String[] asyncMethods = controller.getAsyncMethodNames();
            for (int m = 0; m < asyncMethods.length; ++m) {
                this.asyncAPIs.remove(this.getAPIid(proxyInterface, asyncMethods[m]));
            }
            String[] methods = controller.getNonPersistedTopLevelJobAPIMethodNames();
            for (int m = 0; m < methods.length; ++m) {
                this.nonPersistedJobAPIs.remove(this.getAPIid(proxyInterface, methods[m]));
            }
            this.controllers.remove(proxyInterface);
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
    }
}

