/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control.storagesubsystem;

import java.lang.reflect.Method;
import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.Controller;
import org.eclipse.aperi.control.ThreadPool;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.data.storagesubsystem.Pool;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.control.interfaces.storagesubsystem.IStorageSubsystemControl;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.common.util.thread.ExecGroup;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginFactory;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.CreateSVCStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ModifyStoragePoolParameter;
import org.eclipse.aperi.disk.control.util.ModifyStorageVolumeParameter;
import org.eclipse.aperi.interfaces.IController;

public class StorageSubsystemController
extends Controller
implements IStorageSubsystemControl {
    static final String className = StorageSubsystemController.class.getName();

    public StorageSubsystemController() {
        this.controllerThreadPool = new ThreadPool(5);
    }

    public StorageSubsystemController(ControlEngine ce) {
        this();
        this.ce = ce;
    }

    private StorageSubsystemController(ControlEngine ce, Token token, Method m, Object[] args) {
        this.ce = ce;
        this.token = token;
        this.m = m;
        this.args = args;
    }

    public Controller createController(ControlEngine ce, Token token, Method m, Object[] args) {
        return new StorageSubsystemController(ce, token, m, args);
    }

    public String[] getAsyncMethodNames() {
        return new String[]{"createStorageVolumes", "deleteStorageVolumes", "assignStorageVolumesToWWPNs", "unassignStorageVolumesFromWWPNs", "modifyStorageVolumeSize", "createSVCDisks", "modifyStoragePoolSize"};
    }

    public String[] getNonPersistedTopLevelJobAPIMethodNames() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult createStorageVolumes(CreateStorageVolumesParameter[] pParams) throws NotAvailableException {
        String methodName = "createStorageVolumes";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)methodName, (Object[])new Object[]{pParams});
        AsyncResult mResult = new AsyncResult(-1, -1);
        ExecGroup mExGrp = null;
        try {
            mExGrp = DiskThreadManager.getExecutionGroup();
            Long[] mExId = new Long[pParams.length];
            for (int idx = 0; idx < pParams.length; ++idx) {
                IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)pParams[idx]);
                pParams[idx].setToken(this.getToken());
                Object[] bParams = new Object[]{pParams[idx]};
                DiskManager.registerSubsystemDataInUse(pParams[idx].getStorageSubsystemID());
                mExId[idx] = mExGrp.executeAsSubJob((Object)bPlugin, methodName, bParams, mLTH, (IController)this, pParams[idx].getStoragePoolCIMOPs().length);
            }
            mResult.setStatus(2);
            mExGrp.waitForCompletion(0L);
            Vector<AsyncResult> mAllSubJobResults = new Vector<AsyncResult>();
            for (int idx = 0; idx < mExId.length; ++idx) {
                DiskManager.deregisterSubsystemDataInUse(pParams[idx].getStorageSubsystemID());
                mAllSubJobResults.add(mExGrp.getExecutionResultInSubJob(mExId[idx], (IController)this, mLTH));
            }
            AsyncResult[] mAllResultArray = mAllSubJobResults.toArray(new AsyncResult[mAllSubJobResults.size()]);
            mResult = ResultHelper.computeAndSetFinalStatus((AsyncResult[])mAllResultArray, (String)methodName);
        }
        catch (Exception pEx) {
            mResult.setStatus(0);
            mLTH.traceError(pEx.getMessage(), (Throwable)pEx);
        }
        finally {
            mExGrp.clear();
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult deleteStorageVolumes(DeleteStorageVolumesParameter[] pParams) throws NotAvailableException {
        String methodName = "deleteStorageVolumes";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)methodName, (Object[])new Object[]{pParams});
        AsyncResult mResult = new AsyncResult(-1, -1);
        ExecGroup mExGrp = null;
        try {
            mExGrp = DiskThreadManager.getExecutionGroup();
            Long[] mExId = new Long[pParams.length];
            for (int idx = 0; idx < pParams.length; ++idx) {
                IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)pParams[idx]);
                pParams[idx].setToken(this.getToken());
                Object[] bParams = new Object[]{pParams[idx]};
                DiskManager.registerSubsystemDataInUse(pParams[idx].getStorageSubsystemID());
                mExId[idx] = mExGrp.executeAsSubJob((Object)bPlugin, "deleteStorageVolumes", bParams, mLTH, (IController)this, pParams[idx].getStorageVolumeCIMOPs().length);
            }
            mResult.setStatus(2);
            mExGrp.waitForCompletion(0L);
            Vector<AsyncResult> mAllSubJobResults = new Vector<AsyncResult>();
            for (int idx = 0; idx < mExId.length; ++idx) {
                DiskManager.deregisterSubsystemDataInUse(pParams[idx].getStorageSubsystemID());
                mAllSubJobResults.add(mExGrp.getExecutionResultInSubJob(mExId[idx], (IController)this, mLTH));
            }
            AsyncResult[] mAllResultArray = mAllSubJobResults.toArray(new AsyncResult[mAllSubJobResults.size()]);
            mResult = ResultHelper.computeAndSetFinalStatus((AsyncResult[])mAllResultArray, (String)methodName);
        }
        catch (Exception pEx) {
            mResult.setStatus(0);
            mLTH.traceError(pEx.getMessage(), (Throwable)pEx);
        }
        finally {
            mExGrp.clear();
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public AsyncResult createPool(String elementName, long sizeInBytes, Pool primordialPoolID, Pool backendPoolID, Pool pool) throws NotAvailableException {
        String methodName = "createPool";
        return new AsyncResult(0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult modifyStorageVolumeSize(ModifyStorageVolumeParameter pParam) throws NotAvailableException {
        String methodName = "modifyStorageVolumeSize";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)methodName, (Object[])new Object[]{pParam});
        AsyncResult mResult = new AsyncResult(-1, -1);
        pParam.setToken(this.getToken());
        try {
            IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)pParam);
            Object[] bParams = new Object[]{pParam};
            mResult = (AsyncResult)DiskThreadManager.executeWithTimeLimit((Object)bPlugin, (String)"modifyStorageVolumeSize", (Object[])bParams, (long)0L, (LogTraceHelper)mLTH);
        }
        catch (Exception pEx) {
            mResult.setStatus(0);
            mLTH.traceError(pEx.getMessage(), (Throwable)pEx);
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public AsyncResult createSVCDisks(CreateSVCStorageVolumesParameter[] pParams) throws NotAvailableException {
        String methodName = "createSVCDisks";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)methodName, (Object[])new Object[]{pParams});
        AsyncResult mResult = new AsyncResult(-1, -1);
        ExecGroup mExGrp = null;
        try {
            int idx;
            mExGrp = DiskThreadManager.getExecutionGroup();
            Long[] mExId = new Long[pParams.length];
            for (idx = 0; idx < pParams.length; ++idx) {
                IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)pParams[idx]);
                pParams[idx].setToken(this.getToken());
                Object[] bParams = new Object[]{pParams[idx]};
                DiskManager.registerSubsystemDataInUse(pParams[idx].getStorageSubsystemID());
                mExId[idx] = mExGrp.executeAsSubJob((Object)bPlugin, "createSVCVDisks", bParams, mLTH, (IController)this, pParams[idx].getMDiskGroups().length);
            }
            mResult.setStatus(2);
            mExGrp.waitForCompletion(0L);
            for (idx = 0; idx < mExId.length; ++idx) {
                DiskManager.deregisterSubsystemDataInUse(pParams[idx].getStorageSubsystemID());
                AsyncResult bRes = mExGrp.getExecutionResultInSubJob(mExId[idx], (IController)this, mLTH);
                if (bRes.getSubJobResults() == null) continue;
                ResultHelper.addAsyncSubResults((AsyncResult)mResult, (AsyncResult[])bRes.getSubJobResults());
            }
            mResult = ResultHelper.computeAndSetFinalStatus((AsyncResult)mResult, (String)methodName);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021652E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerExecException e) {
            mLTH.traceError("Internal error: DiskManagerExecException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021653E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            if (mExGrp != null) {
                mExGrp.clear();
            }
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult modifyStoragePoolSize(ModifyStoragePoolParameter pParam) throws NotAvailableException {
        String methodName = "modifyStoragePoolSize";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)methodName, (Object[])new Object[]{pParam});
        AsyncResult mResult = new AsyncResult(10001, -1);
        pParam.setToken(this.getToken());
        try {
            ExecGroup mExGrp = DiskThreadManager.getExecutionGroup();
            IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin((ConfigurationParameter)pParam);
            Object[] bParams = new Object[]{pParam};
            DiskManager.registerSubsystemDataInUse(pParam.getStorageSubsystemID());
            Long mExId = mExGrp.executeAsSubJob((Object)bPlugin, "modifyStoragePoolSize", bParams, mLTH, (IController)this, 1);
            mResult.setStatus(2);
            mExGrp.waitForCompletion(0L);
            DiskManager.deregisterSubsystemDataInUse(pParam.getStorageSubsystemID());
            mResult = (AsyncResult)mExGrp.getExecutionResult(mExId);
            this.endSubJob(0, mResult.getRc(), mResult.getStatus(), mResult.getSRMMessage(), null, mResult.getResults());
        }
        catch (Exception pEx) {
            mResult.setStatus(0);
            this.endSubJob(0, mResult.getRc(), mResult.getStatus(), mResult.getSRMMessage(), pEx, null);
            mLTH.traceError(pEx.getMessage(), (Throwable)pEx);
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public AsyncResult deletePool(Pool pool) throws NotAvailableException {
        String methodName = "deletePool";
        System.out.println("Doing deletePool");
        return new AsyncResult(0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult assignStorageVolumesToWWPNs(ConfigurationParameter[] pParams) throws ServerException {
        String mMethodName = "assignStorageVolumesToWWPNs";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)mMethodName, (Object[])new Object[]{pParams});
        AsyncResult mResult = null;
        try {
            int[] mNumberOfSubJobs = this.getNumberOfSubJobsForMapping((AssignmentParameter[])pParams);
            mResult = this.executeMethod(mMethodName, pParams, mNumberOfSubJobs);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        mLTH.exit((Object)mResult);
        return mResult;
    }

    private int[] getNumberOfSubJobsForMapping(AssignmentParameter[] pParameters) {
        int[] mNumberOfSubJobs = new int[pParameters.length];
        for (int i = 0; i < pParameters.length; ++i) {
            pParameters[i].setToken(this.getToken());
            mNumberOfSubJobs[i] = pParameters[i].getVolumeIDs().length * pParameters[i].getInitiatorWWPNs().size();
        }
        return mNumberOfSubJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(ConfigurationParameter[] pParams) throws ServerException {
        String mMethodName = "unassignStorageVolumesFromWWPNs";
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)mMethodName, (Object[])new Object[0]);
        AsyncResult mResult = null;
        try {
            int[] mNumberOfSubJobs = this.getNumberOfSubJobsForMapping((AssignmentParameter[])pParams);
            mResult = this.executeMethod(mMethodName, pParams, mNumberOfSubJobs);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        mLTH.exit((Object)mResult);
        return mResult;
    }

    private AsyncResult executeMethod(String pMethodName, ConfigurationParameter[] pParams, int[] pNumberOfSubJobs) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.getToken(), (Object)this, (String)"executeMethod", (Object[])new Object[]{pMethodName, pParams});
        AsyncResult mResult = new AsyncResult(-1, -1);
        mResult.setSubJobResults(new AsyncResult[0]);
        ExecGroup mExGrp = null;
        try {
            mExGrp = DiskThreadManager.getExecutionGroup();
            Long[] mExId = new Long[pParams.length];
            for (int i = 0; i < pParams.length; ++i) {
                mResult.setSubJobResults(new AsyncResult[0]);
                pParams[i].setToken(this.getToken());
                IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin(pParams[i]);
                DiskManager.registerSubsystemDataInUse(pParams[i].getStorageSubsystemID());
                mExId[i] = mExGrp.executeAsSubJob((Object)bPlugin, pMethodName, new Object[]{pParams[i]}, mLTH, (IController)this, pNumberOfSubJobs[i]);
            }
            mResult.setStatus(2);
            mExGrp.waitForCompletion(0L);
            for (int idx = 0; idx < mExId.length; ++idx) {
                DiskManager.deregisterSubsystemDataInUse(pParams[idx].getStorageSubsystemID());
                AsyncResult bRes = mExGrp.getExecutionResultInSubJob(mExId[idx], (IController)this, mLTH);
                ResultHelper.addAsyncSubResults((AsyncResult)mResult, (AsyncResult[])bRes.getSubJobResults());
            }
            AsyncResult asyncResult = mResult = ResultHelper.computeAndSetFinalStatus((AsyncResult)mResult, (String)pMethodName);
            return asyncResult;
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021652E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerExecException e) {
            mLTH.traceError("Internal error: DiskManagerExecException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021653E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            if (mExGrp != null) {
                mExGrp.clear();
            }
            this.closeCimClients(pParams);
            mLTH.exit((Object)mResult);
        }
    }

    private void closeCimClients(ConfigurationParameter[] pParameter) {
        for (int i = 0; i < pParameter.length; ++i) {
            if (pParameter[i].getCIMClientWrapper() == null) continue;
            CIMClientPool.returnClient((CIMClientWrapper)pParameter[i].getCIMClientWrapper());
        }
    }

    public int startSubJob(String jobName, boolean persistedJob) {
        return super.startSubJob(jobName, persistedJob);
    }

    public boolean endSubJob(int subJobNum, int rc, int status, SRMMessage msg, Exception returnException, Object[] returnObjs) {
        return super.endSubJob(subJobNum, rc, status, msg, returnException, returnObjs);
    }

    protected Class getProxyInterfaceClass() {
        return IStorageSubsystemControl.class;
    }
}

