/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.ControlRouter;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.control.interfaces.storagesubsystem.IStorageSubsystemControl;
import org.eclipse.aperi.control.storagesubsystem.StorageSubsystemController;
import org.eclipse.aperi.disk.api.IDiskConfigurationService;
import org.eclipse.aperi.disk.api.IDiskSVCConfigurationService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskParameterChecker;
import org.eclipse.aperi.disk.common.util.DiskParameterHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.CreateSVCStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ModifyStoragePoolParameter;
import org.eclipse.aperi.disk.control.util.ModifyStorageVolumeParameter;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.IoGroup;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskConfigurationOperations
extends DiskOperations
implements IDiskConfigurationService,
IDiskSVCConfigurationService {
    protected HashMap cSubsystemConnectionData = new HashMap();

    public DiskConfigurationOperations(DiskManager pDiskManager) {
        super(pDiskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
    }

    protected IStorageSubsystemControl getStorageSubsystemController() {
        IStorageSubsystemControl ssController = (IStorageSubsystemControl)ControlRouter.getControllerProxy(IStorageSubsystemControl.class, (ClassLoader)StorageSubsystemController.class.getClassLoader());
        return ssController;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createStorageVolumes(long[] pSizes, String[] pStoragePoolIDs, String[] pVolumeNames, HashMap pGoal) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String methodName = "createStorageVolumes";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)methodName, (Object[])new Object[]{pSizes, pStoragePoolIDs, pVolumeNames, pGoal});
        AsyncResult result = null;
        DBConnection con = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"Sizes", (Object)pSizes, (LogTraceHelper)mLTH);
            ParameterChecker.assertValidPrimitiveParameterArray((int)1, (String)"Sizes", (Object)pSizes, (LogTraceHelper)mLTH);
            ParameterChecker.assertMandatoryParameter((int)2, (String)"StoragePoolIDs", (Object)pStoragePoolIDs, (LogTraceHelper)mLTH);
            ParameterChecker.assertMandatoryParameterArraySizes((int)2, (String)"Sizes, StoragePoolIDs", (Object)pSizes, (Object)pStoragePoolIDs, (LogTraceHelper)mLTH);
            ParameterChecker.assertOptionalParameterArraySizes((int)3, (String)"StoragePoolIDs, VolumeNames", (Object)pStoragePoolIDs, (Object)pVolumeNames, (LogTraceHelper)mLTH);
            if (pVolumeNames == null) {
                pVolumeNames = new String[pStoragePoolIDs.length];
            }
            con = ServiceUtils.getConnection();
            StorageSubsystem[] storageSubsystems = new StorageSubsystem[pStoragePoolIDs.length];
            StoragePool[] storagePools = new StoragePool[pStoragePoolIDs.length];
            CIMObjectPath[] storageSystemCIMOP = new CIMObjectPath[pStoragePoolIDs.length];
            CIMObjectPath[] storagePoolCIMOP = new CIMObjectPath[pStoragePoolIDs.length];
            CIMOMSelector.SubsystemConnectionData[] bConData = new CIMOMSelector.SubsystemConnectionData[pStoragePoolIDs.length];
            CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
            for (int idx = 0; idx < pStoragePoolIDs.length; ++idx) {
                try {
                    String storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)pStoragePoolIDs[idx], (LogTraceHelper)mLTH);
                    storageSubsystems[idx] = ExternalKeyManager.getStorageSubsystem((String)storageSubsystemKey, (DBConnection)con);
                    storagePools[idx] = ExternalKeyManager.getStoragePool((String)pStoragePoolIDs[idx], (int)storageSubsystems[idx].getSubsystemId(), (DBConnection)con);
                    bConData[idx] = this.getCimomForSubsystem(bCimomSelector, storageSubsystems[idx]);
                    storageSystemCIMOP[idx] = bConData[idx].getSubsystemCop();
                    storagePoolCIMOP[idx] = ExternalKeyManager.getCIMObjectPath((StoragePool)storagePools[idx], (String)bConData[idx].getCimNamespace());
                    this.checkOperationSupported(bConData[idx].getCapability(), storageSubsystemKey, "CreateStorageVolumes", mLTH);
                    continue;
                }
                catch (IDParseException idpEx) {
                    throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)pStoragePoolIDs[idx], (LogTraceHelper)mLTH);
                }
                catch (EntityNotFoundException mEX) {
                    throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021654E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
                }
            }
            con.commit();
            this.checkPoolSupportsSize(pStoragePoolIDs, storagePools, storagePoolCIMOP, pSizes, mLTH);
            HashMap<String, CreateStorageVolumesParameter> mParams = new HashMap<String, CreateStorageVolumesParameter>();
            for (int mIdx = 0; mIdx < storageSubsystems.length; ++mIdx) {
                String bStorageSubsystemKey = (String)ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)storageSubsystems[mIdx]);
                CreateStorageVolumesParameter bValue = null;
                bValue = !mParams.containsKey(bStorageSubsystemKey) ? new CreateStorageVolumesParameter(storageSubsystems[mIdx], storageSystemCIMOP[mIdx]) : (CreateStorageVolumesParameter)mParams.get(bStorageSubsystemKey);
                bValue.addCreateStorageVolumeParameter(storagePools[mIdx], storagePoolCIMOP[mIdx], pSizes[mIdx], pVolumeNames[mIdx]);
                bValue.setCapability(bConData[mIdx].getCapability());
                bValue.setCimom(bConData[mIdx].getCimom());
                bValue.setStorageSubsystemID(bStorageSubsystemKey);
                mParams.put(bStorageSubsystemKey, bValue);
            }
            IStorageSubsystemControl ssController = this.getStorageSubsystemController();
            CreateStorageVolumesParameter[] mVolPars = mParams.values().toArray(new CreateStorageVolumesParameter[mParams.size()]);
            asyncResult = result = ssController.createStorageVolumes(mVolPars);
        }
        catch (SQLException sqlEx) {
            try {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                catch (NotAvailableException naEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)naEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                this.finallyCheckConnection(con, mLTH);
                mLTH.exit(result);
                throw throwable;
            }
        }
        this.finallyCheckConnection(con, mLTH);
        mLTH.exit((Object)result);
        return asyncResult;
    }

    protected CIMOMSelector.SubsystemConnectionData getCimomForSubsystem(CIMOMSelector pCimomSelector, StorageSubsystem pStorageSubsystem) {
        CIMOMSelector.SubsystemConnectionData mConnectionData = (CIMOMSelector.SubsystemConnectionData)this.cSubsystemConnectionData.get(new Integer(pStorageSubsystem.getSubsystemId()));
        if (mConnectionData != null) {
            return mConnectionData;
        }
        mConnectionData = pCimomSelector.getCimomForSubsystem(pStorageSubsystem.getSubsystemId());
        this.cSubsystemConnectionData.put(new Integer(pStorageSubsystem.getSubsystemId()), mConnectionData);
        return mConnectionData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult deleteStorageVolumes(String[] pStorageVolumeIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String methodName = "deleteStorageVolumes";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)methodName, (Object[])new Object[]{pStorageVolumeIDs});
        AsyncResult result = null;
        DBConnection con = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)pStorageVolumeIDs, (LogTraceHelper)mLTH);
            con = ServiceUtils.getConnection();
            StorageSubsystem[] storageSubsystems = new StorageSubsystem[pStorageVolumeIDs.length];
            StorageVolume[] storageVolumes = new StorageVolume[pStorageVolumeIDs.length];
            CimkeyVolume[] storageVolumeCIM = new CimkeyVolume[pStorageVolumeIDs.length];
            CIMObjectPath[] storageSystemCIMOP = new CIMObjectPath[pStorageVolumeIDs.length];
            CIMObjectPath[] storageVolumeCIMOP = new CIMObjectPath[pStorageVolumeIDs.length];
            CIMOMSelector.SubsystemConnectionData[] bConData = new CIMOMSelector.SubsystemConnectionData[pStorageVolumeIDs.length];
            for (int idx = 0; idx < pStorageVolumeIDs.length; ++idx) {
                try {
                    String storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromVolume((String)pStorageVolumeIDs[idx], (LogTraceHelper)mLTH);
                    storageSubsystems[idx] = ExternalKeyManager.getStorageSubsystem((String)storageSubsystemKey, (DBConnection)con);
                    storageVolumes[idx] = ExternalKeyManager.getStorageVolume((String)pStorageVolumeIDs[idx], (int)storageSubsystems[idx].getSubsystemId(), (DBConnection)con);
                    if (storageVolumes[idx].getIsAssigned() == 1) {
                        throw DiskMessageHelper.getServerException((String)"HWN021611E", (Object)pStorageVolumeIDs[idx], (LogTraceHelper)mLTH);
                    }
                    CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
                    bConData[idx] = bCimomSelector.getCimomForSubsystem(storageSubsystems[idx].getSubsystemId());
                    storageVolumeCIM[idx] = ExternalKeyManager.getStorageVolumeCIM((int)storageVolumes[idx].getSvid(), (int)bConData[idx].getCimNamespaceID(), (DBConnection)con);
                    storageSystemCIMOP[idx] = bConData[idx].getSubsystemCop();
                    storageVolumeCIMOP[idx] = ExternalKeyManager.getCIMObjectPath((CimkeyVolume)storageVolumeCIM[idx], (String)bConData[idx].getCimNamespace());
                    CapabilityData cap = bConData[idx].getCapability();
                    this.checkOperationSupported(cap, storageSubsystemKey, "DeleteStorageVolumes", mLTH);
                    continue;
                }
                catch (IDParseException idpEx) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)pStorageVolumeIDs[idx], (LogTraceHelper)mLTH);
                }
                catch (EntityNotFoundException mEX) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021655E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
                }
            }
            con.commit();
            HashMap<String, DeleteStorageVolumesParameter> mParams = new HashMap<String, DeleteStorageVolumesParameter>();
            for (int mIdx = 0; mIdx < storageSubsystems.length; ++mIdx) {
                String bStorageSubsystemKey = (String)ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)storageSubsystems[mIdx]);
                DeleteStorageVolumesParameter bValue = null;
                bValue = !mParams.containsKey(bStorageSubsystemKey) ? new DeleteStorageVolumesParameter(storageSubsystems[mIdx], storageSystemCIMOP[mIdx]) : (DeleteStorageVolumesParameter)mParams.get(bStorageSubsystemKey);
                bValue.addDeleteStorageVolumeParameter(storageVolumes[mIdx], storageVolumeCIMOP[mIdx]);
                bValue.setStorageSubsystemID(bStorageSubsystemKey);
                bValue.setCapability(bConData[mIdx].getCapability());
                bValue.setCimom(bConData[mIdx].getCimom());
                mParams.put(bStorageSubsystemKey, bValue);
            }
            DeleteStorageVolumesParameter[] bDeleteParams = new DeleteStorageVolumesParameter[mParams.size()];
            bDeleteParams = mParams.values().toArray(bDeleteParams);
            IStorageSubsystemControl ssController = this.getStorageSubsystemController();
            asyncResult = result = ssController.deleteStorageVolumes(bDeleteParams);
        }
        catch (SQLException sqlEx) {
            try {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                catch (NotAvailableException naEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)naEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                this.finallyCheckConnection(con, mLTH);
                mLTH.exit(result);
                throw throwable;
            }
        }
        this.finallyCheckConnection(con, mLTH);
        mLTH.exit((Object)result);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult assignStorageVolumesToWWPNs(String[] pStorageVolumeIDs, String[] pSubsystemPortIDs, String[] pDeviceNumbers, String[] pHostWWPNs, int pHostType, String pHostTypeDescription, String[] pHostNames, String[] pActivities, boolean pForce) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String mMethodName = "assignStorageVolumesToWWPNs";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)mMethodName, (Object[])new Object[]{pStorageVolumeIDs, pSubsystemPortIDs, pDeviceNumbers, pHostWWPNs, new Integer(pHostType), pHostTypeDescription, pHostNames, pActivities, new Boolean(pForce)});
        AsyncResult mResult = null;
        DBHelper mDBHelper = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)pStorageVolumeIDs, (LogTraceHelper)mLTH);
            ParameterChecker.assertMandatoryParameter((int)4, (String)"HostWWPNs", (Object)pHostWWPNs, (LogTraceHelper)mLTH);
            mDBHelper = new DBHelper();
            AssignStorageVolumesParameter mParamsAllSubsystems = new AssignStorageVolumesParameter();
            mParamsAllSubsystems.setVolumeIDs(pStorageVolumeIDs);
            mDBHelper.getStorageVolumesAndSubsystemObjects(mParamsAllSubsystems, pStorageVolumeIDs);
            ConfigurationParameter[] mParamsArray = DiskParameterHelper.combineConfigurationParametersByStorageSystem(mParamsAllSubsystems).toArray(new AssignStorageVolumesParameter[0]);
            for (int i = 0; i < mParamsArray.length; ++i) {
                CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
                CIMOMSelector.SubsystemConnectionData bCIMConnectionData = bCimomSelector.getCimomForSubsystem(mParamsArray[i].getStorageSubsystem().getSubsystemId());
                mParamsArray[i].setCIMClientWrapper(bCIMConnectionData.getClientWrapper());
                mParamsArray[i].setCimom(bCIMConnectionData.getCimom());
                CapabilityData bCapabilities = bCIMConnectionData.getCapability();
                if (bCapabilities.getPortsPerView() == 2 && pSubsystemPortIDs == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021602E", (Object)mParamsArray[i].getStorageSubsystemID(), (LogTraceHelper)mLTH);
                }
                if (bCapabilities.getAccessAssignment() != 1) {
                    throw DiskMessageHelper.getServerException((String)"HWN021536E", (Object)mParamsArray[i].getStorageSubsystemID(), (Object)mMethodName, (LogTraceHelper)mLTH);
                }
                mParamsArray[i].setCapability(bCapabilities);
                mParamsArray[i].setVolumeCOPs(mDBHelper.getVolumeAndSubsystemCOPs(bCIMConnectionData, mParamsArray[i]));
                if (pSubsystemPortIDs != null) {
                    DiskParameterHelper.getTargetPorts(mDBHelper, bCIMConnectionData, pSubsystemPortIDs, (AssignStorageVolumesParameter)mParamsArray[i]);
                }
                ArrayList<Port> mInitiatorPortList = new ArrayList<Port>();
                Port[] mInitiatorPortObjs = mDBHelper.getInitiatorPortObjects(mParamsArray[i], pHostWWPNs);
                for (int mIniPortsIdx = 0; mIniPortsIdx < mInitiatorPortObjs.length; ++mIniPortsIdx) {
                    mInitiatorPortList.add(mInitiatorPortObjs[mIniPortsIdx]);
                }
                mParamsArray[i].setInitiatorPorts(mInitiatorPortList);
                if (pHostType != -1) {
                    CIMObjectPath mClientSettingDataCOP = mDBHelper.getClientSettingDataCOP(bCIMConnectionData, mParamsArray[i].getStorageSubsystem().getSubsystemId(), pHostType, pHostTypeDescription, mParamsArray[i]);
                    mParamsArray[i].setClientSettingDataCOP(mClientSettingDataCOP);
                }
                mParamsArray[i].setInitiatorWWPNs(pHostWWPNs);
                mParamsArray[i].setHostNames(pHostNames);
                mParamsArray[i].setForce(pForce);
            }
            IStorageSubsystemControl ssController = this.getStorageSubsystemController();
            asyncResult = mResult = ssController.assignStorageVolumesToWWPNs(mParamsArray);
            if (mDBHelper != null) {
                mDBHelper.close();
            }
        }
        catch (InvalidParameterException ipe) {
            try {
                mLTH.traceError("InvalidParameterException", (Throwable)ipe);
                throw ipe;
                catch (MissingParameterException mpe) {
                    mLTH.traceError("MissingParameterException", (Throwable)mpe);
                    throw mpe;
                }
                catch (ServerException te) {
                    mLTH.traceError("ServerException", (Throwable)te);
                    throw te;
                }
                catch (SQLException e) {
                    mLTH.traceError("Internal error: SQLException", (Throwable)e);
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                if (mDBHelper != null) {
                    mDBHelper.close();
                }
                mLTH.exit(mResult);
                throw throwable;
            }
        }
        mLTH.exit((Object)mResult);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(String[] pStorageVolumeIDs, String[] pHostWWPNs, int pUnMappingMode, boolean pForce) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String mMethodName = "unassignStorageVolumesFromWWPNs";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)mMethodName, (Object[])new Object[]{pStorageVolumeIDs, pHostWWPNs, new Integer(pUnMappingMode), new Boolean(pForce)});
        DBHelper mDBHelper = null;
        AsyncResult mResult = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)pStorageVolumeIDs, (LogTraceHelper)mLTH);
            ParameterChecker.assertMandatoryParameter((int)2, (String)"HostWWPNs", (Object)pHostWWPNs, (LogTraceHelper)mLTH);
            ParameterChecker.assertOptionalParameterInRange((int)3, (String)"UnMappingMode", (int)pUnMappingMode, (int)1, (int)3, (LogTraceHelper)mLTH);
            if (pUnMappingMode == -1) {
                pUnMappingMode = AssignmentParameter.MAP;
            }
            mDBHelper = new DBHelper();
            AssignmentParameter mParamsAllSubsystems = new AssignmentParameter();
            mParamsAllSubsystems.setVolumeIDs(pStorageVolumeIDs);
            mDBHelper.getStorageVolumesAndSubsystemObjects(mParamsAllSubsystems, pStorageVolumeIDs);
            ConfigurationParameter[] mParamsArray = DiskParameterHelper.combineConfigurationParametersByStorageSystem(mParamsAllSubsystems).toArray(new AssignmentParameter[0]);
            for (int i = 0; i < mParamsArray.length; ++i) {
                CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
                CIMOMSelector.SubsystemConnectionData bCIMConnectionData = bCimomSelector.getCimomForSubsystem(mParamsArray[i].getStorageSubsystem().getSubsystemId());
                mParamsArray[i].setCIMClientWrapper(bCIMConnectionData.getClientWrapper());
                mParamsArray[i].setCimom(bCIMConnectionData.getCimom());
                mParamsArray[i].setCapability(bCIMConnectionData.getCapability());
                if (mParamsArray[i].getCapability().getAccessUnassignment() != 1) {
                    throw DiskMessageHelper.getServerException((String)"HWN021536E", (Object)mParamsArray[i].getStorageSubsystemID(), (Object)mMethodName, (LogTraceHelper)mLTH);
                }
                mParamsArray[i].setVolumeCOPs(mDBHelper.getVolumeAndSubsystemCOPs(bCIMConnectionData, mParamsArray[i]));
                mParamsArray[i].setInitiatorWWPNs(pHostWWPNs);
                mParamsArray[i].setMappingMode(pUnMappingMode);
                mParamsArray[i].setForce(pForce);
            }
            IStorageSubsystemControl ssController = this.getStorageSubsystemController();
            asyncResult = mResult = ssController.unassignStorageVolumesFromWWPNs(mParamsArray);
            if (mDBHelper != null) {
                mDBHelper.close();
            }
        }
        catch (InvalidParameterException ipe) {
            try {
                mLTH.traceError("InvalidParameterException", (Throwable)ipe);
                throw ipe;
                catch (MissingParameterException mpe) {
                    mLTH.traceError("MissingParameterException", (Throwable)mpe);
                    throw mpe;
                }
                catch (ServerException te) {
                    mLTH.traceError("ServerException", (Throwable)te);
                    throw te;
                }
            }
            catch (Throwable throwable) {
                if (mDBHelper != null) {
                    mDBHelper.close();
                }
                mLTH.exit(mResult);
                throw throwable;
            }
        }
        mLTH.exit((Object)mResult);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStoragePoolSize(String pStoragePoolID, String[] pStorageExtentIDsToAdd, String[] pStorageExtentIDsToRemove) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String methodName = "modifyStoragePoolSize";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)methodName, (Object[])new Object[]{pStoragePoolID, pStorageExtentIDsToAdd, pStorageExtentIDsToRemove});
        AsyncResult result = null;
        DBConnection con = null;
        try {
            int idx;
            ParameterChecker.assertMandatoryParameter((int)1, (String)"StoragePoolID", (Object)pStoragePoolID, (LogTraceHelper)mLTH);
            ParameterChecker.assertExclusiveMandatoryParameter((int)2, (String)"StorageExtentIDsToAdd, StorageExtentIDsToRemove", (Object)pStorageExtentIDsToAdd, (Object)pStorageExtentIDsToRemove, (String)"StorageExtentIDsToAdd", (String)"StorageExtentIDsToRemove", (LogTraceHelper)mLTH);
            con = ServiceUtils.getConnection();
            StorageSubsystem storageSubsystem = null;
            StoragePool storagePool = null;
            StorageExtent[] bStgExtentsToAdd = null;
            CIMObjectPath[] bStgExtentsToAddCIMOP = null;
            StorageExtent[] bStgExtentsToRem = null;
            CIMObjectPath[] bStgExtentsToRemCIMOP = null;
            try {
                String storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)pStoragePoolID, (LogTraceHelper)mLTH);
                storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)storageSubsystemKey, (DBConnection)con);
                storagePool = ExternalKeyManager.getStoragePool((String)pStoragePoolID, (int)storageSubsystem.getSubsystemId(), (DBConnection)con);
            }
            catch (IDParseException idpEx) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)pStoragePoolID, (LogTraceHelper)mLTH);
            }
            catch (EntityNotFoundException mEX) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
            }
            CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
            CIMOMSelector.SubsystemConnectionData bConData = bCimomSelector.getCimomForSubsystem(storageSubsystem.getSubsystemId());
            CIMObjectPath storageSystemCIMOP = bConData.getSubsystemCop();
            CIMObjectPath storagePoolCIMOP = ExternalKeyManager.getCIMObjectPath((StoragePool)storagePool, (String)bConData.getCimNamespace());
            if (pStorageExtentIDsToAdd != null) {
                bStgExtentsToAdd = new StorageExtent[pStorageExtentIDsToAdd.length];
                bStgExtentsToAddCIMOP = new CIMObjectPath[pStorageExtentIDsToAdd.length];
                for (idx = 0; idx < pStorageExtentIDsToAdd.length; ++idx) {
                    try {
                        bStgExtentsToAdd[idx] = ExternalKeyManager.getStorageExtent((String)pStorageExtentIDsToAdd[idx], (int)storageSubsystem.getSubsystemId(), (DBConnection)con);
                    }
                    catch (IDParseException idpEx) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)pStorageExtentIDsToAdd[idx], (LogTraceHelper)mLTH);
                    }
                    catch (EntityNotFoundException mEX) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021658E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
                    }
                    bStgExtentsToAddCIMOP[idx] = ExternalKeyManager.getCIMObjectPath((StorageExtent)bStgExtentsToAdd[idx], (String)bConData.getCimNamespace());
                }
            }
            if (pStorageExtentIDsToRemove != null) {
                bStgExtentsToRem = new StorageExtent[pStorageExtentIDsToRemove.length];
                bStgExtentsToRemCIMOP = new CIMObjectPath[pStorageExtentIDsToRemove.length];
                for (idx = 0; idx < pStorageExtentIDsToRemove.length; ++idx) {
                    try {
                        bStgExtentsToRem[idx] = ExternalKeyManager.getStorageExtent((String)pStorageExtentIDsToRemove[idx], (int)storageSubsystem.getSubsystemId(), (DBConnection)con);
                    }
                    catch (IDParseException idpEx) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)pStorageExtentIDsToAdd[idx], (LogTraceHelper)mLTH);
                    }
                    catch (EntityNotFoundException mEX) {
                        throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021658E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
                    }
                    bStgExtentsToRemCIMOP[idx] = ExternalKeyManager.getCIMObjectPath((StorageExtent)bStgExtentsToRem[idx], (String)bConData.getCimNamespace());
                }
            }
            CapabilityData cap = bConData.getCapability();
            ModifyStoragePoolParameter mModifyStgPoolParam = new ModifyStoragePoolParameter(storageSubsystem, storageSystemCIMOP);
            mModifyStgPoolParam.addModifyStoragePoolParameter(storagePool, storagePoolCIMOP, bStgExtentsToAdd, bStgExtentsToAddCIMOP, bStgExtentsToRem, bStgExtentsToRemCIMOP);
            mModifyStgPoolParam.setCimom(bConData.getCimom());
            mModifyStgPoolParam.setCapability(cap);
            IStorageSubsystemControl ssController = this.getStorageSubsystemController();
            result = ssController.modifyStoragePoolSize(mModifyStgPoolParam);
            con.commit();
            asyncResult = result;
        }
        catch (SQLException sqlEx) {
            try {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                catch (NotAvailableException naEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)naEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                this.finallyCheckConnection(con, mLTH);
                mLTH.exit(result);
                throw throwable;
            }
        }
        this.finallyCheckConnection(con, mLTH);
        mLTH.exit((Object)result);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStorageVolumeSize(String pStorageVolumeID, long pNewSize) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "modifyStorageVolumeSize";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)methodName, (Object[])new Object[]{pStorageVolumeID, String.valueOf(pNewSize)});
        AsyncResult result = null;
        DBConnection con = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeID", (Object)pStorageVolumeID, (LogTraceHelper)mLTH);
            ParameterChecker.assertValidPrimitiveParameterLong((int)2, (String)"NewSize", (long)pNewSize, (LogTraceHelper)mLTH);
            con = ServiceUtils.getConnection();
            String storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromVolume((String)pStorageVolumeID, (LogTraceHelper)mLTH);
            StorageSubsystem storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)storageSubsystemKey, (DBConnection)con);
            StorageVolume storageVolume = ExternalKeyManager.getStorageVolume((String)pStorageVolumeID, (int)storageSubsystem.getSubsystemId(), (DBConnection)con);
            con.commit();
            CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
            CIMOMSelector.SubsystemConnectionData bConData = bCimomSelector.getCimomForSubsystem(storageSubsystem.getSubsystemId());
            CimkeyVolume storageVolumeCIM = ExternalKeyManager.getStorageVolumeCIM((int)storageVolume.getSvid(), (int)bConData.getCimNamespaceID(), (DBConnection)con);
            CIMObjectPath storageSystemCIMOP = bConData.getSubsystemCop();
            CIMObjectPath storageVolumeCIMOP = null;
            ExternalKeyManager.getCIMObjectPath((CimkeyVolume)storageVolumeCIM, (String)bConData.getCimNamespace());
            CapabilityData cap = bConData.getCapability();
            this.checkOperationSupported(cap, storageSubsystemKey, "modifyStorageVolumeSize", mLTH);
            ModifyStorageVolumeParameter mModifyStgVolParam = new ModifyStorageVolumeParameter(storageSubsystem, storageSystemCIMOP);
            mModifyStgVolParam.setCapability(cap);
            mModifyStgVolParam.setNewSize(pNewSize);
            mModifyStgVolParam.setStorageVolume(storageVolume);
            mModifyStgVolParam.setStorageVolumeCIMOP(storageVolumeCIMOP);
            IStorageSubsystemControl ssController = this.getStorageSubsystemController();
            result = ssController.modifyStorageVolumeSize(mModifyStgVolParam);
        }
        catch (IDParseException idpEx) {
            try {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)pStorageVolumeID, (LogTraceHelper)mLTH);
                catch (SQLException sqlEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                }
                catch (NotAvailableException naEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)naEx.getMessage(), (LogTraceHelper)mLTH);
                }
                catch (EntityNotFoundException mEX) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021655E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                this.finallyCheckConnection(con, mLTH);
                mLTH.exit(result);
                throw throwable;
            }
        }
        this.finallyCheckConnection(con, mLTH);
        mLTH.exit((Object)result);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createSVCVDisks(long[] pSizes, String[] pSvcMDiskGroupIDs, String[] pSvcVDiskNames, boolean pFormatOnCreate, int pVirtualizationType, int pIoGroup, String[] pSvcMDiskIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        String methodName = "createSVCVDisks";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)methodName, (Object[])new Object[]{pSizes, pSvcMDiskGroupIDs, pSvcVDiskNames, String.valueOf(pFormatOnCreate), String.valueOf(pVirtualizationType), new Integer(pIoGroup), pSvcMDiskIDs});
        AsyncResult result = null;
        DBConnection con = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"Sizes", (Object)pSizes, (LogTraceHelper)mLTH);
            ParameterChecker.assertMandatoryParameter((int)2, (String)"SVCMDiskGroupIDs", (Object)pSvcMDiskGroupIDs, (LogTraceHelper)mLTH);
            ParameterChecker.assertMandatoryParameterArraySizes((int)1, (String)"Sizes, SVCMDiskGroupIDs", (Object)pSizes, (Object)pSvcMDiskGroupIDs, (LogTraceHelper)mLTH);
            ParameterChecker.assertOptionalParameterArraySizes((int)2, (String)"SVCMDiskGroupIDs, SVCVDiskNames", (Object)pSvcMDiskGroupIDs, (Object)pSvcVDiskNames, (LogTraceHelper)mLTH);
            ParameterChecker.assertVitualizationType((int)5, (String)"VirtualizationType", (int)pVirtualizationType, (LogTraceHelper)mLTH);
            DiskParameterChecker.assertMDisksForVitualizationType(7, pVirtualizationType, pSvcMDiskIDs, pSvcMDiskGroupIDs, mLTH);
            if (pSvcVDiskNames == null) {
                pSvcVDiskNames = new String[pSvcMDiskGroupIDs.length];
            }
            StorageSubsystem[] mStorageSubsystems = new StorageSubsystem[pSvcMDiskGroupIDs.length];
            CIMObjectPath[] mStorageSubsystemCIMOPs = new CIMObjectPath[pSvcMDiskGroupIDs.length];
            StoragePool[] mDiskGroups = new StoragePool[pSvcMDiskGroupIDs.length];
            CIMObjectPath[] mDiskGroupCIMOPs = new CIMObjectPath[pSvcMDiskGroupIDs.length];
            StorageExtent[] mDisks = new StorageExtent[pSvcMDiskGroupIDs.length];
            CIMObjectPath[] mDiskCIMOPs = new CIMObjectPath[pSvcMDiskGroupIDs.length];
            con = ServiceUtils.getConnection();
            CIMOMSelector.SubsystemConnectionData bConData = null;
            for (int idx = 0; idx < pSvcMDiskGroupIDs.length; ++idx) {
                try {
                    String storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)pSvcMDiskGroupIDs[idx], (LogTraceHelper)mLTH);
                    mStorageSubsystems[idx] = ExternalKeyManager.getStorageSubsystem((String)storageSubsystemKey, (DBConnection)con);
                    mDiskGroups[idx] = ExternalKeyManager.getStoragePool((String)pSvcMDiskGroupIDs[idx], (int)mStorageSubsystems[idx].getSubsystemId(), (DBConnection)con);
                    CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
                    bConData = bCimomSelector.getCimomForSubsystem(mStorageSubsystems[idx].getSubsystemId());
                    mStorageSubsystemCIMOPs[idx] = bConData.getSubsystemCop();
                    mDiskGroupCIMOPs[idx] = ExternalKeyManager.getCIMObjectPath((StoragePool)mDiskGroups[idx], (String)bConData.getCimNamespace());
                    if (pVirtualizationType != 0) {
                        if (pSvcMDiskIDs.length != 1) {
                            mDisks[idx] = ExternalKeyManager.getStorageExtent((String)pSvcMDiskIDs[idx], (int)mStorageSubsystems[idx].getSubsystemId(), (DBConnection)con);
                            mDiskCIMOPs[idx] = ExternalKeyManager.getCIMObjectPath((StorageExtent)mDisks[idx], (String)bConData.getCimNamespace());
                        } else if (mDisks[0] == null) {
                            mDisks[idx] = ExternalKeyManager.getStorageExtent((String)pSvcMDiskIDs[idx], (int)mStorageSubsystems[idx].getSubsystemId(), (DBConnection)con);
                            mDiskCIMOPs[idx] = ExternalKeyManager.getCIMObjectPath((StorageExtent)mDisks[idx], (String)bConData.getCimNamespace());
                        } else {
                            mDisks[idx] = mDisks[0];
                            mDiskCIMOPs[idx] = mDiskGroupCIMOPs[0];
                        }
                    }
                    CapabilityData cap = bConData.getCapability();
                    this.checkOperationSupported(cap, storageSubsystemKey, "CreateStorageVolumes", mLTH);
                    continue;
                }
                catch (IDParseException idpEx) {
                    throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)pSvcMDiskGroupIDs[idx], (LogTraceHelper)mLTH);
                }
                catch (EntityNotFoundException mEX) {
                    throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN021654E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
                }
            }
            HashMap<String, CreateSVCStorageVolumesParameter> mParams = new HashMap<String, CreateSVCStorageVolumesParameter>();
            String mStorageSubsystemKey = null;
            for (int mIdx = 0; mIdx < mDiskGroups.length; ++mIdx) {
                mStorageSubsystemKey = (String)ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)mStorageSubsystems[mIdx]);
                CreateSVCStorageVolumesParameter bValue = null;
                bValue = !mParams.containsKey(mStorageSubsystemKey) ? new CreateSVCStorageVolumesParameter(mStorageSubsystems[mIdx], mStorageSubsystemCIMOPs[mIdx]) : (CreateSVCStorageVolumesParameter)mParams.get(mStorageSubsystemKey);
                bValue.addCreateSVCStorageVolumeParameter(mDiskGroups[mIdx], mDiskGroupCIMOPs[mIdx], pSizes[mIdx], pSvcVDiskNames[mIdx], mDisks[mIdx], mDiskCIMOPs[mIdx], pFormatOnCreate, pVirtualizationType, null);
                bValue.setCapability(bConData.getCapability());
                bValue.setCimom(bConData.getCimom());
                mParams.put(mStorageSubsystemKey, bValue);
            }
            if (pSvcMDiskIDs != null && pVirtualizationType == 0) {
                this.getMDisksForSubsystem(mParams, mStorageSubsystemKey, mStorageSubsystems[0].getSubsystemId(), pSvcMDiskIDs, bConData, con, mLTH);
            }
            if (pIoGroup != -1) {
                this.getIOGroupForSubsystem(mParams, mStorageSubsystemKey, pIoGroup, bConData, con, mLTH);
            }
            IStorageSubsystemControl ssController = this.getStorageSubsystemController();
            CreateSVCStorageVolumesParameter[] mSVCParams = new CreateSVCStorageVolumesParameter[mParams.size()];
            mSVCParams = mParams.values().toArray(mSVCParams);
            result = ssController.createSVCDisks(mSVCParams);
            con.commit();
            asyncResult = result;
        }
        catch (SQLException sqlEx) {
            try {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                catch (NotAvailableException naEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)naEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                this.finallyCheckConnection(con, mLTH);
                mLTH.exit(result);
                throw throwable;
            }
        }
        this.finallyCheckConnection(con, mLTH);
        mLTH.exit((Object)result);
        return asyncResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIOGroupForSubsystem(HashMap pParams, String pStorageSubsystemKey, int pIOGroupID, CIMOMSelector.SubsystemConnectionData pConData, DBConnection pDBConnection, LogTraceHelper pLTH) {
        if (pParams.size() > 1) {
            throw DiskMessageHelper.getInvalidParameterException((int)6, (String)"HWN020003E", (Object)new Integer(pIOGroupID), (LogTraceHelper)pLTH);
        }
        DBHelper mDBHelper = null;
        try {
            mDBHelper = new DBHelper();
            IoGroup mIOGroup = mDBHelper.getIOGroupObject(pIOGroupID);
            String bIP = ((CreateSVCStorageVolumesParameter)pParams.get(pStorageSubsystemKey)).getStorageSubsystem().getIpAddress();
            String bNS = ((CreateSVCStorageVolumesParameter)pParams.get(pStorageSubsystemKey)).getStorageSubsystemCIMOP().getNameSpace();
            CIMObjectPath mIOGroupCOP = ExternalKeyManager.getIOGroupCIMObjectPath((String)bIP, (String)mIOGroup.getGroupId(), (String)"IBMTSSVC_IOGroup", (String)bNS);
            ((CreateSVCStorageVolumesParameter)pParams.get(pStorageSubsystemKey)).setIoGroup(mIOGroupCOP);
        }
        finally {
            if (mDBHelper != null) {
                mDBHelper.close();
            }
        }
    }

    private void getMDisksForSubsystem(HashMap pParams, String pStorageSubsystemKey, int pSubsystemId, String[] pSvcMDiskIDs, CIMOMSelector.SubsystemConnectionData pConData, DBConnection pDBConnection, LogTraceHelper pLTH) {
        if (pParams.size() > 1) {
            throw DiskMessageHelper.getInvalidParameterException((int)7, (String)"HWN020003E", (Object)pSvcMDiskIDs, (LogTraceHelper)pLTH);
        }
        int i = 0;
        try {
            ArrayList<StorageExtent> mDisks = new ArrayList<StorageExtent>();
            ArrayList<CIMObjectPath> mDiskCIMOPs = new ArrayList<CIMObjectPath>();
            for (i = 0; i < pSvcMDiskIDs.length; ++i) {
                StorageExtent bDisk = ExternalKeyManager.getStorageExtent((String)pSvcMDiskIDs[i], (int)pSubsystemId, (DBConnection)pDBConnection);
                mDisks.add(bDisk);
                mDiskCIMOPs.add(ExternalKeyManager.getCIMObjectPath((StorageExtent)bDisk, (String)pConData.getCimNamespace()));
            }
            ((CreateSVCStorageVolumesParameter)pParams.get(pStorageSubsystemKey)).setMDisks(mDisks);
            ((CreateSVCStorageVolumesParameter)pParams.get(pStorageSubsystemKey)).setMDiskCIMOPs(mDiskCIMOPs);
        }
        catch (IDParseException idpEx) {
            throw DiskMessageHelper.getInvalidParameterException((int)7, (String)"HWN020003E", (Object)pSvcMDiskIDs[i], (LogTraceHelper)pLTH);
        }
        catch (EntityNotFoundException mEX) {
            throw DiskMessageHelper.getInvalidParameterException((int)7, (String)"HWN021658E", (Object)mEX.getID(), (LogTraceHelper)pLTH);
        }
    }

    private void checkOperationSupported(CapabilityData cap, String storageSubsystemIdentifier, String operation, LogTraceHelper mLTH) throws ServerException {
        if (operation.equals("CreateStorageVolumes") ? cap.getVolumeCreation() == 1 : (operation.equals("DeleteStorageVolumes") ? cap.getVolumeDeletion() == 1 : (operation.equals("ModifyStoragePoolSize") ? cap.getExtentData() == 1 : operation.equals("modifyStorageVolumeSize") && cap.getVolumeExpansion() == 1 && cap.getVolumeShrinking() == 1))) {
            return;
        }
        SRMMessage message = new SRMMessage("HWN021536E", new String[]{storageSubsystemIdentifier, operation});
        ServerException tpcEX = new ServerException(message);
        mLTH.traceError(tpcEX.getLocalizedMessage(), (Throwable)tpcEX);
        throw tpcEX;
    }

    private void checkSizeSupportedByPool(String poolID, long sizeReq, long sizeAvail, LogTraceHelper mLTH) throws ServerException, InvalidParameterException {
        try {
            if (sizeAvail < sizeReq) {
                SRMMessage message = new SRMMessage("HWN021535E", new String[]{poolID, ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)poolID, (LogTraceHelper)mLTH), String.valueOf(sizeReq)});
                throw new ServerException(message);
            }
        }
        catch (IDParseException idpEx) {
            throw DiskMessageHelper.getInvalidParameterException((int)2, (String)"HWN020003E", (Object)poolID, (LogTraceHelper)mLTH);
        }
    }

    private void checkPoolSupportsSize(String[] pStoragePoolIDs, StoragePool[] pStoragePools, CIMObjectPath[] pStoragePoolCIMOPs, long[] pSizes, LogTraceHelper mLTH) throws ServerException, InvalidParameterException {
        ArrayList<String> mPoolsChecked = new ArrayList<String>();
        for (int idx1 = 0; idx1 < pStoragePoolIDs.length - 1; ++idx1) {
            boolean volumesFromPool = false;
            long poolSizeRequired = pSizes[0];
            String firstStoragePoolID = pStoragePoolIDs[idx1];
            boolean bPoolCheckRequired = true;
            for (int idx3 = 0; idx3 < mPoolsChecked.size(); ++idx3) {
                if (!firstStoragePoolID.equals(mPoolsChecked.get(idx3).toString())) continue;
                bPoolCheckRequired = false;
                break;
            }
            if (bPoolCheckRequired) {
                for (int idx2 = idx1 + 1; idx2 < pStoragePoolIDs.length; ++idx2) {
                    if (!firstStoragePoolID.equals(pStoragePoolIDs[idx2])) continue;
                    if (!volumesFromPool) {
                        mPoolsChecked.add(firstStoragePoolID);
                    }
                    volumesFromPool = true;
                    poolSizeRequired += pSizes[idx2];
                }
            }
            if (!volumesFromPool) continue;
            mLTH.traceInfo("Several volumes to be created from same pool. Checking available space.");
            long[] supportedSizes = this.cDM.getDefaultSupportedVolumeSizeRange(firstStoragePoolID);
            long bSpaceRemaining = supportedSizes[1];
            mLTH.traceInfo("Space available:" + bSpaceRemaining);
            mLTH.traceInfo("Space needed:" + poolSizeRequired);
            this.checkSizeSupportedByPool(firstStoragePoolID, poolSizeRequired, bSpaceRemaining, mLTH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(String[] pStorageVolumeIDs, String[] pHostWWPNs, boolean pForce) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"unassignStorageVolumesFromWWPNs", (Object[])new Object[]{pStorageVolumeIDs, pHostWWPNs, new Boolean(pForce)});
        AsyncResult mResult = null;
        try {
            mResult = this.unassignStorageVolumesFromWWPNs(pStorageVolumeIDs, pHostWWPNs, AssignmentParameter.MAP, pForce);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        mLTH.exit((Object)mResult);
        return mResult;
    }

    private void finallyCheckConnection(DBConnection con, LogTraceHelper mLTH) throws ServerException {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
        }
    }
}

