/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.IDiskCollectionService;
import org.eclipse.aperi.disk.api.IDiskConfigurationService;
import org.eclipse.aperi.disk.api.IDiskManagementService;
import org.eclipse.aperi.disk.api.IDiskReportingService;
import org.eclipse.aperi.disk.api.IDiskSVCConfigurationService;
import org.eclipse.aperi.disk.api.impl.DiskCollectionOperations;
import org.eclipse.aperi.disk.api.impl.DiskConfigurationOperations;
import org.eclipse.aperi.disk.api.impl.DiskManagementOperations;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.api.impl.DiskReportingOperations;
import org.eclipse.aperi.disk.collection.DiskCIMScanner;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskManager
implements IDiskReportingService,
IDiskConfigurationService,
IDiskSVCConfigurationService,
IDiskCollectionService,
IDiskManagementService,
ICIMOMMgmtService,
IJobMgmtService {
    private static DiskManager stSingletongInstance = null;
    private ServiceHelper cServiceHelper = null;
    public Status cStatus = new Status(5, 6);
    private DiskCollectionOperations cCollOps = null;
    private DiskConfigurationOperations cConfOps = null;
    private DiskReportingOperations cRepOps = null;
    private DiskManagementOperations cMgmtOps = null;
    private DiskCIMScanner cDiskScanner = null;

    private DiskManager() {
    }

    public static DiskManager getInstance() {
        return stSingletongInstance;
    }

    public AsyncResult createStorageVolumes(long[] sizes, String[] storagePoolIDs, String[] volumeNames, HashMap goal) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.createStorageVolumes(sizes, storagePoolIDs, volumeNames, goal);
    }

    public AsyncResult deleteStorageVolumes(String[] storageVolumeIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.deleteStorageVolumes(storageVolumeIDs);
    }

    public AsyncResult assignStorageVolumesToWWPNs(String[] storageVolumeIDs, String[] subsystemPortIDs, String[] deviceNumbers, String[] hostWWPNs, int hostType, String hostTypeDescription, String[] hostNames, String[] activities, boolean force) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.assignStorageVolumesToWWPNs(storageVolumeIDs, subsystemPortIDs, deviceNumbers, hostWWPNs, hostType, hostTypeDescription, hostNames, activities, force);
    }

    public AsyncResult unassignStorageVolumesFromWWPNs(String[] storageVolumeIDs, String[] hostWWPNs, int pUnMappingMode, boolean force) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.unassignStorageVolumesFromWWPNs(storageVolumeIDs, hostWWPNs, pUnMappingMode, force);
    }

    public AsyncResult modifyStoragePoolSize(String storagePoolID, String[] storageExtentIDsToAdd, String[] storageExtentIDsToRemove) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.modifyStoragePoolSize(storagePoolID, storageExtentIDsToAdd, storageExtentIDsToRemove);
    }

    public AsyncResult modifyStorageVolumeSize(String storageVolumeID, long newSize) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.modifyStorageVolumeSize(storageVolumeID, newSize);
    }

    public AsyncResult unassignStorageVolumesFromWWPNs(String[] storageVolumeIDs, String[] hostWWPNs, boolean force) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.unassignStorageVolumesFromWWPNs(storageVolumeIDs, hostWWPNs, force);
    }

    public Result[] deleteStorageSubsystems(String[] subsystemIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.deleteStorageSubsystems(subsystemIDs);
    }

    public Result removeStorageVolumesFromDB(int[] pVolumeAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removeStorageVolumesFromDB(pVolumeAutoIDs);
    }

    public Result removePhysicalVolumesFromDB(int[] pPhyVolumeAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removePhysicalVolumesFromDB(pPhyVolumeAutoIDs);
    }

    public Result removeStoragePoolsFromDB(int[] pPoolAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removeStoragePoolsFromDB(pPoolAutoIDs);
    }

    public Result removePortsFromDB(int[] pPortAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removePortsFromDB(pPortAutoIDs);
    }

    public AsyncResult createSVCVDisks(long[] sizes, String[] svcMDiskGroupIDs, String[] svcVDiskNames, boolean formatOnCreate, int virtualizationType, int ioGroup, String[] svcMDiskIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.createSVCVDisks(sizes, svcMDiskGroupIDs, svcVDiskNames, formatOnCreate, virtualizationType, ioGroup, svcMDiskIDs);
    }

    public String[] getStorageSubsystems(HashMap attributes) throws ServerException, InvalidParameterException {
        return this.cRepOps.getStorageSubsystems(attributes);
    }

    public HashMap[] getStorageSubsystemAttributes(String[] subsystemIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageSubsystemAttributes(subsystemIDs, attribList);
    }

    public String[] getPortsForSubsystem(String subsystemID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getPortsForSubsystem(subsystemID, attributes);
    }

    public HashMap[] getPortAttributes(String[] portIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getPortAttributes(portIDs, attribList);
    }

    public String[] getStoragePoolsForSubsystem(String subsystemID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStoragePoolsForSubsystem(subsystemID, attributes);
    }

    public HashMap[] getStoragePoolAttributes(String[] poolIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStoragePoolAttributes(poolIDs, attribList);
    }

    public String[] getStorageVolumesForPool(String poolID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumesForPool(poolID, attributes);
    }

    public String[] getStorageVolumesForSubsystem(String subsystemID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumesForSubsystem(subsystemID, attributes);
    }

    public HashMap[] getStorageVolumeAttributes(String[] storageVolumeIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumeAttributes(storageVolumeIDs, attribList);
    }

    public HashMap[] getStorageVolumeAssignments(String[] storageVolumeIDs, HashMap filters) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumeAssignments(storageVolumeIDs, filters);
    }

    public HashMap getHostInfo(String subsystemID, HashMap Filters, boolean IncludeVolumes) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getHostInfo(subsystemID, Filters, IncludeVolumes);
    }

    public HostType[] getHostTypes(String subsystemID) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getHostTypes(subsystemID);
    }

    public long[] getSupportedVolumeSizeRange(String storagePoolID, int dataRedundancy, int packageRedundancy, int deltaReservation) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getSupportedVolumeSizeRange(storagePoolID, dataRedundancy, packageRedundancy, deltaReservation);
    }

    public long[] getDefaultSupportedVolumeSizeRange(String storagePoolID) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getDefaultSupportedVolumeSizeRange(storagePoolID);
    }

    public AsyncResult discoverStorageSubsystems(String[] cimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.discoverStorageSubsystems(cimomIDs);
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] cimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.discoverDevicesFromCIMOM(cimomIDs);
    }

    public AsyncResult probeStorageSubsystems(String[] subsystemIDs, Integer collectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.probeStorageSubsystems(subsystemIDs, (int)collectionType);
    }

    public AsyncResult probeStorageSubsystems(String[] subsystemIDs, int collectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.probeStorageSubsystems(subsystemIDs, collectionType);
    }

    public AsyncResult probeStorageVolume(String pSubsystemID, String pVolumeID, int pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.probeStorageVolume(pSubsystemID, pVolumeID, pCollectionType);
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        DiskManager.addMethodAuthorization(roleMap, "collect", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "discoverStorageSubsystems", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "probeStorageSubsystems", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getCIMOMs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "testCIMOMConnection", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "addCIMOMs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "getCIMOMIDs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "discoverCIMOMs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "deleteCIMOMs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "modifyCIMOMs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "discoverDevicesFromCIMOM", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStorageSubsystems", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStorageSubsystemAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getPortsForSubsystem", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getPortAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStoragePoolsForSubsystem", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStoragePoolAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStorageVolumesForPool", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStorageVolumesForSubsystem", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStorageVolumeAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getStorageVolumeAssignments", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getHostInfo", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getHostTypes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getDefaultSupportedVolumeSizeRange", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "getSupportedVolumeSizeRang", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "createStorageVolumes", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "deleteStorageVolumes", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "assignStorageVolumesToWWPNs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "unassignStorageVolumesFromWWPNs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "modifyStoragePoolSize", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "modifyStorageVolumeSize", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "createSVCVDisks", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "deleteStorageSubsystems", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "getJobStatus", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "waitForJobToComplete", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(roleMap, "cancelJob", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(roleMap, "getLog", RoleChecker.DISK_VIEWER);
        return roleMap;
    }

    private static void addMethodAuthorization(Map pRoleMap, String pMethodName, int pRole) {
        if (pRoleMap == null || pMethodName == null || pRole == 0) {
            throw new IllegalArgumentException();
        }
        pRoleMap.put(pMethodName, new Integer(pRole));
    }

    public String getDescription() {
        return "Service providing disk management capabilities (disk configuration information, disk control, disk monitoring)";
    }

    public String getName() {
        return "DiskManagerService";
    }

    public String getVersion() {
        return "5.0.0";
    }

    public Status getStatus() {
        return this.cStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        boolean bl;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        Boolean mReturn = null;
        try {
            if (this.cStatus.getRunStatus() == 8) {
                this.cStatus.setRunStatus(11);
                mLTH.traceInfo("Initiating operations shutdown...");
                this.cConfOps.handleServiceShutdown();
                this.cCollOps.handleServiceShutdown();
                this.cRepOps.handleServiceShutdown();
                this.cMgmtOps.handleServiceShutdown();
                this.cCollOps = null;
                this.cRepOps = null;
                this.cConfOps = null;
                this.cMgmtOps = null;
                mLTH.traceInfo("DiskCIMScanner shutdown...");
                this.cDiskScanner.shutdown();
                this.cDiskScanner = null;
                mLTH.traceInfo("Shutting down pools...");
                CIMClientPool.shutdown();
                DiskThreadManager.shutdown();
                mLTH.traceInfo("cleanup CIMOMs with pending deletion");
                CIMOMManager.getCIMOMManager().cleanupPendingCIMOMDeletions();
                this.cStatus.setRunStatus(10);
                mReturn = new Boolean(true);
                mLTH.traceInfo("DiskManager with version" + this.getVersion() + "stopped successfully.");
            } else {
                mLTH.traceWarning("Disk Manager not in status \"running\".");
                mReturn = new Boolean(false);
            }
            bl = mReturn;
        }
        catch (Throwable throwable) {
            mLTH.exit(mReturn);
            throw throwable;
        }
        mLTH.exit((Object)mReturn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startup(ServiceHelper pServiceHelper) {
        boolean bl;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"startup", null);
        Boolean mReturn = null;
        if (pServiceHelper == null) {
            mLTH.traceError("No ServiceHelper object is passed.", (Throwable)new NullPointerException());
            return false;
        }
        this.cServiceHelper = pServiceHelper;
        try {
            if (this.cStatus.getRunStatus() != 9 && this.cStatus.getRunStatus() != 8) {
                mLTH.traceInfo("Disk Manager version " + this.getVersion() + " is starting...");
                this.cStatus.setInstallStatus(5);
                this.cStatus.setRunStatus(9);
                DiskManagerConfigSvc.get().checkDefaultConfig();
                mLTH.traceInfo("cleanup CIMOMs with pending deletion");
                CIMOMManager.getCIMOMManager().cleanupPendingCIMOMDeletions();
                mLTH.traceInfo("Staring DiskCIMScanner...");
                this.cDiskScanner = new DiskCIMScanner();
                mLTH.traceInfo("Creating operations classes...");
                this.cCollOps = new DiskCollectionOperations(this);
                this.cRepOps = new DiskReportingOperations(this);
                this.cConfOps = new DiskConfigurationOperations(this);
                this.cMgmtOps = new DiskManagementOperations(this);
                this.cStatus.setRunStatus(8);
                mReturn = new Boolean(true);
                mLTH.traceInfo("Disk Manager version " + this.getVersion() + " started successfully.");
            } else {
                mLTH.traceWarning("Disk Manager already in status \"starting\" or \"running\".");
                mReturn = new Boolean(false);
            }
            bl = mReturn;
        }
        catch (Throwable throwable) {
            mLTH.exit(mReturn);
            throw throwable;
        }
        mLTH.exit((Object)mReturn);
        return bl;
    }

    public AsyncResult discoverCIMOMs(String[] DAs, Boolean localSubnet) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.discoverCIMOMs(DAs, localSubnet.booleanValue());
    }

    public AsyncResult discoverCIMOMs(String[] DAs, boolean localSubnet) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.discoverCIMOMs(DAs, localSubnet);
    }

    public CIMOM[] getCIMOMs() throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.getCIMOMsWithoutPW();
    }

    public Result testDeviceStatus(String pServiceUrl, String pDeviceID) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.testDeviceStatus(pServiceUrl, pDeviceID);
    }

    public String[] getCIMOMIDs() throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.getCIMOMIDs();
    }

    public void modifyCIMOMs(CIMOM[] cimoms) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        mCM.modifyCIMOMs(cimoms);
    }

    public String[] addCIMOMs(CIMOM[] cimoms) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.addCIMOMs(cimoms);
    }

    public void deleteCIMOMs(String[] cimomIDs) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        mCM.deleteCIMOMs(cimomIDs);
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cimoms) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.testCIMOMConnection(cimoms);
    }

    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cimoms, CIMObjectPath device) throws ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.testCIMOMConnection(cimoms, device);
    }

    public AsyncResult getJobStatus(String pJobId) {
        return ServiceUtils.getJobStatus((String)pJobId);
    }

    public AsyncResult waitForJobToComplete(String pJobId) {
        return DiscoverUtils.waitForJobToComplete((String)pJobId);
    }

    public void cancelJob(String pJobId) {
        DiscoverUtils.cancelJob((String)pJobId);
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{name, new Byte(direction), position, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{name, new Byte(direction), position, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(name, direction, position, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, String search, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{name, new Byte(direction), position, search, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{name, new Byte(direction), position, search, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(name, direction, position, search, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{new Integer(agentID), name, new Byte(direction), position, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{new Integer(agentID), name, new Byte(direction), position, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(agentID, name, direction, position, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, String search, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{new Integer(agentID), name, new Byte(direction), position, search, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{new Integer(agentID), name, new Byte(direction), position, search, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(agentID, name, direction, position, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public static void registerSubsystemDataInUse(String pSubsystemID) {
        DiskManager.getInstance().cMgmtOps.registerSubsystemDataInUse(pSubsystemID);
    }

    public static void deregisterSubsystemDataInUse(String pSubsystemID) {
        DiskManager.getInstance().cMgmtOps.deregisterSubsystemDataInUse(pSubsystemID);
    }

    public static boolean checkSubsystemDataInUse(String pSubsystemID) throws IDParseException, EntityNotFoundException {
        return DiskManager.getInstance().cMgmtOps.checkSubsystemDataInUse(pSubsystemID);
    }

    public ServiceHelper getServiceHelper() {
        return this.cServiceHelper;
    }

    protected IJobMgmtService getJobManagement() {
        IJobMgmtService mJobManagement = (IJobMgmtService)this.getServiceHelper().bindLocal("FabricManagerService");
        return mJobManagement;
    }

    static {
        stSingletongInstance = new DiskManager();
    }
}

