/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.DiskManagerFilterKeys;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.IDiskReportingService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.api.impl.DiskReportingOperationsBase;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginFactory;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskReportingOperations
extends DiskOperations
implements IDiskReportingService,
DiskManagerFilterKeys {
    protected static final long VOL_SIZE_RANGE_OPERN_TIMEOUT = 300000L;

    public DiskReportingOperations(DiskManager pDiskManager) {
        super(pDiskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
    }

    public String[] getStorageSubsystems(HashMap pAttributes) throws ServerException, InvalidParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageSubsystems", (Object[])new Object[]{pAttributes});
        LinkedList mReturn = new LinkedList();
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            String[] stringArray = DiskReportingOperationsBase.getStorageSubsystems(pAttributes, mLTH, mConn);
            return stringArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mReturn);
        }
    }

    public HashMap[] getStorageSubsystemAttributes(String[] pSubsystemIDs, String[] pAttribList) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageSubsystemAttributes", (Object[])new Object[]{pSubsystemIDs, pAttribList});
        HashMap[] mSSArray = new HashMap[pSubsystemIDs.length];
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            HashMap[] hashMapArray = DiskReportingOperationsBase.getStorageSubsystemAttributes(pSubsystemIDs, pAttribList, mLTH, mConn);
            return hashMapArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mSSArray);
        }
    }

    public String[] getPortsForSubsystem(String pSubsystemID, HashMap pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getPortsForSubsystem", (Object[])new Object[]{pSubsystemID, pAttributes});
        LinkedList mReturn = new LinkedList();
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            String[] stringArray = DiskReportingOperationsBase.getPortsForSubsystem(pSubsystemID, pAttributes, mLTH, mConn);
            return stringArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mReturn);
        }
    }

    public HashMap[] getPortAttributes(String[] pPortIDs, String[] pAttribList) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getPortAttributes", (Object[])new Object[]{pPortIDs, pAttribList});
        HashMap[] mPortArray = new HashMap[pPortIDs.length];
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            HashMap[] hashMapArray = DiskReportingOperationsBase.getPortAttributes(pPortIDs, pAttribList, mLTH, mConn);
            return hashMapArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mPortArray);
        }
    }

    public String[] getStoragePoolsForSubsystem(String pSubsystemID, HashMap pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStoragePoolsForSubsystem", (Object[])new Object[]{pSubsystemID, pAttributes});
        LinkedList mReturn = new LinkedList();
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            String[] stringArray = DiskReportingOperationsBase.getStoragePoolsForSubsystem(pSubsystemID, pAttributes, mLTH, mConn);
            return stringArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mReturn);
        }
    }

    public HashMap[] getStoragePoolAttributes(String[] pPoolIDs, String[] pAttribList) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStoragePoolAttributes", (Object[])new Object[]{pPoolIDs, pAttribList});
        HashMap[] mPortArray = new HashMap[pPoolIDs.length];
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            HashMap[] hashMapArray = DiskReportingOperationsBase.getStoragePoolAttributes(pPoolIDs, pAttribList, mLTH, mConn);
            return hashMapArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mPortArray);
        }
    }

    public String[] getStorageVolumesForPool(String poolID, HashMap pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumesForPool", (Object[])new Object[]{poolID, pAttributes});
        LinkedList mReturn = new LinkedList();
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            String[] stringArray = DiskReportingOperationsBase.getStorageVolumesForPool(poolID, pAttributes, mLTH, mConn);
            return stringArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mReturn);
        }
    }

    public String[] getStorageVolumesForSubsystem(String pSubsystemID, HashMap pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumesForSubsystem", (Object[])new Object[]{pSubsystemID, pAttributes});
        LinkedList mReturn = new LinkedList();
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            String[] stringArray = DiskReportingOperationsBase.getStorageVolumesForSubsystem(pSubsystemID, pAttributes, mLTH, mConn);
            return stringArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mReturn);
        }
    }

    public HashMap[] getStorageVolumeAttributes(String[] pStorageVolumeIDs, String[] pAttribList) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumeAttributes", (Object[])new Object[]{pStorageVolumeIDs, pAttribList});
        HashMap[] mVolumeArray = new HashMap[pStorageVolumeIDs.length];
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            HashMap[] hashMapArray = DiskReportingOperationsBase.getStorageVolumeAttributes(pStorageVolumeIDs, pAttribList, mLTH, mConn);
            return hashMapArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mVolumeArray);
        }
    }

    public HashMap[] getStorageVolumeAssignments(String[] pStorageVolumeIDs, HashMap pFilters) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumeAssignments", (Object[])new Object[]{pStorageVolumeIDs, pFilters});
        HashMap[] mVolumeAssignments = new HashMap[pStorageVolumeIDs.length];
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            HashMap[] hashMapArray = DiskReportingOperationsBase.getStorageVolumeAssignments(pStorageVolumeIDs, pFilters, mLTH, mConn);
            return hashMapArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit((Object)mVolumeAssignments);
        }
    }

    public HashMap getHostInfo(String pSubsystemID, HashMap pFilters, boolean pIncludeVolumes) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getHostInfo", (Object[])new Object[]{pSubsystemID, pFilters});
        DBConnection mConn = ServiceUtils.getConnection();
        HashMap mHostInfoMap = new HashMap();
        try {
            HashMap hashMap = DiskReportingOperationsBase.getHostInfo(pSubsystemID, pFilters, pIncludeVolumes, mLTH, mConn);
            return hashMap;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mHostInfoMap);
        }
    }

    public HostType[] getHostTypes(String pSubsystemID) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getHostTypes", (Object[])new Object[]{pSubsystemID});
        LinkedList mReturn = new LinkedList();
        DBConnection mConn = ServiceUtils.getConnection();
        try {
            HostType[] hostTypeArray = DiskReportingOperationsBase.getHostTypes(pSubsystemID, mLTH, mConn);
            return hostTypeArray;
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(mReturn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getSupportedVolumeSizeRange(String pStoragePoolID, int pDataRedundancy, int packageRedundancy, int pDeltaReservation) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        long[] result;
        LogTraceHelper mLTH;
        block9: {
            mLTH = LogTraceHelper.entry((Object)this, (String)"getSupportedVolumeSizeRange", (Object[])new Object[]{pStoragePoolID});
            result = null;
            DBConnection mConn = ServiceUtils.getConnection();
            try {
                lArray = result = DiskReportingOperationsBase.getSupportedVolumeSizeRange(pStoragePoolID, pDataRedundancy, packageRedundancy, pDataRedundancy, mLTH, mConn);
                if (mConn == null) break block9;
            }
            catch (SQLException e) {
                try {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)e.getMessage(), (LogTraceHelper)mLTH);
                }
                catch (Throwable throwable) {
                    if (mConn != null) {
                        try {
                            mConn.close();
                        }
                        catch (SQLException pEx) {
                            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
                        }
                    }
                    mLTH.exit(result);
                    throw throwable;
                }
            }
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
        }
        mLTH.exit((Object)result);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getDefaultSupportedVolumeSizeRange(String pStoragePoolID) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getDefaultSupportedVolumeSizeRange", (Object[])new Object[]{pStoragePoolID});
        long[] result = null;
        DBConnection mConn = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"StoragePoolID", (Object)pStoragePoolID, (LogTraceHelper)mLTH);
            StorageSubsystem storageSubsystem = null;
            StoragePool storagePool = null;
            CIMObjectPath storageSystemCIMOP = null;
            CIMObjectPath storagePoolCIMOP = null;
            String storageSubsystemKey = null;
            try {
                storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)pStoragePoolID, (LogTraceHelper)mLTH);
            }
            catch (IDParseException mEx) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)pStoragePoolID, (LogTraceHelper)mLTH);
            }
            mConn = ServiceUtils.getConnection();
            try {
                storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)storageSubsystemKey, (DBConnection)mConn);
                storagePool = ExternalKeyManager.getStoragePool((String)pStoragePoolID, (int)storageSubsystem.getSubsystemId(), (DBConnection)mConn);
            }
            catch (IDParseException mEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)mEx.getMessage(), (LogTraceHelper)mLTH);
            }
            catch (EntityNotFoundException mEX) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)mEX.getID(), (LogTraceHelper)mLTH);
            }
            CIMOMSelector bCimomSelector = CIMOMSelector.getSelector();
            CIMOMSelector.SubsystemConnectionData bConData = bCimomSelector.getCimomForSubsystem(storageSubsystem.getSubsystemId());
            storageSystemCIMOP = bConData.getSubsystemCop();
            storagePoolCIMOP = ExternalKeyManager.getCIMObjectPath((StoragePool)storagePool, (String)bConData.getCimNamespace());
            ConfigurationParameter mConfParam = new ConfigurationParameter(storageSubsystem, storageSystemCIMOP);
            mConfParam.setCapability(bConData.getCapability());
            mConfParam.setCimom(bConData.getCimom());
            CIMClientWrapper bCimClient = CIMClientPool.getClient((String)bConData.getCimom().getUserId(), (String)bConData.getCimom().getPassword(), (String)bConData.getCimom().getServiceUrl(), (String)bConData.getCimom().getInteropSchemaNamespace());
            bCimClient.setTimeout(300000L);
            mConfParam.setCIMClientWrapper(bCimClient);
            IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin(mConfParam);
            lArray = result = bPlugin.getDefaultSupportedVolumeSizeRange(storagePool, storagePoolCIMOP);
        }
        catch (Throwable throwable) {
            try {
                if (mConn != null) {
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            mLTH.exit(result);
            throw throwable;
        }
        try {
            if (mConn != null) {
                mConn.close();
            }
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
        }
        mLTH.exit((Object)result);
        return lArray;
    }
}

