/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.DiskManagerFilterKeys;
import org.eclipse.aperi.disk.api.ExtendedVolumeAssignments;
import org.eclipse.aperi.disk.api.HostInfo;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.SingleMapping;
import org.eclipse.aperi.disk.api.WWPNCollection;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelperDummy;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginFactory;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.ClientSettingData;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.MaskingInfo;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlDataPath;
import org.sblim.wbem.cim.CIMObjectPath;

public abstract class DiskReportingOperationsBase
implements DiskManagerFilterKeys {
    public static String[] getStorageSubsystems(HashMap pAttributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStorageSubsystems", pLTH, pConn);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        Hashtable mWhereClause = DiskReportingHelper.createWhereClauseMap(StorageSubsystem.class, (Map)pAttributes, (LogTraceHelper)pLTH);
        Vector<Object> mColumns = new Vector<Object>(Arrays.asList("NAME", "NAME_FORMAT"));
        StorageSubsystem.StorageSubsystemCursor mCursor = StorageSubsystem.getCursor((DBConnection)pConn, (Hashtable)(mWhereClause.size() == 0 ? null : mWhereClause), null);
        while (mCursor.next()) {
            StorageSubsystem mCurrInst = mCursor.getAttributes();
            mReturn.add(ExternalKeyConverter.getStorageSubsystemKey((StorageSubsystem)mCurrInst));
        }
        mCursor.close();
        pConn.commit();
        return mReturn.toArray(new String[0]);
    }

    public static HashMap[] getStorageSubsystemAttributes(String[] pSubsystemIDs, String[] pAttribList, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStorageSubsystemAttributes", pLTH, pConn);
        HashMap[] mSSArray = new HashMap[pSubsystemIDs.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"subsystemIDs", (Object)pSubsystemIDs, (LogTraceHelper)pLTH);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"attribList", (Object)pAttribList, (LogTraceHelper)pLTH);
        for (int mLoop = 0; mLoop < pSubsystemIDs.length; ++mLoop) {
            HashMap mStorageSubsystem = null;
            Hashtable mWhereClause = ExternalKeyConverter.getStorageSubsystemWhereClause((String)pSubsystemIDs[mLoop], (LogTraceHelper)pLTH);
            StorageSubsystem.StorageSubsystemCursor mCursor = StorageSubsystem.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
            while (mCursor.next()) {
                StorageSubsystem mCurrInst = mCursor.getAttributes();
                mStorageSubsystem = DiskReportingHelper.getAttributes((Object)mCurrInst, (String[])pAttribList, (LogTraceHelper)pLTH);
            }
            mCursor.close();
            if (mStorageSubsystem == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)pSubsystemIDs[mLoop], (LogTraceHelper)pLTH);
            }
            mSSArray[mLoop] = mStorageSubsystem;
            mStorageSubsystem = null;
            pConn.commit();
        }
        return mSSArray;
    }

    public static String[] getPortsForSubsystem(String pSubsystemID, HashMap pAttributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getPortsForSubsystem", pLTH, pConn);
        LinkedList<String> mReturn = new LinkedList<String>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)pSubsystemID, (LogTraceHelper)pLTH);
        Hashtable mWhereClause = DiskReportingHelper.createWhereClauseMap(Port.class, (Map)pAttributes, (LogTraceHelper)pLTH);
        Object mSubSystem_ID = DiskReportingOperationsBase.getSubsystem_ID(pSubsystemID, pConn, pLTH);
        DiskReportingOperationsBase.addStorageSubsystem(mWhereClause, mSubSystem_ID, pLTH);
        Port.PortCursor mCursor = Port.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
        while (mCursor.next()) {
            Port mCurrInst = mCursor.getAttributes();
            mReturn.add(ExternalKeyConverter.getPortKey((Port)mCurrInst));
        }
        mCursor.close();
        pConn.commit();
        return mReturn.toArray(new String[0]);
    }

    private static String getSubsystem(String pSubsystemID, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException {
        HashMap<String, String> mParam = new HashMap<String, String>();
        mParam.put("SUBSYSTEM_ID", pSubsystemID);
        String[] mSubSystem = DiskReportingOperationsBase.getStorageSubsystems(mParam, pLTH, pConn);
        if (mSubSystem[0] != null) {
            return mSubSystem[0];
        }
        throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)pSubsystemID, (LogTraceHelper)pLTH);
    }

    private static Object getSubsystem_ID(String pSubsystemID, DBConnection pConn, LogTraceHelper pLTH) throws ServerException, InvalidParameterException {
        try {
            StorageSubsystem mSystem = null;
            mSystem = ExternalKeyManager.getStorageSubsystem((String)pSubsystemID, (DBConnection)pConn);
            return new Integer(mSystem.getSubsystemId());
        }
        catch (IDParseException mEx) {
            throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)"subsystemID", (LogTraceHelper)pLTH);
        }
        catch (EntityNotFoundException mEX) {
            throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)mEX.getID(), (LogTraceHelper)pLTH);
        }
    }

    private static Hashtable addStorageSubsystem(Hashtable pWhereClause, Object pSubsystemID, LogTraceHelper pLTH) throws ServerException {
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, (String)"SUBSYSTEM_ID", (LogTraceHelper)pLTH);
        pWhereClause.put(mInfo, pSubsystemID.toString());
        return pWhereClause;
    }

    public static HashMap[] getPortAttributes(String[] pPortIDs, String[] pAttribList, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getPortAttributes", pLTH, pConn);
        HashMap[] mPortArray = new HashMap[pPortIDs.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"PortIDs", (Object)pPortIDs, (LogTraceHelper)pLTH);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"attribList", (Object)pAttribList, (LogTraceHelper)pLTH);
        for (int mLoop = 0; mLoop < pPortIDs.length; ++mLoop) {
            HashMap mPort = null;
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>(pPortIDs.length + 1);
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, (String)"NAME", (LogTraceHelper)pLTH);
            mWhereClause.put(mInfo, pPortIDs[mLoop]);
            Port.PortCursor mCursor = Port.getCursor((DBConnection)pConn, mWhereClause, null);
            while (mCursor.next()) {
                Port mCurrInst = mCursor.getAttributes();
                mPort = DiskReportingHelper.getAttributes((Object)mCurrInst, (String[])pAttribList, (LogTraceHelper)pLTH);
            }
            mCursor.close();
            if (mPort == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021656E", (Object)pPortIDs[mLoop], (LogTraceHelper)pLTH);
            }
            mPortArray[mLoop] = mPort;
            mPort = null;
            pConn.commit();
        }
        return mPortArray;
    }

    public static String[] getStoragePoolsForSubsystem(String pSubsystemID, HashMap pAttributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStoragePoolsForSubsystem", pLTH, pConn);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)pSubsystemID, (LogTraceHelper)pLTH);
        Hashtable mWhereClause = DiskReportingHelper.createWhereClauseMap(StoragePool.class, (Map)pAttributes, (LogTraceHelper)pLTH);
        Object mSubSystem_ID = DiskReportingOperationsBase.getSubsystem_ID(pSubsystemID, pConn, pLTH);
        DiskReportingOperationsBase.addStorageSubsystem(mWhereClause, mSubSystem_ID, pLTH);
        StoragePool.StoragePoolCursor mCursor = StoragePool.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
        try {
            while (mCursor.next()) {
                StoragePool mCurrInst = mCursor.getAttributes();
                if (mCurrInst.getPrimordial() != 0) continue;
                mReturn.add(ExternalKeyConverter.getStoragePoolKey((StoragePool)mCurrInst, (String)pSubsystemID, (LogTraceHelper)pLTH));
            }
            mCursor.close();
        }
        catch (IDParseException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)pLTH);
        }
        pConn.commit();
        return mReturn.toArray(new String[0]);
    }

    public static HashMap[] getStoragePoolAttributes(String[] pPoolIDs, String[] pAttribList, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStoragePoolAttributes", pLTH, pConn);
        HashMap[] mPortArray = new HashMap[pPoolIDs.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"PoolIDs", (Object)pPoolIDs, (LogTraceHelper)pLTH);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"attribList", (Object)pAttribList, (LogTraceHelper)pLTH);
        for (int mLoop = 0; mLoop < pPoolIDs.length; ++mLoop) {
            HashMap mPort = null;
            Hashtable mWhereClause = ExternalKeyConverter.getPoolWhereclause((LogTraceHelper)pLTH, (String)pPoolIDs[mLoop], (DBConnection)pConn);
            StoragePool.StoragePoolCursor mCursor = StoragePool.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
            while (mCursor.next()) {
                StoragePool mCurrInst = mCursor.getAttributes();
                mPort = DiskReportingHelper.getAttributes((Object)mCurrInst, (String[])pAttribList, (LogTraceHelper)pLTH);
            }
            mCursor.close();
            if (mPort == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)pPoolIDs[mLoop], (LogTraceHelper)pLTH);
            }
            mPortArray[mLoop] = mPort;
            mPort = null;
            pConn.commit();
        }
        return mPortArray;
    }

    public static String[] getStorageVolumesForPool(String poolID, HashMap pAttributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumesForPool", pLTH, pConn);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"poolID", (Object)poolID, (LogTraceHelper)pLTH);
        Hashtable mWhereClause = DiskReportingHelper.createWhereClauseMap(StorageVolume.class, (Map)pAttributes, (LogTraceHelper)pLTH);
        Object mPool_ID = DiskReportingOperationsBase.getPool_ID(poolID, pLTH, pConn);
        DiskReportingOperationsBase.addStoragePoolID(mWhereClause, mPool_ID, pLTH);
        boolean bRunOnce = true;
        StorageVolume.StorageVolumeCursor mCursor = StorageVolume.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
        String mSSub = null;
        while (mCursor.next()) {
            StorageVolume mVolCurrInst = mCursor.getAttributes();
            if (bRunOnce) {
                mSSub = DiskReportingOperationsBase.getSubsystem(new Integer(mVolCurrInst.getSubsystemId()).toString(), pLTH, pConn);
                bRunOnce = false;
            }
            try {
                mReturn.add(ExternalKeyConverter.getStorageVolumeKey((StorageVolume)mVolCurrInst, mSSub, (LogTraceHelper)pLTH));
            }
            catch (IDParseException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)pLTH);
            }
        }
        mCursor.close();
        pConn.commit();
        return mReturn.toArray(new String[0]);
    }

    private static Hashtable addStoragePoolID(Hashtable pWhereClause, Object pPool_ID, LogTraceHelper pLTH) throws ServerException {
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, (String)"POOL_ID", (LogTraceHelper)pLTH);
        pWhereClause.put(mInfo, pPool_ID.toString());
        return pWhereClause;
    }

    private static Object getPool_ID(String pPoolID, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException {
        String[] mSUID = new String[]{pPoolID};
        String[] mParams = new String[]{"POOL_ID"};
        HashMap[] mPoolMap = DiskReportingOperationsBase.getStoragePoolAttributes(mSUID, mParams, pLTH, pConn);
        if (mPoolMap[0] != null) {
            return mPoolMap[0].get(mParams[0]);
        }
        throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)pPoolID, (LogTraceHelper)pLTH);
    }

    public static String[] getStorageVolumesForSubsystem(String pSubsystemID, HashMap pAttributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumesForSubsystem", pLTH, pConn);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)pSubsystemID, (LogTraceHelper)pLTH);
        Hashtable mWhereClause = DiskReportingHelper.createWhereClauseMap(StorageVolume.class, (Map)pAttributes, (LogTraceHelper)pLTH);
        Object mSubSystem_ID = DiskReportingOperationsBase.getSubsystem_ID(pSubsystemID, pConn, pLTH);
        DiskReportingOperationsBase.addStorageSubsystem(mWhereClause, mSubSystem_ID, pLTH);
        StorageVolume.StorageVolumeCursor mCursor = StorageVolume.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
        while (mCursor.next()) {
            try {
                StorageVolume mVolCurrInst = mCursor.getAttributes();
                mReturn.add(ExternalKeyConverter.getStorageVolumeKey((StorageVolume)mVolCurrInst, (String)pSubsystemID, (LogTraceHelper)pLTH));
            }
            catch (IDParseException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)pLTH);
            }
        }
        mCursor.close();
        pConn.commit();
        return mReturn.toArray(new String[0]);
    }

    public static HashMap[] getStorageVolumeAttributes(String[] pStorageVolumeIDs, String[] pAttribList, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumeAttributes", pLTH, pConn);
        HashMap[] mVolumeArray = new HashMap[pStorageVolumeIDs.length];
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)pStorageVolumeIDs, (LogTraceHelper)pLTH);
        ParameterChecker.assertMandatoryParameter((int)2, (String)"Attributes", (Object)pAttribList, (LogTraceHelper)pLTH);
        for (int mLoop = 0; mLoop < pStorageVolumeIDs.length; ++mLoop) {
            HashMap mVolume = null;
            Hashtable mWhereClause = ExternalKeyConverter.getVolumeWhereclause((LogTraceHelper)pLTH, (String)pStorageVolumeIDs[mLoop], (DBConnection)pConn);
            StorageVolume.StorageVolumeCursor mCursor = StorageVolume.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
            while (mCursor.next()) {
                StorageVolume mVolCurrInst = mCursor.getAttributes();
                mVolume = DiskReportingHelper.getAttributes((Object)mVolCurrInst, (String[])pAttribList, (LogTraceHelper)pLTH);
            }
            mCursor.close();
            mVolumeArray[mLoop] = mVolume;
            mVolume = null;
            pConn.commit();
        }
        return mVolumeArray;
    }

    public static HashMap[] getStorageVolumeAssignments(String[] pStorageVolumeIDs, HashMap pFilters, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getStorageVolumeAssignments", pLTH, pConn);
        HashMap[] mVolumeAssignments = new HashMap[pStorageVolumeIDs.length];
        HashMap mWWPNSave = new HashMap(50);
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)pStorageVolumeIDs, (LogTraceHelper)pLTH);
        for (int mLoop = 0; mLoop < pStorageVolumeIDs.length; ++mLoop) {
            Hashtable mWhereClause = new Hashtable(5);
            String[] mParameter = new String[]{"SVID"};
            HashMap[] pVolume_IDMap = null;
            pVolume_IDMap = DiskReportingOperationsBase.getStorageVolumeAttributes(new String[]{pStorageVolumeIDs[mLoop]}, mParameter, pLTH, pConn);
            if (pVolume_IDMap[0] == null) {
                mVolumeAssignments[mLoop] = null;
                continue;
            }
            DiskReportingOperationsBase.addVolumeID(mWhereClause, pVolume_IDMap[0].get(mParameter[0]), pLTH);
            DataPath.DataPathCursor mCursor = DataPath.getCursor((DBConnection)pConn, mWhereClause, null);
            HashMap<Integer, MaskingInfo> mMaskSave = new HashMap<Integer, MaskingInfo>();
            MaskingInfo mMaskInfoCurrInst = null;
            LinkedList<String> mTargetPortIDList = new LinkedList<String>();
            Vector<ExtendedVolumeAssignments> mExtVolAssVector = new Vector<ExtendedVolumeAssignments>();
            Vector<Integer> mDataPathVector = new Vector<Integer>();
            while (mCursor.next()) {
                String mHostWWPN;
                DataPath mDataPathCurrInst = mCursor.getAttributes();
                mDataPathVector.add(new Integer(mDataPathCurrInst.getInitiatorPortId()));
                mMaskInfoCurrInst = (MaskingInfo)mMaskSave.get(new Integer(mDataPathCurrInst.getMaskingInfoId()));
                if (mMaskInfoCurrInst == null && mDataPathCurrInst.getMaskingInfoId() != 0) {
                    mMaskInfoCurrInst = DiskReportingOperationsBase.getMaskInfo(pConn, new Integer(mDataPathCurrInst.getMaskingInfoId()), pLTH);
                    mMaskSave.put(new Integer(mDataPathCurrInst.getMaskingInfoId()), mMaskInfoCurrInst);
                    pLTH.traceInfo(mMaskInfoCurrInst.toString());
                }
                if (!mTargetPortIDList.contains(mHostWWPN = DiskReportingOperationsBase.getHostWWPN(mWWPNSave, mDataPathCurrInst.getTargetPortId(), pConn, pLTH))) {
                    mTargetPortIDList.add(mHostWWPN);
                }
                ExtendedVolumeAssignments mExtVolAss = DiskReportingOperationsBase.getExtVolAss(mDataPathCurrInst, mMaskInfoCurrInst, pConn, mWWPNSave, pLTH);
                mExtVolAssVector.add(mExtVolAss);
            }
            mCursor.close();
            HashMap<String, ExtendedVolumeAssignments> mMap = new HashMap<String, ExtendedVolumeAssignments>();
            Iterator mExtVolAssListIt = mExtVolAssVector.iterator();
            Iterator mDataPathIt = mDataPathVector.iterator();
            while (mExtVolAssListIt.hasNext()) {
                ExtendedVolumeAssignments mExtVolAss = (ExtendedVolumeAssignments)mExtVolAssListIt.next();
                Integer mInitiatorPort = (Integer)mDataPathIt.next();
                mExtVolAss.setSubsystemPorts(mTargetPortIDList.toArray(new String[0]));
                String mHostWWPN = DiskReportingOperationsBase.getHostWWPN(mWWPNSave, mInitiatorPort, pConn, pLTH);
                if (!DiskReportingOperationsBase.checkFilters(pFilters, mExtVolAss, mHostWWPN, pLTH)) continue;
                mMap.put(mHostWWPN, mExtVolAss);
            }
            mVolumeAssignments[mLoop] = mMap;
        }
        return mVolumeAssignments;
    }

    private static boolean checkFilters(HashMap pFilters, ExtendedVolumeAssignments pExtVolAss, String pHostWWPN, LogTraceHelper pLTH) {
        String[] pWWPNFilter = (String[])pFilters.get("WWPN");
        boolean mReturnWWPN = false;
        boolean mReturnLUN = false;
        boolean mReturnCOLLID = false;
        if (pHostWWPN != null && pWWPNFilter != null) {
            for (int mLoop = 0; mLoop < pWWPNFilter.length; ++mLoop) {
                if (!pHostWWPN.equalsIgnoreCase(pWWPNFilter[mLoop])) continue;
                pLTH.traceInfo("WWPN found");
                mReturnWWPN = true;
            }
        } else {
            pLTH.traceInfo("WWPN not set");
            mReturnWWPN = true;
        }
        String[] pLUNFilter = (String[])pFilters.get("LUNID");
        if (pExtVolAss != null && pLUNFilter != null) {
            for (int mLoop = 0; mLoop < pWWPNFilter.length; ++mLoop) {
                if (!pExtVolAss.getVolumeDeviceNumber().equalsIgnoreCase(pWWPNFilter[mLoop])) continue;
                pLTH.traceInfo("LUNID found");
                mReturnLUN = true;
            }
        } else {
            pLTH.traceInfo("LUNID not set");
            mReturnLUN = true;
        }
        String pCOLLID = (String)pFilters.get("COLLECTIONID");
        if (pExtVolAss != null && pCOLLID != null) {
            WWPNCollection mWWPNColl = pExtVolAss.getCollection();
            if (mWWPNColl != null && pExtVolAss.getCollection().getID().equalsIgnoreCase(pCOLLID)) {
                pLTH.traceInfo("COLLECTIONID found");
                mReturnCOLLID = true;
            }
        } else {
            pLTH.traceInfo("COLLECTIONID not set");
            mReturnCOLLID = true;
        }
        return mReturnCOLLID && mReturnLUN && mReturnWWPN;
    }

    private static String getHostWWPN(Map pWWPNSave, int pPortId, DBConnection pConn, LogTraceHelper pLTH) throws ServerException {
        try {
            Integer mPortID = new Integer(pPortId);
            String mReturn = (String)pWWPNSave.get(mPortID);
            if (mReturn == null) {
                Port mPort = null;
                Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>(1);
                ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, (String)"PORT_ID", (LogTraceHelper)pLTH);
                mWhereClause.put(mInfo, mPortID.toString());
                Port.PortCursor mCursor = Port.getCursor((DBConnection)pConn, mWhereClause, null);
                while (mCursor.next()) {
                    mPort = mCursor.getAttributes();
                    mReturn = mPort.getName();
                    pWWPNSave.put(mPortID, mReturn);
                }
                mCursor.close();
            }
            return mReturn;
        }
        catch (SQLException pEx) {
            pLTH.traceError("Internal error: SQLException", (Throwable)pEx);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)pLTH);
        }
    }

    private static ExtendedVolumeAssignments getExtVolAss(DataPath pDataPathCurrInst, MaskingInfo pMaskInfoCurrInst, DBConnection pConn, HashMap pWWPNSave, LogTraceHelper pLTH) throws ServerException {
        ExtendedVolumeAssignments mReturn = new ExtendedVolumeAssignments();
        mReturn.setCaption(pMaskInfoCurrInst.getHostCaption());
        mReturn.setId(pMaskInfoCurrInst.getHostId());
        mReturn.setName(pMaskInfoCurrInst.getHostElementName());
        String mWWPN = DiskReportingOperationsBase.getHostWWPN(pWWPNSave, pDataPathCurrInst.getDeviceLunId(), pConn, pLTH);
        mReturn.setVolumeDeviceNumber(mWWPN);
        WWPNCollection mWWPNColl = new WWPNCollection();
        mWWPNColl.setName(pMaskInfoCurrInst.getCollectionName());
        mWWPNColl.setID(pMaskInfoCurrInst.getCollectionId());
        mReturn.setCollection(mWWPNColl);
        mReturn.setVolumeDeviceNumber(Integer.toHexString(pDataPathCurrInst.getDeviceLunId()));
        return mReturn;
    }

    private static HostInfo getHostInfo(DataPath pDataPathCurrInst, MaskingInfo pMaskInfoCurrInst, DBConnection pConn, HashMap pWWPNSave, LogTraceHelper pLTH) throws ServerException {
        HostInfo mReturn = new HostInfo();
        mReturn.setCaption(pMaskInfoCurrInst.getHostCaption());
        mReturn.setId(pMaskInfoCurrInst.getHostId());
        mReturn.setName(pMaskInfoCurrInst.getHostElementName());
        WWPNCollection mWWPNColl = new WWPNCollection();
        mWWPNColl.setName(pMaskInfoCurrInst.getCollectionName());
        mWWPNColl.setID(pMaskInfoCurrInst.getCollectionId());
        return mReturn;
    }

    private static MaskingInfo getMaskInfo(DBConnection pConn, Integer pMaskingInfoId, LogTraceHelper pLTH) throws ServerException {
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StorageVolumeIDs", (Object)pMaskingInfoId, (LogTraceHelper)pLTH);
        try {
            MaskingInfo mReturn = null;
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>(2);
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(MaskingInfo.class, (String)"MASKING_INFO_ID", (LogTraceHelper)pLTH);
            mWhereClause.put(mInfo, pMaskingInfoId.toString());
            MaskingInfo.MaskingInfoCursor mCursor = MaskingInfo.getCursor((DBConnection)pConn, mWhereClause, null);
            while (mCursor.next()) {
                mReturn = mCursor.getAttributes();
            }
            mCursor.close();
            return mReturn;
        }
        catch (SQLException pEx) {
            pLTH.traceError("Internal error: SQLException", (Throwable)pEx);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)pLTH);
        }
    }

    private static Hashtable addVolumeID(Hashtable pWhereClause, Object pObject, LogTraceHelper pLTH) throws ServerException {
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(DataPath.class, (String)"VOLUME_ID", (LogTraceHelper)pLTH);
        pWhereClause.put(mInfo, pObject.toString());
        return pWhereClause;
    }

    public static HashMap getHostInfo(String pSubsystemID, HashMap pFilters, boolean pIncludeVolumes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getHostInfo", pLTH, pConn);
        LinkedList<Integer> mInitPortList = new LinkedList<Integer>();
        HashMap<String, HostInfo> mHostInfoMap = new HashMap<String, HostInfo>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)pSubsystemID, (LogTraceHelper)pLTH);
        Object pSSID = DiskReportingOperationsBase.getSubsystem_ID(pSubsystemID, pConn, pLTH);
        DBResultSet mResultSet = SqlDataPath.sqlQuery((DBConnection)pConn, (int)SqlDataPath.queryHostInfoIndex, (String)(pSSID.toString() + ")"), null);
        while (mResultSet.next()) {
            int mID = mResultSet.getInt("INITIATOR_PORT_ID");
            mInitPortList.add(new Integer(mID));
        }
        mResultSet.getStatement().close();
        LinkedList mHostInfoList = new LinkedList();
        HashMap mWWPNSave = new HashMap();
        HashMap<Integer, MaskingInfo> mMaskInfoCache = new HashMap<Integer, MaskingInfo>();
        for (Integer mIP : mInitPortList) {
            HashMap mVolumeMapping = new HashMap();
            HostInfo mHostInfo = new HostInfo();
            String mHostWWPN = DiskReportingOperationsBase.getHostWWPN(mWWPNSave, mIP, pConn, pLTH);
            if (!DiskReportingOperationsBase.checkFiltersWWPN(pFilters, mHostWWPN, pLTH)) {
                pLTH.traceInfo("WWPNnot used");
                continue;
            }
            mHostInfo.setStorageID(mHostWWPN);
            mHostInfo.setStorageSubsystemID(pSubsystemID);
            Hashtable mWhereClause = new Hashtable(5);
            DiskReportingOperationsBase.addIPID(mWhereClause, mIP, pLTH);
            DataPath.DataPathCursor mCursor = DataPath.getCursor((DBConnection)pConn, mWhereClause, null);
            while (mCursor.next()) {
                MaskingInfo mMaskInfoCurrInst;
                DataPath mDataPathCurrInst = mCursor.getAttributes();
                if (pIncludeVolumes) {
                    if (!DiskReportingOperationsBase.checkFiltersLUN(pFilters, mDataPathCurrInst, pLTH)) {
                        pLTH.traceInfo("LUNIDnot used");
                        continue;
                    }
                    DiskReportingOperationsBase.addVolumeMapping(mVolumeMapping, mDataPathCurrInst, pSubsystemID, pConn, pLTH, mWWPNSave);
                }
                if ((mMaskInfoCurrInst = (MaskingInfo)mMaskInfoCache.get(new Integer(mDataPathCurrInst.getMaskingInfoId()))) == null) {
                    mMaskInfoCurrInst = DiskReportingOperationsBase.getMaskInfo(pConn, new Integer(mDataPathCurrInst.getMaskingInfoId()), pLTH);
                    mMaskInfoCache.put(new Integer(mDataPathCurrInst.getMaskingInfoId()), mMaskInfoCurrInst);
                }
                if (mHostInfo.getId() != null) continue;
                mHostInfo.setCaption(mMaskInfoCurrInst.getHostCaption());
                mHostInfo.setId(mMaskInfoCurrInst.getHostId());
                mHostInfo.setName(mMaskInfoCurrInst.getHostElementName());
            }
            mCursor.close();
            mHostInfo.setCollections(DiskReportingOperationsBase.addWWPNCollection(mMaskInfoCache, pFilters, pLTH));
            mHostInfo.setVolumeMappings(mVolumeMapping);
            mHostInfoMap.put(mHostWWPN, mHostInfo);
        }
        return mHostInfoMap;
    }

    private static boolean checkFiltersLUN(HashMap pFilters, DataPath pDataPathCurrInst, LogTraceHelper pLTH) {
        String[] pLUNFilter = (String[])pFilters.get("LUNID");
        boolean mReturnLUN = false;
        if (pDataPathCurrInst != null && pLUNFilter != null) {
            String pLUN = Integer.toHexString(pDataPathCurrInst.getDeviceLunId());
            for (int mLoop = 0; mLoop < pLUNFilter.length; ++mLoop) {
                if (!pLUN.equalsIgnoreCase(pLUNFilter[mLoop])) continue;
                pLTH.traceInfo("LUNID found");
                mReturnLUN = true;
            }
        }
        if (pLUNFilter == null) {
            mReturnLUN = true;
        }
        return mReturnLUN;
    }

    private static boolean checkFiltersWWPN(HashMap pFilters, String pHostWWPN, LogTraceHelper pLTH) {
        String[] pWWPNFilter = (String[])pFilters.get("WWPN");
        boolean mReturnWWPN = false;
        if (pHostWWPN != null && pWWPNFilter != null) {
            for (int mLoop = 0; mLoop < pWWPNFilter.length; ++mLoop) {
                if (!pHostWWPN.equalsIgnoreCase(pWWPNFilter[mLoop])) continue;
                pLTH.traceInfo("WWPN found");
                mReturnWWPN = true;
            }
        }
        if (pWWPNFilter == null) {
            mReturnWWPN = true;
        }
        return mReturnWWPN;
    }

    private static WWPNCollection[] addWWPNCollection(Map pMaskInfoCache, HashMap pFilters, LogTraceHelper pLTH) {
        Iterator mIt = pMaskInfoCache.keySet().iterator();
        HashSet<WWPNCollection> mCollectionSet = new HashSet<WWPNCollection>();
        while (mIt.hasNext()) {
            Integer mKey = (Integer)mIt.next();
            MaskingInfo mMaskInfo = (MaskingInfo)pMaskInfoCache.get(mKey);
            WWPNCollection mCollection = new WWPNCollection();
            mCollection.setID(mMaskInfo.getCollectionId());
            mCollection.setName(mMaskInfo.getCollectionName());
            if (!DiskReportingOperationsBase.checkFilterCollection(pFilters, mCollection, pLTH)) {
                pLTH.traceInfo("COLLECTIONIDnot used");
                continue;
            }
            mCollectionSet.add(mCollection);
        }
        return mCollectionSet.toArray(new WWPNCollection[0]);
    }

    private static boolean checkFilterCollection(HashMap pFilters, WWPNCollection pCollection, LogTraceHelper pLTH) {
        String pCollectionFilter = (String)pFilters.get("COLLECTIONID");
        boolean mReturn = false;
        if (pCollectionFilter != null && pCollection != null && pCollection.getID().equalsIgnoreCase(pCollectionFilter)) {
            pLTH.traceInfo("COLLECTIONID found");
            mReturn = true;
        }
        if (pCollectionFilter == null) {
            mReturn = true;
        }
        return mReturn;
    }

    private static void addVolumeMapping(HashMap pVolumeMapping, DataPath pDataPathCurrInst, String pSubsystem, DBConnection pConn, LogTraceHelper pLTH, Map pWWPNSave) throws SQLException, ServerException {
        String mVolID = DiskReportingOperationsBase.getStorageVolumeID(pDataPathCurrInst.getVolumeId(), pConn, pLTH, pSubsystem);
        SingleMapping mMapping = (SingleMapping)pVolumeMapping.get(mVolID);
        String mWWPN = DiskReportingOperationsBase.getHostWWPN(pWWPNSave, pDataPathCurrInst.getTargetPortId(), pConn, pLTH);
        if (mMapping != null) {
            String[] mSSPortOld = mMapping.getSubsystemPorts();
            String[] mSSPort = new String[mSSPortOld.length + 1];
            System.arraycopy(mSSPortOld, 0, mSSPort, 0, mSSPortOld.length);
            mSSPort[mSSPort.length - 1] = mWWPN;
            mMapping.setSubsystemPorts(mSSPort);
        } else {
            mMapping = new SingleMapping();
            mMapping.setLUNID(Integer.toHexString(pDataPathCurrInst.getDeviceLunId()));
            String[] mSSPort = new String[]{mWWPN};
            mMapping.setSubsystemPorts(mSSPort);
        }
        if (mVolID != null && mVolID.length() > 0) {
            pVolumeMapping.put(mVolID, mMapping);
        }
    }

    private static String getStorageVolumeID(int pVolumeId, DBConnection pConn, LogTraceHelper pLTH, String pSubsystem) throws ServerException, SQLException {
        Hashtable<ColumnInfo, Object> mWhereClause = new Hashtable<ColumnInfo, Object>(1);
        String mReturn = "";
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, (String)"SVID", (LogTraceHelper)pLTH);
        mWhereClause.put(mInfo, new Integer(pVolumeId).toString());
        mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, (String)"SUBSYSTEM_ID", (LogTraceHelper)pLTH);
        mWhereClause.put(mInfo, (Integer)DiskReportingOperationsBase.getSubsystem_ID(pSubsystem, pConn, pLTH));
        StorageVolume.StorageVolumeCursor mCursor = StorageVolume.getCursor((DBConnection)pConn, mWhereClause, null);
        while (mCursor.next()) {
            try {
                StorageVolume mCurrInst = mCursor.getAttributes();
                mReturn = (String)ExternalKeyConverter.getStorageVolumeKey((StorageVolume)mCurrInst, (String)pSubsystem, (LogTraceHelper)pLTH);
            }
            catch (IDParseException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)pLTH);
            }
        }
        mCursor.close();
        return mReturn;
    }

    private static Hashtable addIPID(Hashtable pWhereClause, Integer pInitPort, LogTraceHelper pLTH) throws ServerException {
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(DataPath.class, (String)"INITIATOR_PORT_ID", (LogTraceHelper)pLTH);
        pWhereClause.put(mInfo, pInitPort.toString());
        return pWhereClause;
    }

    public static HostType[] getHostTypes(String pSubsystemID, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getHostTypes", pLTH, pConn);
        LinkedList<HostType> mReturn = new LinkedList<HostType>();
        ParameterChecker.assertMandatoryParameter((int)1, (String)"subsystemID", (Object)pSubsystemID, (LogTraceHelper)pLTH);
        Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>(1);
        Object mSSID = DiskReportingOperationsBase.getSubsystem_ID(pSubsystemID, pConn, pLTH);
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(ClientSettingData.class, (String)"SUBSYSTEM_ID", (LogTraceHelper)pLTH);
        mWhereClause.put(mInfo, mSSID.toString());
        ClientSettingData.ClientSettingDataCursor mCursor = ClientSettingData.getCursor((DBConnection)pConn, mWhereClause, null);
        while (mCursor.next()) {
            ClientSettingData mCurrInst = mCursor.getAttributes();
            HostType mHT = new HostType();
            String bClientType = mCurrInst.getClientTypes();
            if (bClientType.indexOf("[") != -1) {
                bClientType = bClientType.substring(1, bClientType.length() - 1);
            }
            mHT.setClientTypes(ParameterHelper.convertTointArray((String)bClientType));
            String bClientDescriptions = mCurrInst.getClientTypeDescriptions();
            if (bClientDescriptions != null) {
                if (bClientDescriptions.indexOf("[") != -1) {
                    bClientDescriptions = bClientDescriptions.substring(1, bClientDescriptions.length() - 1);
                }
                mHT.setClientDescriptions(ParameterHelper.convertToStringArray((String)bClientDescriptions));
            }
            mHT.setElementName(mCurrInst.getElementName());
            mReturn.add(mHT);
        }
        mCursor.close();
        pConn.commit();
        return mReturn.toArray(new HostType[0]);
    }

    public static long[] getSupportedVolumeSizeRange(String pStoragePoolID, int pDataRedundancy, int packageRedundancy, int pDeltaReservation, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException {
        pLTH = DiskReportingOperationsBase.checkBaseParameter("getSupportedVolumeSizeRange", pLTH, pConn);
        ParameterChecker.assertMandatoryParameter((int)1, (String)"StoragePoolID", (Object)pStoragePoolID, (LogTraceHelper)pLTH);
        long[] result = null;
        StorageSubsystem storageSubsystem = null;
        StoragePool storagePool = null;
        CIMObjectPath storageSystemCIMOP = null;
        CIMObjectPath storagePoolCIMOP = null;
        try {
            String storageSubsystemKey = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)pStoragePoolID, (LogTraceHelper)pLTH);
        }
        catch (IDParseException idpEx) {
            throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)pStoragePoolID, (LogTraceHelper)pLTH);
        }
        IStorageConfigurationPlugin bPlugin = StorageConfigurationPluginFactory.getPlugin(new ConfigurationParameter(storageSubsystem, storageSystemCIMOP));
        result = bPlugin.getSupportedVolumeSizeRange(storagePool, storagePoolCIMOP, pDataRedundancy, packageRedundancy, pDeltaReservation);
        return result;
    }

    private static LogTraceHelper checkBaseParameter(String pMethodName, LogTraceHelper pLTH, DBConnection pConn) {
        LogTraceHelper mLTH = pLTH;
        if (pLTH == null) {
            mLTH = new LogTraceHelperDummy((Object)"DiskReportingOperationsBase", pMethodName);
        }
        if (pConn == null) {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"DBConnection", (Object)pConn, (LogTraceHelper)mLTH);
        }
        if (pLTH != null) {
            return pLTH;
        }
        return mLTH;
    }
}

