/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.disk.collection.CapabilityUpdatePostProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;

public class ESSCapabilityUpdatePostProcess
extends CapabilityUpdatePostProcess {
    public ESSCapabilityUpdatePostProcess() {
        super("ESS/DS6K CapabilityData Update Post Processing");
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"ESSCapabilityUpdatePostProcess", null);
        mLTH.exit(null);
    }

    protected ESSCapabilityUpdatePostProcess(String pName) {
        super(pName);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("CapabilityUpdatePostProcess", null, "Array", "IBM", "IBM TotalStorage DS6000", null), new DiscoverProcess.RegistrationData("CapabilityUpdatePostProcess", null, "Array", "IBM", "IBM TotalStorage", null), new DiscoverProcess.RegistrationData("CapabilityUpdatePostProcess", null, "Array", "IBM", "F20", null), new DiscoverProcess.RegistrationData("CapabilityUpdatePostProcess", null, "Array", "IBM", "800", null)};
    }

    protected int getNumberOfVolumes(StorageSubsystem pSubSystem) {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRAIDLevels(DBConnection pCon, int pDeviceID) throws SQLException {
        String string;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getRAIDLevels", (Object[])new Object[]{pCon, new Integer(pDeviceID)});
        StringBuffer mReturnBuffer = new StringBuffer();
        String mReturn = null;
        try {
            String mSchema = pCon.getSchema();
            String mSQLStatement = "select DISTINCT RAID_LEVEL from " + mSchema + "." + StoragePool.getTablename() + " where (" + "SUBSYSTEM_ID" + " = " + pDeviceID + ")";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            DBResultSet mDBResult = ComplexQuery.sqlQuery((DBConnection)pCon, (String)mSQLStatement, null);
            String mCurrRaid = null;
            while (mDBResult.next()) {
                mCurrRaid = mDBResult.getString(1);
                if (mCurrRaid == null) continue;
                mReturnBuffer.append(mCurrRaid.trim());
                mReturnBuffer.append(",");
            }
            mDBResult.close();
            mLTH.traceHigh("Query result: " + mReturnBuffer.toString());
            mReturn = mReturnBuffer.toString();
            mReturn = mReturn.trim().length() > 0 ? mReturn.substring(0, mReturn.length() - 1) : "";
            string = mReturn = this.consolidateRAIDLevels(mReturn);
        }
        catch (Throwable throwable) {
            mLTH.exit(mReturn);
            throw throwable;
        }
        mLTH.exit((Object)mReturn);
        return string;
    }

    private String consolidateRAIDLevels(String pLevelString) {
        TreeSet<String> mReturnSet = new TreeSet<String>();
        StringTokenizer mRAIDTok = new StringTokenizer(pLevelString, " ,", false);
        String mCurrTok2 = null;
        while (mRAIDTok.hasMoreTokens()) {
            mCurrTok2 = mRAIDTok.nextToken();
            if (!mCurrTok2.startsWith("raid")) continue;
            mReturnSet.add(mCurrTok2);
        }
        StringBuffer mReturnBuffer = new StringBuffer();
        for (String mCurrTok2 : mReturnSet) {
            mReturnBuffer.append(mCurrTok2);
            mReturnBuffer.append(",");
        }
        String mReturn = mReturnBuffer.toString();
        mReturn = mReturn.trim().length() > 0 ? mReturn.substring(0, mReturn.length() - 1) : "";
        return mReturn;
    }
}

