/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.SVCExtentUpdatePostProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;

public class ExtentUpdatePostProcess
extends SVCExtentUpdatePostProcess {
    public ExtentUpdatePostProcess() {
        this("MDISK Update Post Processing");
    }

    protected ExtentUpdatePostProcess(String pName) {
        super(pName);
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"ExtentUpdatePostProcess", null);
        mLTH.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("ExtentUpdatePostProcess", null, "Array", null, null, null)};
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = null;
        try {
            int mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            mCon = ServiceUtils.getConnection();
            StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
            List mBCEntrys = this.getReferencedBackendController(mStorageSubsystem.getSubsystemId(), mCon);
            for (BackendController mBC : mBCEntrys) {
                mLTH.traceInfo("Referenced subsystem " + mBC.getOwningSubsystemId() + " is called");
                StorageSubsystem mStorageSubsystem2 = this.getStorageSubsystem(mBC.getOwningSubsystemId(), mCon, mLTH);
                this.processMdisk(mCon, Integer.toString(mStorageSubsystem.getSubsystemId()), mStorageSubsystem2);
            }
            mReturn = new Result(0);
            mCon.commit();
        }
        catch (Exception pEx) {
            if (mCon != null) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pInnerEx) {
                    // empty catch block
                }
            }
            mReturn = new Result(1);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pInnerEx) {}
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }

    protected List getReferencedBackendController(int pRefID, DBConnection pCon) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getReferencedBackendController", (Object[])new Object[]{new Integer(pRefID), pCon});
        LinkedList<BackendController> mReturn = new LinkedList<BackendController>();
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(BackendController.class, (String)"REFERENCED_SUBSYSTEM_ID", (LogTraceHelper)mLTH);
            mWhereClause.put(mInfo, Integer.toString(pRefID));
            BackendController.BackendControllerCursor mCursor = BackendController.getCursor((DBConnection)pCon, mWhereClause, null);
            while (mCursor.next()) {
                mReturn.add(mCursor.getObject());
            }
            mCursor.close();
        }
        catch (SQLException e) {
            mLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }
}

