/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

public class MappingMaskingProcessor
extends DiskCIMProcessor
implements CIMNames,
DiscoveryConstants {
    PersistMaskingInfoHelper cMaskingInfoToPersist;
    PersistDataPathHelper cDataPathToPersist;
    Map cSHWIDList = new HashMap();
    protected Map cAuthPrivileges = new HashMap();

    public MappingMaskingProcessor(String pScannerId) {
        super(pScannerId);
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"MappingMaskingProcessor", null);
        this.cMaskingInfoToPersist = new PersistMaskingInfoHelper(this.cSHWIDList, this.cAuthPrivileges);
        this.cDataPathToPersist = new PersistDataPathHelper();
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAssociation(JobInfo job, String pAssociation, String pContextCIMClassName, Hashtable entity1_properties, String pCIMClassNameToPersist, Hashtable pCIMPropertiesToPersist, Hashtable properties) throws DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"handleAssociation", (Object[])new Object[]{job.getResourceId(), pAssociation, pCIMClassNameToPersist});
        ProbePerfTracker.ProbeAction mProbeActionHandleAssociation = TrackProbePerformance.startProbeAction((String)this.getScanID(job), (int)ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ASSOCIATION);
        if (mLTH.isTraceHighEnabled()) {
            mLTH.traceHigh("Properties to persist: " + DiskMessageHelper.toMsgString((Object)pCIMPropertiesToPersist));
        }
        try {
            if (pAssociation.equals("CIM_ComponentCS")) {
            } else if (pAssociation.equals("CIM_SystemDevice")) {
                this.cMaskingInfoToPersist.addProtocolController(pCIMPropertiesToPersist, job, this, mLTH);
                this.cDataPathToPersist.addProtocolController(pCIMPropertiesToPersist);
            } else if (pAssociation.equals("CIM_AuthorizedTarget")) {
                this.cMaskingInfoToPersist.addAuthorizedPrivilege(pCIMPropertiesToPersist);
                this.cMaskingInfoToPersist.clearCurrentSHWIDCollection();
                this.cMaskingInfoToPersist.clearCurrentSHWID();
            } else if (pAssociation.equals("CIM_AuthorizedSubject")) {
                if (pCIMPropertiesToPersist.get("originalcimclassname").equals("CIM_StorageHardwareID")) {
                    this.cMaskingInfoToPersist.clearCurrentSHWIDCollection();
                    this.cMaskingInfoToPersist.addSHWID(pCIMPropertiesToPersist, mLTH);
                } else {
                    this.cMaskingInfoToPersist.clearCurrentSHWID();
                    this.cMaskingInfoToPersist.addSystemSpecificCollection(pCIMPropertiesToPersist);
                }
            } else if (pAssociation.equals("CIM_ElementSettingData")) {
                this.cMaskingInfoToPersist.addClientSettingData(job, this, pCIMPropertiesToPersist, mLTH);
            } else if (pAssociation.equals("CIM_MemberOfCollection")) {
                if (pCIMPropertiesToPersist.get("originalcimclassname").equals("CIM_SystemSpecificCollection")) {
                    this.cMaskingInfoToPersist.addSystemSpecificCollection(pCIMPropertiesToPersist);
                } else {
                    this.cMaskingInfoToPersist.addSHWID(pCIMPropertiesToPersist, mLTH);
                }
            } else if (pAssociation.equals("CIM_ProtocolControllerForPort")) {
                this.cDataPathToPersist.addTargetFCPort(pCIMPropertiesToPersist, mLTH);
                this.cMaskingInfoToPersist.persist(job, (Processor)this, mLTH);
                this.cDataPathToPersist.addMaskingInfo(this.cMaskingInfoToPersist.getSHWIDSet());
            } else if (pAssociation.equals("CIM_ProtocolControllerForUnit")) {
                this.cDataPathToPersist.addStorageVolume(pCIMPropertiesToPersist, mLTH);
                this.cDataPathToPersist.persist(job, (Processor)this);
            } else if (pAssociation.equals("CIM_HostedService")) {
                this.cMaskingInfoToPersist.persist(job, (Processor)this, mLTH);
                this.cMaskingInfoToPersist.clear();
                this.cMaskingInfoToPersist.clearCurrentSHWIDCollection();
            } else if (pAssociation.equals("CIM_ConcreteDependency")) {
                this.cMaskingInfoToPersist.addSHWID(pCIMPropertiesToPersist, mLTH);
            } else {
                mLTH.traceWarning("Can not handle result of association " + pAssociation);
            }
        }
        finally {
            TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)mProbeActionHandleAssociation);
            mLTH.exit(null);
        }
    }

    public void setDBReferences(Hashtable pHashtable) {
        super.setDBReferences(pHashtable);
        Enumeration mDBRefEnum = pHashtable.elements();
        Hashtable mDBREF = new Hashtable();
        while (mDBRefEnum.hasMoreElements()) {
            Hashtable bCIMDBReferences = (Hashtable)mDBRefEnum.nextElement();
            mDBREF.putAll(bCIMDBReferences);
        }
        this.cMaskingInfoToPersist.addStorageSubsystem(mDBREF);
    }

    public void addVolumeToDataPathForSVC(String pSVID, String pLUNID) throws DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"addVolumeToDataPathForSVC", (Object[])new Object[]{pSVID, pLUNID});
        this.cDataPathToPersist.addStorageVolume(pSVID, pLUNID, mLTH);
        this.cDataPathToPersist.persist(null, (Processor)this);
    }

    public void addProtocolControllerToDatapathAndMaskingInfoForSVC(JobInfo pJob, Hashtable pCIMPropertiesToPersist) throws DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"addProtocolControllerToDatapathAndMaskingInfoForSVC", (Object[])new Object[]{pJob, pCIMPropertiesToPersist});
        this.cMaskingInfoToPersist.addProtocolController(pCIMPropertiesToPersist, pJob, this, mLTH);
        this.cDataPathToPersist.addProtocolController(pCIMPropertiesToPersist);
    }

    private class PersistDataPathHelper {
        private static final String DATA_PATH_DBMAPPER = "DataPath";
        private Set cInitiatorPorts = null;
        private String cVolumeID = "";
        private String cDeviceLUN = "";
        private String cNamespaceID = null;
        private Set cTargetPortIDs = new HashSet();

        public void addMaskingInfo(Set pInitiatorPorts) {
            this.cInitiatorPorts = pInitiatorPorts;
        }

        public void addProtocolController(Map pProtocolControllerProperties) {
            this.cTargetPortIDs.clear();
        }

        public void addTargetFCPort(Map pFCPortProperties, LogTraceHelper pLTH) throws DiscoveryException {
            int mTargetPortID = Short.MIN_VALUE;
            try {
                Hashtable mFCPortCOP = (Hashtable)pFCPortProperties.get("Dependent".toLowerCase());
                if (this.cNamespaceID == null) {
                    this.cNamespaceID = MappingMaskingProcessor.this.getNamespaceID(MappingMaskingProcessor.this.getCIMServiceURL(), MappingMaskingProcessor.this.getCIMNamespace(), pLTH);
                }
                if ((mTargetPortID = MappingMaskingProcessor.this.getPortID(mFCPortCOP, Integer.parseInt(this.cNamespaceID))) != Integer.MIN_VALUE) {
                    pLTH.traceInfo("TargetPort " + mTargetPortID + " found in DB for CIM Device ID " + mFCPortCOP.get("DeviceID".toLowerCase()));
                    this.cTargetPortIDs.add("" + mTargetPortID);
                }
            }
            catch (SQLException bEx) {
                try {
                    MappingMaskingProcessor.this.handleSQLException(pLTH, bEx, "MappingMaskingProcessor.addFCPort");
                }
                catch (SQLException bInnerEx) {
                    pLTH.traceError(bEx.getMessage(), (Throwable)bInnerEx);
                    throw new DiscoveryException((Throwable)bInnerEx);
                }
            }
        }

        public void addStorageVolume(Map pStorageVolumeProperties, LogTraceHelper pLTH) throws DiscoveryException {
            String mDeviceLUNString = (String)pStorageVolumeProperties.get("DeviceNumber".toLowerCase());
            if (mDeviceLUNString != null) {
                int mDeviceLUNNumber = Integer.parseInt(mDeviceLUNString, 16);
                this.cDeviceLUN = String.valueOf(mDeviceLUNNumber);
            } else {
                this.cDeviceLUN = null;
            }
            int mVolumeID = Integer.MIN_VALUE;
            try {
                Hashtable mVolumeCOP = (Hashtable)pStorageVolumeProperties.get("Dependent".toLowerCase());
                if (this.cNamespaceID == null) {
                    this.cNamespaceID = MappingMaskingProcessor.this.getNamespaceID(MappingMaskingProcessor.this.getCIMServiceURL(), MappingMaskingProcessor.this.getCIMNamespace(), pLTH);
                }
                if ((mVolumeID = MappingMaskingProcessor.this.getVolumeID(mVolumeCOP, Integer.parseInt(this.cNamespaceID))) != Integer.MIN_VALUE) {
                    pLTH.traceInfo("Volume " + mVolumeID + " found in DB for CIM Device ID " + mVolumeCOP.get("DeviceID".toLowerCase()));
                    this.cVolumeID = "" + mVolumeID;
                } else {
                    pLTH.traceWarning("Volume for CIM Device ID " + mVolumeCOP.get("DeviceID".toLowerCase()) + " NOT found in DB!");
                    this.cVolumeID = null;
                }
            }
            catch (SQLException bEx) {
                try {
                    MappingMaskingProcessor.this.handleSQLException(pLTH, bEx, "MappingMaskingProcessor.addStorageVolume");
                }
                catch (SQLException pInnerEx) {
                    pLTH.traceError(bEx.getMessage(), (Throwable)pInnerEx);
                    throw new DiscoveryException((Throwable)pInnerEx);
                }
            }
        }

        public void persist(JobInfo pJob, Processor pProcessor) throws DiscoveryException {
            Hashtable<String, String> bPropertiesToPersist = new Hashtable<String, String>();
            if (this.cDeviceLUN != null) {
                bPropertiesToPersist.put("DEVICE_LUN_ID".toLowerCase(), this.cDeviceLUN);
            }
            if (this.cVolumeID == null || this.cVolumeID.length() == 0) {
                return;
            }
            bPropertiesToPersist.put("VOLUME_ID".toLowerCase(), this.cVolumeID);
            if (this.cInitiatorPorts != null) {
                for (SHWIDHelper bInitiatorPort : this.cInitiatorPorts) {
                    bPropertiesToPersist.put("MASKING_INFO_ID".toLowerCase(), bInitiatorPort.getMaskingInfoID());
                    bPropertiesToPersist.put("INITIATOR_PORT_ID".toLowerCase(), bInitiatorPort.getHostPortID());
                    bPropertiesToPersist.put("UNKNOWN_HOST_NAME".toLowerCase(), bInitiatorPort.getHostElementName());
                    Iterator bPortIter = this.cTargetPortIDs.iterator();
                    while (bPortIter.hasNext()) {
                        bPropertiesToPersist.put("TARGET_PORT_ID".toLowerCase(), (String)bPortIter.next());
                        pProcessor.handleEntity(pJob, DATA_PATH_DBMAPPER, bPropertiesToPersist);
                    }
                }
            }
        }

        public void addStorageVolume(String pSVID, String pCollectionScsiId, LogTraceHelper pLTH) throws DiscoveryException {
            this.cVolumeID = pSVID;
            this.cDeviceLUN = pCollectionScsiId;
        }
    }

    private class PersistMaskingInfoHelper {
        private static final String MASKING_INFO_DBMAPPER = "MaskingInfo";
        private boolean cPeristed = true;
        private String cSubsystemID = "";
        private SHWIDHelper cCurrentSHWID;
        private Map cSystemSpecifcCollection = null;
        private Map cAllSHWIDs;
        private Map cAllAuthPrivileges;
        String cCurrentAuthPrivilegeID;
        private Set cSHWIDSet = new HashSet();
        private String cControllerCOP = "";

        public PersistMaskingInfoHelper(Map pAllSHWIDs, Map pAllAuthPrivileges) {
            this.cAllSHWIDs = pAllSHWIDs;
            this.cAllAuthPrivileges = pAllAuthPrivileges;
        }

        public void clear() {
            this.cPeristed = false;
            this.cControllerCOP = null;
            this.cCurrentAuthPrivilegeID = null;
            this.cSHWIDSet.clear();
        }

        public void clearCurrentSHWID() {
            this.cCurrentSHWID = null;
        }

        public void clearCurrentSHWIDCollection() {
            this.cSystemSpecifcCollection = null;
        }

        public void addAuthorizedPrivilege(Map pAuthorizedPrivilegeProperties) {
            String mAuthPrivID = (String)pAuthorizedPrivilegeProperties.get("instanceid");
            if (this.cAllAuthPrivileges.containsKey(mAuthPrivID)) {
                Set bSHWIDsOfAuthPrivilege = (Set)this.cAllAuthPrivileges.get(mAuthPrivID);
                this.cSHWIDSet.addAll(bSHWIDsOfAuthPrivilege);
            } else {
                this.cAllAuthPrivileges.put(mAuthPrivID, new HashSet());
            }
            this.cCurrentAuthPrivilegeID = mAuthPrivID;
        }

        public void addStorageSubsystem(Map pStorageSubsystemProperties) {
            this.cSubsystemID = (String)pStorageSubsystemProperties.get("ref_toplevelsystem_id");
            if (this.cSubsystemID == null) {
                this.cSubsystemID = "";
            }
        }

        public void addSHWID(Map pSHWIDProperties, LogTraceHelper pLTH) throws DiscoveryException {
            if (pSHWIDProperties.get("storageid") != null) {
                String mHostID = (String)pSHWIDProperties.get("instanceid");
                if (!this.cAllSHWIDs.containsKey(mHostID)) {
                    SHWIDHelper bNewSHWID = new SHWIDHelper(pSHWIDProperties, pLTH);
                    this.cAllSHWIDs.put(mHostID, bNewSHWID);
                    this.cCurrentSHWID = bNewSHWID;
                } else {
                    this.cCurrentSHWID = (SHWIDHelper)this.cAllSHWIDs.get(mHostID);
                }
                if (this.cSystemSpecifcCollection != null) {
                    this.cCurrentSHWID.addSystemSpecificCollection(this.cSystemSpecifcCollection);
                }
                if (this.cCurrentAuthPrivilegeID != null) {
                    Set bAuthPrivSHWIDSet = (Set)this.cAllAuthPrivileges.get(this.cCurrentAuthPrivilegeID);
                    bAuthPrivSHWIDSet.add(this.cCurrentSHWID);
                    this.cSHWIDSet.add(this.cCurrentSHWID);
                }
            } else {
                pLTH.traceWarning("CIM_StorageHardwareID Instance not persisted due missing storageid: " + DiskMessageHelper.toMsgString((Object)pSHWIDProperties));
            }
        }

        public void addClientSettingData(JobInfo pJob, DiskCIMProcessor pProcessor, Hashtable pClientSettingDataProperties, LogTraceHelper pLTH) throws DiscoveryException {
            this.cCurrentSHWID.addClientSettingData(pJob, pProcessor, pClientSettingDataProperties, pLTH);
        }

        public void addSystemSpecificCollection(Map pSystemSpecificCollectionProperties) {
            if (this.cCurrentSHWID == null) {
                this.cSystemSpecifcCollection = pSystemSpecificCollectionProperties;
            } else {
                this.cCurrentSHWID.addSystemSpecificCollection(pSystemSpecificCollectionProperties);
            }
        }

        public void addProtocolController(Map pProtocolControllerProperties, JobInfo pJob, DiskCIMProcessor pProcessor, LogTraceHelper pLTH) throws DiscoveryException {
            this.persist(pJob, (Processor)pProcessor, pLTH);
            this.clear();
            this.cControllerCOP = this.getCOPforController(pProtocolControllerProperties, MappingMaskingProcessor.this.getCIMNamespace());
            if (this.cControllerCOP == null) {
                this.cControllerCOP = "";
            }
        }

        public void persist(JobInfo pJob, Processor pProcessor, LogTraceHelper pLTH) throws DiscoveryException {
            if (!this.cPeristed) {
                Hashtable<String, String> mPropertiesToPersist = new Hashtable<String, String>();
                mPropertiesToPersist.put("ref_toplevelsystem_id", this.cSubsystemID);
                mPropertiesToPersist.put("CONTOLLER_COP".toLowerCase(), this.cControllerCOP);
                for (SHWIDHelper bSHWID : this.cSHWIDSet) {
                    mPropertiesToPersist.put("HOST_ID".toLowerCase(), bSHWID.getHostID());
                    mPropertiesToPersist.put("HOST_ELEMENT_NAME".toLowerCase(), bSHWID.getHostElementName());
                    mPropertiesToPersist.put("HOST_CAPTION".toLowerCase(), bSHWID.getHostCaption());
                    if (bSHWID.getClientSettingDataID() != null) {
                        mPropertiesToPersist.put("SETTING_DATA_ID".toLowerCase(), bSHWID.getClientSettingDataID());
                    } else {
                        mPropertiesToPersist.remove("SETTING_DATA_ID".toLowerCase());
                    }
                    Map bSHWIDCollections = bSHWID.getCollectionList();
                    if (bSHWIDCollections.isEmpty()) {
                        mPropertiesToPersist.remove("COLLECTION_ID".toLowerCase());
                        mPropertiesToPersist.remove("COLLECTION_NAME".toLowerCase());
                        pProcessor.handleEntity(pJob, MASKING_INFO_DBMAPPER, mPropertiesToPersist);
                    } else {
                        for (String bCollectionId : bSHWIDCollections.keySet()) {
                            mPropertiesToPersist.put("COLLECTION_ID".toLowerCase(), bCollectionId);
                            String bCollectionName = (String)bSHWIDCollections.get(bCollectionId);
                            if (bCollectionName != null && bCollectionName.length() > 0) {
                                mPropertiesToPersist.put("COLLECTION_NAME".toLowerCase(), bCollectionName);
                            } else {
                                mPropertiesToPersist.remove("COLLECTION_NAME".toLowerCase());
                            }
                            pProcessor.handleEntity(pJob, MASKING_INFO_DBMAPPER, mPropertiesToPersist);
                        }
                    }
                    Map bMaskingInfoDBRefs = (Map)MappingMaskingProcessor.this.getDBReferences().get(MASKING_INFO_DBMAPPER);
                    if (bMaskingInfoDBRefs != null) {
                        String bMaskInfoID = (String)bMaskingInfoDBRefs.get("ref_masking_info_id");
                        if (bMaskInfoID != null) {
                            bSHWID.setMaskingInfoID(bMaskInfoID);
                            continue;
                        }
                        pLTH.traceWarning("No ref_masking_info_id set for MaskingInfo!");
                        continue;
                    }
                    pLTH.traceWarning("No DBRef Info found for MaskingInfo!");
                }
                this.cPeristed = true;
            }
        }

        private String getCOPforController(Map pController, String pNamespace) {
            CIMObjectPath mCIMCOP = new CIMObjectPath((String)pController.get("creationclassname"), pNamespace);
            CIMProperty bDeviceID = new CIMProperty("DeviceID", new CIMValue(pController.get("deviceid"), CIMDataType.getPredefinedType((int)8)));
            mCIMCOP.addKey(bDeviceID);
            CIMProperty cCreationClassName = new CIMProperty("CreationClassName", new CIMValue((Object)((String)pController.get("creationclassname")), CIMDataType.getPredefinedType((int)8)));
            mCIMCOP.addKey(cCreationClassName);
            CIMProperty cSystemCreationClassName = new CIMProperty("SystemCreationClassName", new CIMValue((Object)((String)pController.get("systemcreationclassname")), CIMDataType.getPredefinedType((int)8)));
            mCIMCOP.addKey(cSystemCreationClassName);
            CIMProperty bSystemName = new CIMProperty("SystemName", new CIMValue(pController.get("systemname"), CIMDataType.getPredefinedType((int)8)));
            mCIMCOP.addKey(bSystemName);
            return mCIMCOP.toString();
        }

        public Set getSHWIDSet() {
            return this.cSHWIDSet;
        }
    }

    private class SHWIDHelper {
        private static final short FCPORT_NAMEFORMAT = 1;
        private String cMaskingInfoID = "";
        private String cHostID = "";
        private String cHostCaption = "";
        private String cHostElementName = "";
        private String cHostPortID = "";
        private String cClientSettingDataID = null;
        private Map cCollectionList = new HashMap();

        public SHWIDHelper(Map pSHWIDProperties, LogTraceHelper pLTH) throws DiscoveryException {
            this.cHostID = (String)pSHWIDProperties.get("instanceid");
            if (this.cHostID == null) {
                this.cHostID = "";
            }
            this.cHostCaption = (String)pSHWIDProperties.get("caption");
            if (this.cHostCaption == null) {
                this.cHostCaption = "";
            }
            this.cHostElementName = (String)pSHWIDProperties.get("elementname");
            if (this.cHostElementName == null) {
                this.cHostElementName = "";
            }
            int mInitiatorPortID = Integer.MIN_VALUE;
            String mInitiatorPortWWN = (String)pSHWIDProperties.get("StorageID".toLowerCase());
            Port bInitiatorPort = new Port();
            bInitiatorPort.setName(mInitiatorPortWWN);
            bInitiatorPort.setNameFormat((short)1);
            try {
                boolean mPortExist = bInitiatorPort.retrieve(MappingMaskingProcessor.this.getConnection());
                if (mPortExist) {
                    mInitiatorPortID = bInitiatorPort.getPortId();
                }
                bInitiatorPort = new Port();
                bInitiatorPort.setName(mInitiatorPortWWN);
                bInitiatorPort.setNameFormat((short)1);
                if (!mPortExist) {
                    pLTH.traceInfo("InitiatorPort " + mInitiatorPortWWN + "+" + 1 + " not found in DB, creating with HOST_URL_BY_SUBSYSTEM " + this.cHostElementName);
                    String bPortType = (String)pSHWIDProperties.get("IDType".toLowerCase());
                    bInitiatorPort.setType((short)0);
                    bInitiatorPort.setDetectable((short)1);
                    bInitiatorPort.setHostUrlBySubsystem(this.cHostElementName);
                    bInitiatorPort.setDisplayName(mInitiatorPortWWN);
                    bInitiatorPort.setPortId(AutoIdentifier.getIdentifier((int)1, (int)1));
                    bInitiatorPort.setUpdateTimestamp(CurrentTime.getTimestamp((DBConnection)MappingMaskingProcessor.this.getConnection()));
                    mPortExist = bInitiatorPort.insert(MappingMaskingProcessor.this.getConnection());
                    mInitiatorPortID = bInitiatorPort.getPortId();
                    MappingMaskingProcessor.this.commit(pLTH);
                } else {
                    bInitiatorPort.setHostUrlBySubsystem(this.cHostElementName);
                    bInitiatorPort.update(MappingMaskingProcessor.this.getConnection());
                    MappingMaskingProcessor.this.commit(pLTH);
                }
            }
            catch (SQLException bEx) {
                MappingMaskingProcessor.this.rollback(pLTH);
                pLTH.traceError("Creation of initiatorPort " + mInitiatorPortWWN + "+" + 1 + " failed", (Throwable)bEx);
            }
            this.cHostPortID = String.valueOf(mInitiatorPortID);
        }

        public void addClientSettingData(JobInfo pJob, DiskCIMProcessor pProcessor, Hashtable pClientSettingDataProperties, LogTraceHelper pLTH) throws DiscoveryException {
            String mOrigCIMClassname = (String)pClientSettingDataProperties.get("originalcimclassname");
            try {
                pProcessor.handleEntity(pJob, mOrigCIMClassname, pClientSettingDataProperties);
            }
            catch (Exception bEx) {
                pLTH.traceError(bEx.getMessage(), (Throwable)bEx);
            }
            Map bClientSettingDBRefs = (Map)pProcessor.getDBReferences().get(mOrigCIMClassname);
            if (bClientSettingDBRefs != null) {
                this.cClientSettingDataID = (String)bClientSettingDBRefs.get("ref_setting_data_id");
            }
        }

        public void addSystemSpecificCollection(Map pSystemSpecificCollectionProperties) {
            if (pSystemSpecificCollectionProperties != null) {
                this.cCollectionList.put((String)pSystemSpecificCollectionProperties.get("instanceid"), (String)pSystemSpecificCollectionProperties.get("elementname"));
            }
        }

        public Map getCollectionList() {
            return this.cCollectionList;
        }

        public String getHostCaption() {
            return this.cHostCaption;
        }

        public String getHostElementName() {
            return this.cHostElementName;
        }

        public String getHostID() {
            return this.cHostID;
        }

        public String getHostPortID() {
            return this.cHostPortID;
        }

        public String getMaskingInfoID() {
            return this.cMaskingInfoID;
        }

        public void setMaskingInfoID(String pString) {
            this.cMaskingInfoID = pString;
        }

        public String getClientSettingDataID() {
            return this.cClientSettingDataID;
        }
    }
}

