/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.SimpleCIMDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.DiskProgressLogger;
import org.eclipse.aperi.disk.collection.SubsystemPostCollectionProcess;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.collection.step.CommitStep;
import org.eclipse.aperi.disk.collection.step.FilterPrimordialStep;
import org.eclipse.aperi.disk.collection.step.PersistStorageSettingForVolume;
import org.eclipse.aperi.disk.collection.step.RemoveDBReferencesStep;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.collection.step.StorageExtentCacheStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.discovery.SubSystemDeletion;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public abstract class ProbeGenericSubsystemProcess
extends DiscoverProcess
implements CIMNames,
DiscoveryConstants {
    protected static final String COLLECTNODESFROMCOMPUTERSYSTEM = "collectNodesFromComputerSystem";
    protected static final String COLLECTFCPORTSFROMCOMPUTERSYSTEM = "collectFCPortsFromComputerSystem";
    protected static final String COLLECTVOLUMESFROMCOMPUTERSYSTEM = "collectVolumessFromComputerSystem";
    protected static final String COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES = "collectExtentData_StorageVolume_Names";
    protected static final String COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES_CONCRETE_DEPENDENCY = "collectExtentData_StorageVolume_Names_Concrete_Dependency";
    protected static final String COLLECTFCPORTSFROMNODE = "collectFCPortsFromNode";
    protected static final String COLLECTPOOLSFROMCOMPUTERSYSTEM = "collectPoolsFromComputerSystem";
    protected static final String COLLECTCAPABILITIESFROMPOOLS = "collectCapabilitiesFromPools";
    protected static final String COLLECT_EXTENTS_FROM_POOL = "collectExtentsFromPool";
    protected static final String COLLECT_EXTENT_FOR_DISKDRIVE = "collectExtentForDiskDrive";
    protected static final String COLLECT_EXTENTDATA_DISKDRIVES = "collectExtentData_DiskDrives";
    protected static final String COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM = "collectDiskDrivesFromStorageSubsystem";
    protected static final String COLLECT_DISKDRIVEDATA_PHYSICALPACKAGE = "collectDiskDriveData_PhysicalPackage";
    protected static final String COLLECT_DISKDRIVEDATAL_PHYSICALMEDIA = "collectExtentDataForPool_PhysicalMedia";
    protected static final String COLLECTEXTENTDATAFORPOOL_STORAGEVOLUME = "collectExtentDataForPool_StorageVolume";
    protected static final String COLLECTVOLUMESETTINGS = "collectVolumeSettings";
    protected static final String COLLECTVOLUMESETTINGS_VOLUME = "collectVolumeSettingData_Volume";
    protected static final String COLLECT_VOLUMES_FROM_POOL = "collectVolumesFromPool";
    protected static final String COLLECTCLIENTSETTINGDATAFROMCOMPUTERSYSTEM = "collectClientSettingDataFromComputerSystem";
    protected static final String SUBSYSTEMPOSTCOLLECTIONPROCESS = "SubsystemPostCollectionProcess";
    protected String cProbeProgressVolumeStart = "HWN021731I";
    protected String cProbeProgressVolumeProgress = "HWN021732I";
    protected String cProbeProgressVolumeTotal = "HWN021733I";

    public static void registerSteps(IDiscoverRouterService pRouter) {
        pRouter.addProcess(COLLECTNODESFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Nodes From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComponentCS", (String)"CIM_ComputerSystem", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTFCPORTSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect FCPorts From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_FCPort", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTVOLUMESFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Volumes From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_StorageVolume", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES, (IDiscoverProcess)new AssociatorCIMQuery("Collect Extent Data: StorageVolume (Names)", Query.associatorNames((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageVolume", null, null), "CIM_StorageExtent", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES_CONCRETE_DEPENDENCY, (IDiscoverProcess)new AssociatorCIMQuery("Collect Extent Data: StorageVolume (Names) via Concrete Dependency", Query.associatorNames((String)"CIM_StorageExtent", (String)"CIM_ConcreteDependency", (String)"CIM_StorageVolume", null, null), "CIM_StorageExtent", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTFCPORTSFROMNODE, (IDiscoverProcess)new AssociatorCIMQuery("Collect FCPorts From Node", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_FCPort", null, null), "CIM_ComputerSystemNodes", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTPOOLSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Pools From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_HostedStoragePool", (String)"CIM_StoragePool", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTCAPABILITIESFROMPOOLS, (IDiscoverProcess)new AssociatorCIMQuery("Collect Capabilities From Pools", Query.associators((String)"CIM_StoragePool", (String)"CIM_ElementCapabilities", (String)"CIM_StorageCapabilities", null, null), "CIM_StoragePool", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_VOLUMES_FROM_POOL, (IDiscoverProcess)new AssociatorCIMQuery("Collect Volumes From Pools", Query.associators((String)"CIM_StoragePool", (String)"CIM_AllocatedFromStoragePool", (String)"CIM_StorageVolume", null, null), "CIM_StoragePool", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_EXTENTS_FROM_POOL, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageExtents from Pool", Query.associators((String)"CIM_StoragePool", (String)"CIM_ConcreteComponent", (String)"CIM_StorageExtent", null, null), "CIM_StoragePool", CIMInstance.class.getName(), false));
        Router.getRouter().addProcess(COLLECT_EXTENT_FOR_DISKDRIVE, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageExtents for DiskDrive", Query.associators((String)"CIM_DiskDrive", (String)"CIM_MediaPresent", (String)"CIM_StorageExtent", null, null), "CIM_DiskDrive", CIMInstance.class.getName(), false));
        Router.getRouter().addProcess(COLLECT_EXTENTDATA_DISKDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect ExtentData: DiskDrives", Query.associators((String)"CIM_StorageExtent", (String)"CIM_MediaPresent", (String)"CIM_DiskDrive", null, null), "CIM_StorageExtent", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_DISKDRIVEDATA_PHYSICALPACKAGE, (IDiscoverProcess)new AssociatorCIMQuery("Collect ExtentData: PhysicalPackage", Query.associators((String)"CIM_DiskDrive", (String)"CIM_Realizes", (String)"CIM_PhysicalPackage", null, null), "CIM_DiskDrive", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECT_DISKDRIVEDATAL_PHYSICALMEDIA, (IDiscoverProcess)new AssociatorCIMQuery("Collect ExtentData: PhysicalMedia", Query.associators((String)"CIM_PhysicalPackage", (String)"CIM_PackagedComponent", (String)"CIM_PhysicalMedia", null, null), "CIM_PhysicalPackage", CIMInstance.class.getName(), false));
        Router.getRouter().addProcess(COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect DiskDrives from StorageSubsystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_DiskDrive", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTEXTENTDATAFORPOOL_STORAGEVOLUME, (IDiscoverProcess)new AssociatorCIMQuery("Collect Extent Data for Pool: StorageVolume", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageVolume", null, null), "CIM_StorageExtent", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTVOLUMESETTINGS, (IDiscoverProcess)new SimpleCIMDiscoverProcess("Collect Volume Settings", false, new Query[]{Query.enumerateInstancesQuery((String)"CIM_StorageSetting")}, false));
        pRouter.addProcess(COLLECTVOLUMESETTINGS_VOLUME, (IDiscoverProcess)new AssociatorCIMQuery("Collect Volume COP for Setting", Query.associatorNames((String)"CIM_StorageSetting", (String)"CIM_ElementSettingData", (String)"CIM_StorageVolume", null, null), "CIM_StorageSetting", CIMInstance.class.getName(), false));
        pRouter.addProcess(COLLECTCLIENTSETTINGDATAFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Client Setting Data From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ElementSettingData", (String)"CIM_StorageClientSettingData", null, null), "CIM_ComputerSystem", CIMInstance.class.getName(), false));
        pRouter.addProcess(SUBSYSTEMPOSTCOLLECTIONPROCESS, (IDiscoverProcess)new SubsystemPostCollectionProcess());
    }

    public ProbeGenericSubsystemProcess(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CapabilityData.class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    public IStep getStepCollectPoolsFromComputerSystem(DiskCIMProcessor pProcessor, CapabilityData pCapabData, String pLogSystemName, LogTraceHelper pLTH) {
        SimpleStep mCollectPoolsExtentsDiskDrives = new SimpleStep();
        COPCacheStep mCacheDiskDrive = null;
        IStep collectDiskDriveData = null;
        IStep collectDiskDrivesFromExtent = null;
        if (pCapabData.getDiskData() == 1) {
            mCacheDiskDrive = new COPCacheStep("CIM_DiskDrive", pProcessor, false);
            DiskProgressLogger mDiskProgressLogger = new DiskProgressLogger(pLTH, pLogSystemName, "HWN021734I", "HWN021735I", "HWN021736I", null);
            mDiskProgressLogger.enableHierarchicalMode();
            mCollectPoolsExtentsDiskDrives.setProgressLogger((IProgressLogger)mDiskProgressLogger);
            mCacheDiskDrive.setProgressLogger((IProgressLogger)new ProgressLogger.InnerProgressLogger((ProgressLogger)mDiskProgressLogger));
            collectDiskDriveData = this.getStepCollectDiskDriveData(pProcessor, mCacheDiskDrive);
            collectDiskDrivesFromExtent = this.getStepCollectDiskDriveFromExtent(pProcessor, collectDiskDriveData, pLTH);
        }
        IStep collectExtentData = this.getStepCollectExtentData(pProcessor, pCapabData, collectDiskDrivesFromExtent, pLTH);
        DiscoverStep mCollectPoolsFromComputerSystem = new DiscoverStep(COLLECTPOOLSFROMCOMPUTERSYSTEM, "CIM_StoragePool", (CIMProcessor)pProcessor, pLTH);
        DiscoverStep mCollectCapabilitiesFromPools = new DiscoverStep(COLLECTCAPABILITIESFROMPOOLS, null, (CIMProcessor)pProcessor, pLTH);
        RemoveDBReferencesStep removePoolRef = new RemoveDBReferencesStep(new String[]{"CIM_StoragePool"}, pProcessor);
        CommitStep mCS = new CommitStep(pProcessor);
        mCollectPoolsExtentsDiskDrives.addNextStep((IStep)mCollectPoolsFromComputerSystem);
        mCollectPoolsFromComputerSystem.addNextStep((IStep)mCollectCapabilitiesFromPools);
        DiscoverStep mCollectVolumesFromPool = (DiscoverStep)this.getStepCollectVolumesFromPool(pProcessor, pLTH);
        mCollectPoolsFromComputerSystem.addNextStep((IStep)mCollectVolumesFromPool);
        mCollectPoolsFromComputerSystem.addNextStep((IStep)mCS);
        if (pCapabData.getExtentData() == 1) {
            mCollectPoolsFromComputerSystem.addNextStep(this.getStepCollectExtentsFromPool(pProcessor, collectExtentData, pLTH));
            mCollectPoolsExtentsDiskDrives.addNextStep(this.getStepCollectVolume2ExtentFromPrimordialPool(pProcessor, pLTH));
        }
        if (pCapabData.getDiskData() == 1) {
            mCollectPoolsExtentsDiskDrives.addNextStep(this.getStepCollectDiskDriveFromStorageSubsystem(pProcessor, mCacheDiskDrive, collectExtentData, pLTH));
        }
        mCollectPoolsFromComputerSystem.addNextStep((IStep)removePoolRef);
        mCollectPoolsFromComputerSystem.addNextStep((IStep)mCS);
        DiskProgressLogger mVolumeLogger = new DiskProgressLogger(pLTH, pLogSystemName, this.cProbeProgressVolumeStart, this.cProbeProgressVolumeProgress, this.cProbeProgressVolumeTotal, null);
        mVolumeLogger.enableHierarchicalMode();
        mCollectPoolsFromComputerSystem.setProgressLogger((IProgressLogger)mVolumeLogger);
        mCollectVolumesFromPool.setProgressLogger((IProgressLogger)new ProgressLogger.InnerProgressLogger((ProgressLogger)mVolumeLogger));
        return mCollectPoolsExtentsDiskDrives;
    }

    public IStep getStepCollectVolumeSettings(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        DiscoverStep collectVolumeSettings = new DiscoverStep(COLLECTVOLUMESETTINGS, "CIM_StorageSetting", null, pLTH);
        DiscoverStep collectVolumeSettingsForVolume = new DiscoverStep(COLLECTVOLUMESETTINGS_VOLUME, "CIM_StorageVolume", null, pLTH);
        PersistStorageSettingForVolume persistVolumeSettings = new PersistStorageSettingForVolume(pProcessor);
        CommitStep mCS = new CommitStep(pProcessor);
        collectVolumeSettings.addNextStep((IStep)collectVolumeSettingsForVolume);
        collectVolumeSettingsForVolume.addNextStep((IStep)persistVolumeSettings);
        collectVolumeSettings.addNextStep((IStep)mCS);
        return collectVolumeSettings;
    }

    public IStep getStepCollectVolumesFromPool(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        DiscoverStep collectVolumeFromPool = new DiscoverStep(COLLECT_VOLUMES_FROM_POOL, "CIM_StorageVolume", (CIMProcessor)pProcessor, pLTH);
        RemoveDBReferencesStep removeVolumeDBRef = new RemoveDBReferencesStep(new String[]{"CIM_StorageVolume"}, pProcessor);
        collectVolumeFromPool.addNextStep((IStep)removeVolumeDBRef);
        return collectVolumeFromPool;
    }

    public IStep getStepCollectExtentsFromPool(DiskCIMProcessor pProcessor, IStep pCollectExtentData, LogTraceHelper pLTH) {
        DiscoverStep collectExtentsFromPool = new DiscoverStep(COLLECT_EXTENTS_FROM_POOL, "CIM_StorageExtent", null, pLTH);
        RemoveDBReferencesStep removeExtentDBRef = new RemoveDBReferencesStep(new String[]{"CIM_StorageExtent", "CIM_StorageVolume"}, pProcessor);
        collectExtentsFromPool.addNextStep(pCollectExtentData);
        collectExtentsFromPool.addNextStep((IStep)removeExtentDBRef);
        return collectExtentsFromPool;
    }

    public IStep getStepCollectExtentData(DiskCIMProcessor pProcessor, CapabilityData pCapabData, IStep pCollectDiskDriveFromExtent, LogTraceHelper pLTH) {
        StorageExtentCacheStep cacheExtents = new StorageExtentCacheStep("CIM_StorageExtent", pProcessor, true);
        CommitStep mCS = new CommitStep(pProcessor);
        if (pCapabData.getDiskData() == 1) {
            cacheExtents.addNextStep(pCollectDiskDriveFromExtent);
        }
        cacheExtents.addCollectVolumesStep(this.getStepCollectVolumeCOPFromExtent(pProcessor, pLTH));
        cacheExtents.addNextStep((IStep)mCS);
        return cacheExtents;
    }

    public IStep getStepCollectDiskDriveFromExtent(DiskCIMProcessor pProcessor, IStep pCollectDiskDriveData, LogTraceHelper pLTH) {
        DiscoverStep collectExtentData_DiskDrive = new DiscoverStep(COLLECT_EXTENTDATA_DISKDRIVES, "CIM_DiskDrive", (CIMProcessor)pProcessor, pLTH);
        RemoveDBReferencesStep removeDBRefs = new RemoveDBReferencesStep(new String[]{"CIM_DiskDrive"}, pProcessor);
        collectExtentData_DiskDrive.addNextStep(pCollectDiskDriveData);
        collectExtentData_DiskDrive.addNextStep((IStep)removeDBRefs);
        return collectExtentData_DiskDrive;
    }

    public IStep getStepCollectDiskDriveFromStorageSubsystem(DiskCIMProcessor pProcessor, COPCacheStep pDiskDriveCOPCache, IStep pCollectExtentData, LogTraceHelper pLTH) {
        SimpleStep mCollectDiskDrivesWithoutPools = new SimpleStep();
        DiscoverStep collectDiskDriveFromStorageSubsystem = new DiscoverStep(COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM, "CIM_DiskDrive", null, pLTH);
        COPCacheStep mDiskDriveWithExtentsCOPCacheStep = new COPCacheStep(pDiskDriveCOPCache, false);
        mDiskDriveWithExtentsCOPCacheStep.setCacheReadOnly(true);
        collectDiskDriveFromStorageSubsystem.addNextStep((IStep)mDiskDriveWithExtentsCOPCacheStep);
        DiscoverStep collectStorageExtentForDiskDrive = new DiscoverStep(COLLECT_EXTENT_FOR_DISKDRIVE, "CIM_StorageExtent", null, pLTH);
        mDiskDriveWithExtentsCOPCacheStep.addNextStep((IStep)collectStorageExtentForDiskDrive);
        collectStorageExtentForDiskDrive.addNextStep(pCollectExtentData);
        RemoveDBReferencesStep removeExtentDBRef = new RemoveDBReferencesStep(new String[]{"CIM_StorageExtent", "CIM_StorageVolume"}, pProcessor);
        mDiskDriveWithExtentsCOPCacheStep.addNextStep(removeExtentDBRef);
        DiscoverStep collectDiskDriveNoExtentsFromStorageSubsystem = new DiscoverStep(COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM, "CIM_DiskDrive", null, pLTH);
        COPCacheStep mDiskDriveNoExtentsCOPCacheStep = new COPCacheStep(pDiskDriveCOPCache, true);
        IStep mCollectDiskDriveData = this.getStepCollectDiskDriveData(pProcessor, pDiskDriveCOPCache);
        CommitStep mCS = new CommitStep(pProcessor);
        collectDiskDriveNoExtentsFromStorageSubsystem.addNextStep((IStep)mDiskDriveNoExtentsCOPCacheStep);
        mDiskDriveNoExtentsCOPCacheStep.addNextStep(mCollectDiskDriveData);
        mCollectDiskDrivesWithoutPools.addNextStep((IStep)collectDiskDriveFromStorageSubsystem);
        mCollectDiskDrivesWithoutPools.addNextStep((IStep)collectDiskDriveNoExtentsFromStorageSubsystem);
        mCollectDiskDrivesWithoutPools.addNextStep((IStep)mCS);
        return mCollectDiskDrivesWithoutPools;
    }

    public IStep getStepCollectDiskDriveData(DiskCIMProcessor pProcessor, COPCacheStep pDiskDriveCOPCache) {
        COPCacheStep cacheDiskDrive = new COPCacheStep(pDiskDriveCOPCache);
        DiscoverStep collectDiskDriveData_PhysicalPackage = new DiscoverStep(COLLECT_DISKDRIVEDATA_PHYSICALPACKAGE, "CIM_PhysicalPackage", (CIMProcessor)pProcessor);
        COPCacheStep cachePhysicalPackage = new COPCacheStep("CIM_PhysicalPackage", pProcessor, true);
        DiscoverStep collectDiskDriveData_PhysicalMedia = new DiscoverStep(COLLECT_DISKDRIVEDATAL_PHYSICALMEDIA, null, (CIMProcessor)pProcessor);
        RemoveDBReferencesStep removeDBRefs = new RemoveDBReferencesStep(new String[]{"CIM_PhysicalPackage", "CIM_PhysicalMedia"}, pProcessor);
        cacheDiskDrive.addNextStep((IStep)collectDiskDriveData_PhysicalPackage);
        collectDiskDriveData_PhysicalPackage.addNextStep((IStep)collectDiskDriveData_PhysicalMedia);
        cacheDiskDrive.addNextStep(removeDBRefs);
        return cacheDiskDrive;
    }

    public IStep getStepCollectVolume2ExtentFromPrimordialPool(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        DiscoverStep mCollectPoolsFromComputerSystem = new DiscoverStep(COLLECTPOOLSFROMCOMPUTERSYSTEM, "CIM_StoragePool", null, pLTH);
        FilterPrimordialStep mFilterPrimordialPools = new FilterPrimordialStep("CIM_StoragePool");
        DiscoverStep collectExtentsFromPool = new DiscoverStep(COLLECT_EXTENTS_FROM_POOL, "CIM_StorageExtent", (CIMProcessor)pProcessor, pLTH);
        RemoveDBReferencesStep removeExtentDBRef = new RemoveDBReferencesStep(new String[]{"CIM_StorageExtent", "CIM_StorageVolume"}, pProcessor);
        IStep collectExtent_StorageVolumeNames_ConcreteDependency = this.getStepCollectVolumeCOPFromExtent(pProcessor, pLTH);
        mCollectPoolsFromComputerSystem.addNextStep((IStep)mFilterPrimordialPools);
        mFilterPrimordialPools.addNextPrimordialStep((IStep)collectExtentsFromPool);
        mFilterPrimordialPools.addNextPrimordialStep(removeExtentDBRef);
        collectExtentsFromPool.addNextStep(collectExtent_StorageVolumeNames_ConcreteDependency);
        return mCollectPoolsFromComputerSystem;
    }

    public IStep getStepCollectVolumeCOPFromExtent(DiskCIMProcessor pProcessor, LogTraceHelper pLTH) {
        DiscoverStep collectExtentData_StorageVolumeNames = new DiscoverStep(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES, "CIM_StorageVolume", (CIMProcessor)pProcessor, pLTH);
        DiscoverStep collectExtent_StorageVolumeNames_ConcreteDependency = new DiscoverStep(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES_CONCRETE_DEPENDENCY, "CIM_StorageVolume", (CIMProcessor)pProcessor, pLTH);
        RemoveDBReferencesStep removeVolumeDBRef = new RemoveDBReferencesStep(new String[]{"CIM_StorageVolume"}, pProcessor);
        SimpleStep collectVolumesForExtent = new SimpleStep();
        collectVolumesForExtent.addNextStep((IStep)collectExtentData_StorageVolumeNames);
        collectVolumesForExtent.addNextStep((IStep)collectExtent_StorageVolumeNames_ConcreteDependency);
        collectVolumesForExtent.addNextStep((IStep)removeVolumeDBRef);
        return collectVolumesForExtent;
    }

    public String getScannerId(Map pParameters) throws ParameterException {
        String prefix = "PS1";
        String[] mCIMOM = (String[])pParameters.get("CIMOM");
        if (mCIMOM == null || mCIMOM.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String mCIMOMServiceURL = mCIMOM[0];
        String mSubsystemID = (String)pParameters.get("DEVICEID");
        if (mSubsystemID == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        String mScannerId = prefix + ":" + mCIMOMServiceURL + "+" + mSubsystemID;
        return mScannerId;
    }

    public int getAuthoritativeReferenceType(Map pParameters) throws ParameterException {
        return 1;
    }

    public int getAuthoritativeReferenceId(Map pParameters) throws ParameterException {
        String mStorageSubsystemDBId = (String)pParameters.get("DEVICEID");
        if (mStorageSubsystemDBId == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        return Integer.parseInt(mStorageSubsystemDBId);
    }

    public static int setCollectionStatus(String pSubsystemID, int pCollectionStatus, boolean pUpdateBasicStatus, boolean pUpdateLUNMapMaskStatus) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"ProbeGenericSubsystemProcess", (String)"setCollectionStatus", (Object[])new Object[]{pSubsystemID, new Integer(pCollectionStatus), new Boolean(pUpdateBasicStatus), new Boolean(pUpdateLUNMapMaskStatus)});
        String bSubsystemID = pSubsystemID;
        int mNewCollectionStatus = -1;
        Timestamp mLastProbeTime = null;
        DBConnection mDBConn = null;
        StorageSubsystem mSubsys = null;
        try {
            mDBConn = ServiceUtils.getConnection();
            mSubsys = ExternalKeyManager.getStorageSubsystem((String)bSubsystemID, (DBConnection)mDBConn);
            mNewCollectionStatus = mSubsys.getCollectionStatus();
            String mNewProbeStatus = mSubsys.getProbeStatus();
            if (pUpdateBasicStatus) {
                mNewCollectionStatus &= 0xFFFFFFF8;
                int bNewBasicStatus = pCollectionStatus & 7;
                mNewCollectionStatus |= bNewBasicStatus;
                switch (bNewBasicStatus) {
                    case 0: {
                        mNewProbeStatus = "0";
                        mLastProbeTime = new Timestamp(System.currentTimeMillis());
                        break;
                    }
                    case 1: {
                        mNewProbeStatus = "1";
                        mLastProbeTime = new Timestamp(System.currentTimeMillis());
                        break;
                    }
                    case 2: {
                        mNewProbeStatus = "0";
                        break;
                    }
                    case 3: {
                        mNewProbeStatus = "3";
                    }
                }
            }
            if (pUpdateLUNMapMaskStatus) {
                mNewCollectionStatus &= 0xFFFFFFC7;
                int bNewLUNMapMaskStatus = pCollectionStatus & 0x38;
                mNewCollectionStatus |= bNewLUNMapMaskStatus;
                switch (bNewLUNMapMaskStatus) {
                    case 0: {
                        mNewProbeStatus = "0";
                        mLastProbeTime = new Timestamp(System.currentTimeMillis());
                        break;
                    }
                    case 8: {
                        mNewProbeStatus = "1";
                        mLastProbeTime = new Timestamp(System.currentTimeMillis());
                        break;
                    }
                    case 16: {
                        mNewProbeStatus = "0";
                        break;
                    }
                    case 24: {
                        mNewProbeStatus = "3";
                    }
                }
            }
            if (mNewCollectionStatus == 0) {
                mNewProbeStatus = "2";
            }
            StorageSubsystem mSSUpdate = new StorageSubsystem();
            mSSUpdate.setName(mSubsys.getName());
            mSSUpdate.setNameFormat(mSubsys.getNameFormat());
            mSSUpdate.setCollectionStatus(mNewCollectionStatus);
            mSSUpdate.setProbeStatus(mNewProbeStatus);
            if (mLastProbeTime != null) {
                mSSUpdate.setLastProbeTime(mLastProbeTime);
            }
            mSSUpdate.update(mDBConn);
            mDBConn.commit();
        }
        catch (SQLException pEx) {
            mDBConn.rollback();
            throw pEx;
        }
        catch (Throwable bEx) {
            mDBConn.rollback();
            throw new Exception(bEx);
        }
        finally {
            try {
                mDBConn.close();
            }
            catch (Exception bEx) {}
            mLTH.exit((Object)new Integer(mNewCollectionStatus));
        }
        return mNewCollectionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String checkAndHandleMigratedSubsystem(String pSubsystemID) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"checkAndHandleMigratedSubsystem", (Object[])new Object[]{pSubsystemID});
        String bSubsystemID = pSubsystemID;
        int mCollectionStatus = -1;
        boolean mMigrated = false;
        DBConnection mDBConn = null;
        StorageSubsystem mSubsys = null;
        try {
            SubSystemDeletion bSubSysDelete;
            Result bCleanupResult;
            mDBConn = ServiceUtils.getConnection();
            mSubsys = ExternalKeyManager.getStorageSubsystem((String)bSubsystemID, (DBConnection)mDBConn);
            mDBConn.commit();
            mCollectionStatus = mSubsys.getCollectionStatus();
            boolean bl = mMigrated = (mCollectionStatus & 0x80) == 128;
            if (mMigrated && (bCleanupResult = (bSubSysDelete = new SubSystemDeletion()).cleanupMigratedStorageSubsystem(pSubsystemID)).getMessage().equals("HWN021672E")) {
                mLTH.traceError("HWN021672E", (Throwable)DiskMessageHelper.getServerException((String)"HWN021672E", (Object)pSubsystemID, (LogTraceHelper)mLTH));
            }
        }
        catch (Throwable throwable) {
            mDBConn.close();
            mLTH.exit((Object)(mMigrated ? "1" : "0"));
            throw throwable;
        }
        mDBConn.close();
        mLTH.exit((Object)(mMigrated ? "1" : "0"));
        return mMigrated ? "1" : "0";
    }
}

