/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;

public class SvcPostCollectionProcess
extends DiscoverProcess {
    public SvcPostCollectionProcess() {
        super("SVC Post Collection Process", false, new String[]{"DEVICEID"}, new String[]{Integer.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SvcPostCollectionProcess", null);
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request pRequest, Map pParameters) throws ParameterException, Exception {
        Result mReturn;
        block10: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
            mReturn = new Result(1);
            try {
                DBConnection mConnection = ServiceUtils.getConnection();
                try {
                    String mSSID = (String)pParameters.get("SUBSYSTEMID");
                    StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mConnection);
                    if (mStorageSubsystem.getType() != null) {
                        mReturn = this.processSVC(mStorageSubsystem, mConnection, mLTH);
                        break block10;
                    }
                    throw new ParameterException("Subsystem is null.");
                }
                finally {
                    if (mConnection != null) {
                        mConnection.close();
                    }
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
            }
            finally {
                mLTH.exit((Object)mReturn);
            }
        }
        return mReturn;
    }

    private Result processSVC(StorageSubsystem pSubsystem, DBConnection pConnection, LogTraceHelper pLTH) {
        try {
            int mDeviceID = pSubsystem.getSubsystemId();
            String mSQL = "SELECT SUM(TOTAL_MANAGED_SPACE), SUM(REMAINING_MANAGED_SPACE) FROM " + StoragePool.getTablename() + " WHERE (" + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "PRIMORDIAL" + " = 0)";
            pLTH.traceInfo("Sending DB2 complex query for VG_Capacity&VG_FreeSpace: " + mSQL);
            DBResultSet mDBR = ComplexQuery.sqlQuery((DBConnection)pConnection, (String)mSQL, null);
            double mTotalCapacity = 0.0;
            double mRemainingCapacity = 0.0;
            while (mDBR.next()) {
                mTotalCapacity = mDBR.getDouble(1);
                mRemainingCapacity = mDBR.getDouble(2);
                pLTH.traceInfo("Result: " + Double.toString(mTotalCapacity) + "/" + Double.toString(mRemainingCapacity));
            }
            mDBR.close();
            StorageSubsystem mOnlyUpdatedColumns = new StorageSubsystem();
            mOnlyUpdatedColumns.setName(pSubsystem.getName());
            mOnlyUpdatedColumns.setNameFormat(pSubsystem.getNameFormat());
            mOnlyUpdatedColumns.setVgCapacity((long)mTotalCapacity);
            mOnlyUpdatedColumns.setVgFreespace((long)mRemainingCapacity);
            mOnlyUpdatedColumns.update(pConnection);
            pConnection.commit();
            return new Result(0);
        }
        catch (Exception mEx) {
            try {
                pConnection.rollback();
            }
            catch (SQLException bInnerEx) {
                // empty catch block
            }
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)pLTH);
        }
    }
}

