/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.NullProgressLogger;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.step.PersistInstanceStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class COPCacheStep
extends PersistInstanceStep
implements IStep,
CIMNames {
    protected Map cCOPCache;
    protected boolean cPersistInstance;
    protected boolean cCacheReadOnly = false;
    protected IProgressLogger cProgressLogger = NullProgressLogger.NULL_LOGGER;

    public COPCacheStep(String pInstanceName, DiskCIMProcessor pDiskCIMProcessor, boolean pPersistInstance) {
        super(pInstanceName, pDiskCIMProcessor);
        this.cCOPCache = new HashMap();
        this.cPersistInstance = pPersistInstance;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"COPCacheStep", (Object[])new Object[]{pInstanceName, pDiskCIMProcessor, new Boolean(pPersistInstance)});
        mLTH.exit(null);
    }

    public COPCacheStep(COPCacheStep pCOPCacheStep) {
        super(pCOPCacheStep.cInstanceName, pCOPCacheStep.cDiskCIMProcessor);
        this.cCOPCache = pCOPCacheStep.cCOPCache;
        this.cPersistInstance = pCOPCacheStep.cPersistInstance;
        this.cProgressLogger = pCOPCacheStep.cProgressLogger;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"COPCacheStep", (Object[])new Object[]{pCOPCacheStep});
        mLTH.exit(null);
    }

    public COPCacheStep(COPCacheStep pCOPCacheStep, boolean pPersistInstance) {
        super(pCOPCacheStep.cInstanceName, pCOPCacheStep.cDiskCIMProcessor);
        this.cCOPCache = pCOPCacheStep.cCOPCache;
        this.cPersistInstance = pPersistInstance;
        this.cProgressLogger = pCOPCacheStep.cProgressLogger;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"COPCacheStep", (Object[])new Object[]{pCOPCacheStep, new Boolean(pPersistInstance)});
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(String pDiscoverRequest, Map pParameters) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pDiscoverRequest});
        this.cProgressLogger.entry();
        Result mReturn = new Result(0);
        CIMInstance mCIMInstance = (CIMInstance)pParameters.get(this.cInstanceName);
        CIMObjectPath mObjPath = mCIMInstance.getObjectPath();
        boolean mStatus = true;
        try {
            Hashtable mCachedDBRefs = (Hashtable)this.cCOPCache.get(mObjPath);
            if (mCachedDBRefs != null) {
                this.handleCacheHit(pDiscoverRequest, mCIMInstance, mCachedDBRefs, pParameters, mLTH);
            } else {
                if (this.cPersistInstance) {
                    mLTH.traceInfo("persist " + this.cInstanceName + " with COP " + mObjPath.toString());
                    mReturn = this.persistInstance(mCIMInstance, this.cInstanceName, pParameters, mLTH);
                }
                if (mReturn.getRc() == 0) {
                    boolean bResult;
                    if (!this.cCacheReadOnly) {
                        Hashtable bDBRefs = (Hashtable)this.cDiskCIMProcessor.getDBReferences().get(this.cInstanceName);
                        if (bDBRefs == null) {
                            bDBRefs = new Hashtable();
                        }
                        this.cCOPCache.put(mObjPath, bDBRefs);
                        this.cProgressLogger.elementDiscovered();
                    }
                    mReturn.setRc((bResult = this.processNext(pDiscoverRequest, pParameters)) ? 0 : 1);
                }
            }
            boolean bl = mStatus = mReturn.getRc() == 0;
            if (mStatus) {
                this.cProgressLogger.complete();
            }
        }
        finally {
            this.cProgressLogger.exit();
            mLTH.exit((Object)mReturn);
        }
        return mStatus;
    }

    protected boolean handleCacheHit(String pDiscoverRequest, CIMInstance mCIMInstance, Hashtable mCachedDBRefs, Map mProcessProperties, LogTraceHelper mLTH) throws Exception {
        mLTH.traceInfo("Cache hit for " + this.cInstanceName + " with COP " + mCIMInstance.getObjectPath().toString());
        this.cDiskCIMProcessor.getDBReferences().put(this.cInstanceName, mCachedDBRefs);
        return true;
    }

    public void setCacheReadOnly(boolean pCacheReadOnly) {
        this.cCacheReadOnly = pCacheReadOnly;
    }

    public void setProgressLogger(IProgressLogger pProgressLogger) {
        this.cProgressLogger = pProgressLogger != null ? pProgressLogger : NullProgressLogger.NULL_LOGGER;
    }
}

