/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.MappingMaskingProcessor;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class SVCProtocolControllerCollectionStep
extends SimpleStep {
    protected String cMapName = null;
    protected IStep cSingleStep = null;
    private MappingMaskingProcessor cProcessor = null;

    public SVCProtocolControllerCollectionStep(String pMapName, IStep pSingleStep, DiskCIMProcessor pProcessor) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SVCProtocolControllerCollectionStep", (Object[])new Object[]{pMapName});
        this.cMapName = pMapName;
        this.cSingleStep = pSingleStep;
        this.cProcessor = (MappingMaskingProcessor)pProcessor;
        mLTH.exit(null);
    }

    public boolean process(String pDiscoverRequest, Map pParameters) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pDiscoverRequest});
        boolean mReturn = true;
        pParameters.put(this.cMapName, new HashMap());
        this.cSingleStep.process(pDiscoverRequest, pParameters);
        HashMap mMap = (HashMap)pParameters.get(this.cMapName);
        if (mMap != null) {
            Iterator mIt = mMap.keySet().iterator();
            mLTH.traceInfo("Number of COPs in " + this.cMapName + ": " + mMap.size());
            while (mIt.hasNext()) {
                CIMObjectPath mControllerCOP = (CIMObjectPath)mIt.next();
                CIMInstance mControllerInst = new CIMInstance(mControllerCOP);
                pParameters.put("CIM_SCSIProtocolController", mControllerInst);
                mLTH.traceInfo("Adding Protocoll Controller to MaskingInfo and DataPath");
                Hashtable mControllerProps = DiskCIMProcessor.convertPropertiesToHashtable((Vector)mControllerInst.getAllProperties(), new Hashtable());
                mControllerProps.put("originalcimclassname", "CIM_SCSIProtocolController");
                this.cProcessor.addProtocolControllerToDatapathAndMaskingInfoForSVC(null, mControllerProps);
                mLTH.traceInfo("Passing COP " + mControllerCOP + " with its CIMInstance to next process steps as " + "CIM_SCSIProtocolController");
                boolean mStatus = this.processNext(pDiscoverRequest, pParameters);
                pParameters.remove("CIM_SCSIProtocolController");
                mLTH.traceInfo("Removing COP " + mControllerCOP + " as " + "CIM_SCSIProtocolController");
            }
        }
        mLTH.exit((Object)new Boolean(mReturn));
        return mReturn;
    }
}

