/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;

public class SVCProtocolControllerPreparationStep
extends SimpleStep {
    protected String cInstanceName = null;
    protected String cMapName = null;

    public SVCProtocolControllerPreparationStep(String pInstanceName, String pMapName) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SVCProtocolControllerPreparationStep", (Object[])new Object[]{pInstanceName, pMapName});
        this.cInstanceName = pInstanceName;
        this.cMapName = pMapName;
        mLTH.exit(null);
    }

    public boolean process(String pDiscoverRequest, Map pParameters) throws Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pDiscoverRequest});
        String DEFAULT_SVC_NAMESPACE = "root/ibm";
        boolean mReturn = true;
        HashMap mMap = null;
        CIMInstance mCIMInstance = (CIMInstance)pParameters.get(this.cInstanceName);
        if (mCIMInstance != null) {
            mLTH.traceInfo("Found CIMInstance as step parameter " + this.cInstanceName);
            mMap = (HashMap)pParameters.get(this.cMapName);
            if (mMap != null) {
                String mViewCOP = mCIMInstance.getObjectPath().toString();
                Hashtable mProperties = CIMProcessor.convertPropertiesToHashtable((Vector)mCIMInstance.getAllProperties(), new Hashtable());
                String mSystemName = (String)mProperties.get("SystemName".toLowerCase());
                String mVolumeName = (String)mProperties.get("VolumeName".toLowerCase());
                String mVolumeOID = (String)mProperties.get("VolumeOID".toLowerCase());
                String mVolumeUniqueID = (String)mProperties.get("VolumeUniqueID".toLowerCase());
                mLTH.traceInfo("Getting volume info for " + mViewCOP.toString());
                String[] mVolumeInfo = this.getVolumeInfoFromDatabase(mVolumeName, mVolumeUniqueID);
                String mLUNID = (String)mProperties.get("CollectionScsiID".toLowerCase());
                String mSVID = mVolumeInfo[0];
                String mDeviceID = mVolumeInfo[1] + "-" + mVolumeOID;
                CIMObjectPath newCOP = new CIMObjectPath();
                newCOP.addKey("CreationClassName", new CIMValue((Object)"IBMTSSVC_Controller", CIMDataType.getPredefinedType((int)8)));
                newCOP.addKey("DeviceID", new CIMValue((Object)mDeviceID, CIMDataType.getPredefinedType((int)8)));
                newCOP.addKey("SystemCreationClassName", new CIMValue((Object)"IBMTSSVC", CIMDataType.getPredefinedType((int)8)));
                newCOP.addKey("SystemName", new CIMValue((Object)mSystemName, CIMDataType.getPredefinedType((int)8)));
                newCOP.setNameSpace(new CIMNameSpace(((String[])pParameters.get("CIMOM"))[0], "root/ibm"));
                newCOP.setObjectName("IBMTSSVC_Controller");
                Vector<String[]> volumeInfoChain = (Vector<String[]>)mMap.remove(newCOP);
                if (volumeInfoChain == null) {
                    mLTH.traceInfo("Creating new VolumeInfo list for new controller COP: " + newCOP.toString());
                    volumeInfoChain = new Vector<String[]>();
                } else {
                    mLTH.traceInfo("Reusing existing VolumeInfo list for existing controller COP: " + newCOP.toString());
                }
                volumeInfoChain.add(new String[]{mSVID, mLUNID});
                mMap.put(newCOP, volumeInfoChain);
                mLTH.traceInfo("Adding " + volumeInfoChain.size() + ". VolumeInfo [" + mSVID + "," + mLUNID + "] for " + newCOP.toString() + " to map " + this.cMapName);
                pParameters.put(this.cMapName, mMap);
            } else {
                mLTH.traceWarning("Did not find map as step parameter " + this.cMapName);
                mReturn = false;
            }
        } else {
            mLTH.traceWarning("Did not find CIMInstance as step parameter " + this.cInstanceName);
            mReturn = false;
        }
        if (mReturn) {
            mLTH.traceInfo("Processing next");
            mReturn = this.processNext(pDiscoverRequest, pParameters);
            mLTH.traceInfo("Done processing next");
        }
        mLTH.exit((Object)new Boolean(mReturn));
        return mReturn;
    }

    private String[] getVolumeInfoFromDatabase(String volumeName, String volumeUniqueID) {
        String[] mRes = new String[2];
        DBConnection mCon = ServiceUtils.getConnection();
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getVolumeInfoFromDatabase", (Object[])new Object[]{volumeName, volumeUniqueID});
        if (volumeUniqueID != null && volumeUniqueID.length() == 32) {
            volumeUniqueID = volumeUniqueID.substring(10, 16) + "/" + volumeUniqueID.substring(26, 32);
        }
        try {
            String mSchema = mCon.getSchema();
            String mTRSVid = "TRSV";
            String mTRIGid = "TRIG";
            String mDot = ".";
            String mQuery = "select " + mTRSVid + mDot + "SVID" + "," + mTRIGid + mDot + "GROUP_ID" + " from " + mSchema + "." + TResStorageVolumeTable.getTablename() + " " + mTRSVid + "," + mSchema + "." + TResIoGroupTable.getTablename() + " " + mTRIGid + " where " + mTRSVid + mDot + "UNIQUE_ID" + " = '" + volumeUniqueID + "' and " + mTRSVid + mDot + "ELEMENT_NAME" + " = '" + volumeName + "' and " + mTRIGid + mDot + "IO_GROUP_ID" + " = " + mTRSVid + mDot + "IO_GROUP_ID";
            mLTH.traceInfo("Sending DB2 complex query for ExtentCOP to ExtentID: " + mQuery);
            DBResultSet mDBR = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mQuery, null);
            while (mDBR.next()) {
                mRes[0] = mDBR.getString(1);
                mRes[1] = mDBR.getString(2);
            }
            mDBR.close();
            mCon.commit();
        }
        catch (SQLException mEx) {
            try {
                mCon.rollback();
            }
            catch (SQLException bInnerEx) {
                // empty catch block
            }
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            mLTH.exit((Object)mRes);
        }
        return mRes;
    }
}

