/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.HardwareIDMangement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.IDGenerator;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class HardwareIDManagementESS
extends HardwareIDMangement {
    public HardwareIDManagementESS(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createStorageHardwareIDs(ArrayList pWWPNs, String[] pHardwareIDNames, CIMObjectPath pStorageClientSettingDataCOP) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createStorageHardwareIDs", (Object[])new Object[]{pWWPNs, pHardwareIDNames, pStorageClientSettingDataCOP});
        ArrayList mStorageHardwareIDs = new ArrayList();
        try {
            if (pHardwareIDNames == null || pHardwareIDNames.length == 0) {
                pHardwareIDNames = IDGenerator.generateArrayOfUniqueNumericStrings((int)pWWPNs.size());
            }
            for (int i = 0; i < pHardwareIDNames.length; ++i) {
                if (pHardwareIDNames[i].length() <= 10) continue;
                int mPoint = pHardwareIDNames[i].indexOf(".");
                pHardwareIDNames[i] = mPoint != -1 && mPoint < 10 ? pHardwareIDNames[i].substring(0, mPoint) : pHardwareIDNames[i].substring(0, 10);
            }
            mStorageHardwareIDs = super.createStorageHardwareIDs(pWWPNs, pHardwareIDNames, pStorageClientSettingDataCOP);
        }
        catch (Throwable throwable) {
            mLTH.exit(mStorageHardwareIDs);
            throw throwable;
        }
        mLTH.exit((Object)mStorageHardwareIDs);
        return mStorageHardwareIDs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMInstance retrieveCIMInstance(CIMObjectPath pCOP) throws DiskManagerTimeoutException, CIMException {
        CIMInstance cIMInstance;
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveCIMInstance", (Object[])new Object[]{pCOP});
        CIMInstance mCIMInstance = null;
        {
            int mRetries = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.ESSGetInstanceRetries", (int)5);
            int mSleepTime = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.ESSGetInstanceSleep", (int)1000);
            int i = 0;
            while (true) {
                if (i >= mRetries) {
                    return mCIMInstance;
                }
                try {
                    cIMInstance = mCIMInstance = this.cCimClient.getInstance(pCOP, false, true, true, mLTH);
                }
                catch (CIMException e) {
                    if (i >= mRetries) {
                        ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"getInstance", (Object)this.cCimClient, (Object)((Object)e), (Throwable)e, (LogTraceHelper)mLTH);
                        mLTH.traceError("getInstance for " + pCOP + " failed", (Throwable)bEx);
                        throw bEx;
                    }
                    mLTH.traceHigh("getInstance for " + pCOP + " returned CIM_ERR_NOT_FOUND");
                    Thread.sleep(mSleepTime);
                    ++i;
                    continue;
                }
                break;
            }
        }
        mLTH.exit((Object)mCIMInstance);
        return cIMInstance;
    }
}

