/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.collection.SubProbeSVCExtent;
import org.eclipse.aperi.disk.collection.SubProbeVolume;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ModifyStoragePoolParameter;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt64;
import org.sblim.wbem.cim.UnsignedInt8;

public class VolumeManagementSVC
extends VolumeManagement {
    public VolumeManagementSVC(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult modifyStoragePoolSize(ModifyStoragePoolParameter pParam) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"modifyStoragePoolSize", (Object[])new Object[]{pParam});
        AsyncResult mResult = new AsyncResult(10001, -1);
        String[] OPERATION = new String[]{"ModifyStoragePoolSizeOnSVC"};
        try {
            CIMObjectPath[] bCIMOPs;
            Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
            Vector mOutParams = new Vector();
            Object mInPools = null;
            CIMArgument arg1 = new CIMArgument("InPools");
            arg1.setValue(new CIMValue(mInPools, CIMDataType.getPredefinedType((int)24)));
            mInParams.add(arg1);
            String[] mInExtents = null;
            if (pParam.getStorageExtentsToAddCIMOP() != null && pParam.getStorageExtentsToAddCIMOP().length > 0) {
                bCIMOPs = pParam.getStorageExtentsToAddCIMOP();
                mInExtents = this.putCOPsIntoString(bCIMOPs);
            } else if (pParam.getStorageExtentsToRemoveCIMOP() != null) {
                bCIMOPs = pParam.getStorageExtentsToRemoveCIMOP();
                mInExtents = this.putCOPsIntoString(bCIMOPs);
                CIMArgument sizeArg = new CIMArgument("Size");
                sizeArg.setValue(new CIMValue((Object)new UnsignedInt64(0), CIMDataType.getPredefinedType((int)6)));
                mInParams.add(sizeArg);
                CIMArgument forceArg = new CIMArgument("Force");
                forceArg.setValue(new CIMValue((Object)new Boolean(false), CIMDataType.getPredefinedType((int)9)));
                mInParams.add(forceArg);
            }
            CIMArgument arg2 = new CIMArgument("InExtents");
            arg2.setValue(new CIMValue((Object)mInExtents, CIMDataType.getPredefinedType((int)24)));
            mInParams.add(arg2);
            CIMArgument arg3 = new CIMArgument("Pool");
            arg3.setValue(new CIMValue((Object)pParam.getStoragePoolCIMOP(), CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg3);
            this.retrieveAssociatedStorageConfigurationService();
            this.invokeCIMMethod(this.cStorageConfigurationService, "CreateOrModifyStoragePool", mInParams, mOutParams);
            CIMInstance bPoolInst = this.cCimClient.getInstance(pParam.getStoragePoolCIMOP(), true, false, true, this.cLogTraceHelper);
            SubProbeVolume mSubProbe = new SubProbeVolume(this.cPlugin.getParams(), this);
            String bPoolID = ExternalKeyConverter.frameKeyStoragePool((String)pParam.getStoragePool().getInstanceId(), (String)pParam.getStorageSubsystem().getName(), (short)pParam.getStorageSubsystem().getNameFormat());
            MapperResult bRes = mSubProbe.persistVolumeOrPool(bPoolInst, bPoolID, null);
            ArrayList<CIMObjectPath> mExtentCOPs = new ArrayList<CIMObjectPath>();
            mExtentCOPs.addAll(Arrays.asList(pParam.getStorageExtentsToAddCIMOP()));
            mExtentCOPs.addAll(Arrays.asList(pParam.getStorageExtentsToRemoveCIMOP()));
            SubProbeSVCExtent mExtentProbe = new SubProbeSVCExtent();
            mExtentProbe.performProbe(this.cCimClient, pParam.getStorageSubsystem(), pParam.getCimom(), pParam.getCapability(), mExtentCOPs);
            mResult.setRc(0);
            mResult.setStatus(1);
            mResult.setSRMMessage(new SRMMessage("HWN020001I", OPERATION));
        }
        catch (CIMException ce) {
            mResult.setRc(10007);
            mResult.setStatus(0);
            mResult.setSRMMessage(new SRMMessage("HWN021515E", OPERATION));
        }
        catch (DiskManagerTimeoutException dtEx) {
            mResult.setRc(10007);
            mResult.setStatus(0);
            mResult.setSRMMessage(new SRMMessage("HWN021515E", OPERATION));
        }
        catch (SQLException sqlEx) {
            mResult.setRc(10007);
            mResult.setStatus(0);
            mResult.setSRMMessage(new SRMMessage("HWN021515E", OPERATION));
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public AsyncResult createStorageVolume(String pStoragePoolID, CIMObjectPath pStoragePoolCIMOP, String pVolumeName, long pSize, CIMObjectPath[] pStorageExtents, boolean pFormatOnCreate, int pVirtualizationType, CIMObjectPath pIOGroup) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createStorageVolume", (Object[])new Object[]{pStoragePoolID, pStoragePoolCIMOP, pVolumeName, new Long(pSize), pStorageExtents, new Boolean(pFormatOnCreate), new Integer(pVirtualizationType), pIOGroup});
        AsyncResult mResult = new AsyncResult(10001, -1);
        String[] OPERATION = new String[]{"CreateStorageVolumeOnSVC"};
        VolumeID mRes = new VolumeID();
        mRes.setStoragePoolID(pStoragePoolID);
        try {
            Vector<CIMArgument> mInParams = new Vector<CIMArgument>();
            Vector mOutParams = new Vector();
            if (pVolumeName != null) {
                CIMArgument arg1 = new CIMArgument("ElementName");
                arg1.setValue(new CIMValue((Object)pVolumeName, CIMDataType.getPredefinedType((int)8)));
                mInParams.add(arg1);
            }
            UnsignedInt16 elementType = new UnsignedInt16(2);
            CIMArgument arg2 = new CIMArgument("ElementType");
            arg2.setValue(new CIMValue((Object)elementType, CIMDataType.getPredefinedType((int)2)));
            mInParams.add(arg2);
            Object stgSettingCOP = null;
            CIMArgument arg3 = new CIMArgument("Goal");
            arg3.setValue(new CIMValue(stgSettingCOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg3);
            CIMArgument arg4 = new CIMArgument("Size");
            arg4.setValue(new CIMValue((Object)new UnsignedInt64(String.valueOf(pSize)), CIMDataType.getPredefinedType((int)6)));
            mInParams.add(arg4);
            CIMArgument arg5 = new CIMArgument("InPool");
            arg5.setValue(new CIMValue((Object)pStoragePoolCIMOP, CIMDataType.getPredefinedType((int)14)));
            mInParams.add(arg5);
            CIMArgument arg6 = new CIMArgument("VirtualizationType");
            arg6.setValue(new CIMValue((Object)new UnsignedInt8((short)pVirtualizationType), CIMDataType.getPredefinedType((int)0)));
            mInParams.add(arg6);
            if (pIOGroup != null) {
                CIMArgument arg7 = new CIMArgument("IOGroup");
                arg7.setValue(new CIMValue((Object)pIOGroup, CIMDataType.getPredefinedType((int)14)));
                mInParams.add(arg7);
            }
            CIMArgument arg8 = new CIMArgument("Format");
            arg8.setValue(new CIMValue((Object)new Boolean(pFormatOnCreate), CIMDataType.getPredefinedType((int)9)));
            mInParams.add(arg8);
            if (pStorageExtents != null) {
                CIMArgument arg9 = new CIMArgument("BackendVolumes");
                String[] mBackendVols = this.putCOPsIntoString(pStorageExtents);
                arg9.setValue(new CIMValue((Object)mBackendVols, CIMDataType.getPredefinedType((int)24)));
                mInParams.add(arg9);
            }
            this.retrieveAssociatedStorageConfigurationService();
            this.invokeCIMMethod(this.cStorageConfigurationService, "CreateOrModifyElementFromStoragePool", mInParams, mOutParams);
            CIMInstance bNewVolInst = null;
            CIMInstance bPoolInst = null;
            CIMObjectPath newVolumeCIMOP = null;
            for (int i = 0; i < mOutParams.size(); ++i) {
                CIMArgument out = (CIMArgument)mOutParams.get(i);
                if (out.getName().compareTo("TheElement") != 0) continue;
                newVolumeCIMOP = (CIMObjectPath)out.getValue().getValue();
                bNewVolInst = this.cCimClient.getInstance(newVolumeCIMOP, false, true, true, this.cLogTraceHelper);
            }
            if (bNewVolInst != null) {
                bPoolInst = this.cCimClient.getInstance(pStoragePoolCIMOP, true, false, true, this.cLogTraceHelper);
            }
            SubProbeVolume mSubProbe = new SubProbeVolume(this.cPlugin.getParams(), this);
            MapperResult bRes = mSubProbe.persistVolumeOrPool(bNewVolInst, pStoragePoolID, newVolumeCIMOP);
            Hashtable mInsertVals = bRes.getAllRows();
            Hashtable mNewEntry = (Hashtable)mInsertVals.get(StorageVolume.getTablename());
            String bVolName = (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"NAME"));
            String bVolNameFormat = (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"NAME_FORMAT"));
            ((CreateStorageVolumesParameter)this.cPlugin.getParams()).setVolumeElementName((String)mNewEntry.get(StorageVolume.getColumnInfo((String)"DISPLAY_NAME")));
            mRes.setStorageVolumeID(ExternalKeyConverter.frameKeyStorageVolume((String)bVolName, (short)Short.parseShort(bVolNameFormat), (String)this.cPlugin.getParams().getStorageSubsystem().getName(), (short)this.cPlugin.getParams().getStorageSubsystem().getNameFormat()));
            bRes = mSubProbe.persistVolumeOrPool(bPoolInst, pStoragePoolID, null);
            this.indicateCreatedEntity(TResStorageVolumeTable.getTablename(), (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"SVID")));
            this.indicateModifiedEntity(TResStoragePoolTable.getTablename(), (String)mNewEntry.get(StorageVolume.getColumnInfo((String)"POOL_ID")));
            StorageSubsystem mStorageSubsystem = ((CreateStorageVolumesParameter)this.cPlugin.getParams()).getStorageSubsystem();
            DiskManager.getInstance().probeStorageVolume(String.valueOf(mStorageSubsystem.getName() + "+" + String.valueOf(mStorageSubsystem.getNameFormat())), mRes.getStorageVolumeID(), 2);
            mResult.setStatus(1);
            mResult.setRc(0);
            mResult.setSRMMessage(new SRMMessage("HWN020001I", OPERATION));
        }
        catch (CIMException ce) {
            SRMMessage message = new SRMMessage("HWN021515E", new String[]{"getInstance", this.cCimClient.toString(), ce.toString()});
            mResult.setResults((Object[])new VolumeID[]{mRes});
            mResult.setSRMMessage(message);
            mResult.setRc(0);
        }
        catch (DiskManagerTimeoutException dtEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)dtEx.getMessage(), (LogTraceHelper)mLTH);
        }
        catch (SQLException sqlEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)mRes);
        }
        mResult.setResults((Object[])new VolumeID[]{mRes});
        return mResult;
    }

    protected String[] putCOPsIntoString(CIMObjectPath[] pCOPs) {
        String[] bCOPStrings = new String[pCOPs.length];
        for (int i = 0; i < bCOPStrings.length; ++i) {
            bCOPStrings[i] = pCOPs[i].toString();
            bCOPStrings[i] = bCOPStrings[i].substring(bCOPStrings[i].indexOf(":") + 1);
        }
        return bCOPStrings;
    }
}

