/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.DiskActivator;
import org.eclipse.aperi.disk.api.ExtendedVolumeAssignments;
import org.eclipse.aperi.disk.api.VolumeAssignments;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.ISAssignedGenericUpdatePostProcess;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.MaskingInfo;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class DBHelperCreateAndUpdate
extends DBHelper {
    private static final short FCPORT_NAMEFORMAT = 1;
    private static final String PROCESSID_PREFIX = "C";
    private static IEventMonitorService eventMonitor = null;

    public DBHelperCreateAndUpdate(Token pToken) {
        super(pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMappings(AsyncResult pAsyncResult, AssignmentParameter pParameter) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMappings", (Object[])new Object[]{pAsyncResult, pParameter});
        try {
            this.updateMappings(pAsyncResult, pParameter, true);
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappings(AsyncResult pAsyncResult, AssignmentParameter pParameter, boolean pCreate) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMappings", (Object[])new Object[]{pAsyncResult, pParameter, new Boolean(pCreate)});
        DiskCIMProcessor mProcessor = new DiskCIMProcessor(null);
        try {
            mProcessor.setSMISVersion(pParameter.getCapability().getSmisVersion());
            mProcessor.setDeviceModel(pParameter.getStorageSubsystem().getModel());
            mProcessor.setInstrumentationVersion(pParameter.getCimom().getSoftwareLevel());
            mProcessor.setCIMNamespace(pParameter.getCIMClientWrapper().getNameSpace().getNameSpace());
            mProcessor.setCIMServiceURL(pParameter.getCimom().getServiceUrl());
            CIMOMManager.getCIMOMManager().registerCIMOMUsage(pParameter.getCimom().getServiceUrl());
            JobInfo mJobInfo = new JobInfo();
            mJobInfo.setResourceId(pParameter.getCimom().getServiceUrl());
            ArrayList mSuccessResults = ResultHelper.getSuccessfulSubResults((AsyncResult)pAsyncResult);
            ArrayList<CIMObjectPath> mVolumeCOPsToUpdate = new ArrayList<CIMObjectPath>();
            for (int i = 0; i < mSuccessResults.size(); ++i) {
                VolumeAssignments mAssignment = (VolumeAssignments)mSuccessResults.get(i);
                mVolumeCOPsToUpdate.add(pParameter.getVolumeCOPForID(mAssignment.getStorageVolumeID()));
                String mPortKey = mAssignment.getStorageID();
                Port mInitiatorPort = null;
                try {
                    mInitiatorPort = ExternalKeyManager.getPort((String)mPortKey, (int)pParameter.getStorageSubsystem().getSubsystemId(), (DBConnection)this.cDBConnection);
                }
                catch (EntityNotFoundException e) {
                    if (pCreate) {
                        mInitiatorPort = this.createPort(mPortKey);
                    }
                    ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
                    mLTH.traceError("Port " + mPortKey + "was not found in the database.", (Throwable)bEx);
                    throw bEx;
                }
                Integer portKey = new Integer(mInitiatorPort.getPortId());
                int bVolumeID = pParameter.getIDOfVolume(mAssignment.getStorageVolumeID());
                if (pCreate) {
                    this.createDataPathAndMaskingInfo(pParameter, mProcessor, mJobInfo, mAssignment, portKey, bVolumeID);
                    continue;
                }
                this.deleteDataPath(portKey, bVolumeID);
            }
            this.updateEntity(mVolumeCOPsToUpdate, "CIM_StorageVolume", pParameter, mProcessor, mJobInfo);
            ISAssignedGenericUpdatePostProcess.setIS_ASSIGNED(Integer.toString(pParameter.getStorageSubsystem().getSubsystemId()), this.cDBConnection);
        }
        catch (Exception e) {
            mLTH.traceError("Internal error: Exception", (Throwable)e);
            DiskMessageHelper.getServerException((String)"HWN021693W", null, (Throwable)e, (LogTraceHelper)mLTH);
            this.rollback();
            pAsyncResult.setReturnException((Exception)((Object)DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH)));
        }
        finally {
            if (mProcessor != null) {
                mProcessor.shutdown();
                mProcessor = null;
            }
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Port createPort(String pPortKey) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createPort", (Object[])new Object[]{pPortKey});
        Port mPortToCreate = new Port();
        try {
            mPortToCreate.setName(pPortKey);
            mPortToCreate.setNameFormat((short)1);
            mLTH.traceInfo("Port " + pPortKey + " not found in DB, creating");
            mPortToCreate.setType((short)0);
            mPortToCreate.setPortId(AutoIdentifier.getIdentifier((int)1, (int)1));
            mPortToCreate.setUpdateTimestamp(CurrentTime.getTimestamp((DBConnection)this.cDBConnection));
            boolean mPortExist = mPortToCreate.insert(this.cDBConnection);
            if (!mPortExist) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)mLTH);
                mLTH.traceError("Failed to create port for WWPN " + pPortKey, (Throwable)bEx);
                throw bEx;
            }
            this.indicateCreatedEntity(TResPortTable.getTablename(), new Integer(mPortToCreate.getPortId()).toString());
            this.indicateModifiedEntity(TResPortTable.getTablename(), new Integer(mPortToCreate.getPortId()).toString());
            ChangeDetection mChangeDetection = new ChangeDetection(this.cDBConnection);
            HashMap mTouchedEntities = new HashMap();
            LinkedList<String> list = new LinkedList<String>();
            list.add(String.valueOf(mPortToCreate.getPortId()));
            mTouchedEntities.put(TResPortTable.getTablename(), list);
            this.commit();
            mChangeDetection.complete(this.cDBConnection, mTouchedEntities, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
            Port port = mPortToCreate;
            return port;
        }
        finally {
            mLTH.exit((Object)mPortToCreate);
        }
    }

    private void createDataPathAndMaskingInfo(AssignmentParameter pParameter, DiskCIMProcessor pProcessor, JobInfo pJobInfo, VolumeAssignments pAssignment, Integer pInitiatorPortID, int pVolumeID) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createDataPathAndMaskingInfo", (Object[])new Object[]{pParameter, pProcessor, pJobInfo, pInitiatorPortID, new Integer(pVolumeID)});
        try {
            ChangeDetection mChangeDetection = new ChangeDetection(this.cDBConnection);
            Request request = Router.getRouter().getRequest(pJobInfo.getDiscoverRequest());
            String bScannerID = null;
            if (request != null) {
                bScannerID = request.getScannerId();
            }
            ExtendedVolumeAssignments mExtendedAssignment = (ExtendedVolumeAssignments)pAssignment;
            Hashtable mProperties = new Hashtable();
            DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "ref_toplevelsystem_id", new Integer(pParameter.getStorageSubsystem().getSubsystemId()));
            DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "SUBSYSTEM_ID", new Integer(pParameter.getStorageSubsystem().getSubsystemId()).toString());
            DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "CONTOLLER_COP", mExtendedAssignment.getProtocolControllerCOP());
            if (mExtendedAssignment.getCollection() != null) {
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "COLLECTION_NAME", mExtendedAssignment.getCollection().getName());
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "COLLECTION_ID", mExtendedAssignment.getCollection().getID());
            }
            DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "HOST_ID", mExtendedAssignment.getId());
            DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "HOST_ELEMENT_NAME", mExtendedAssignment.getName());
            DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "HOST_CAPTION", mExtendedAssignment.getCaption());
            MapperResult mRes = pProcessor.handleEntity(bScannerID, "MaskingInfo", mProperties);
            HashMap mTouchedEntities = new HashMap();
            DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getInsertedRows()));
            DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getUpdatedRows()));
            MaskingInfo mInfo = this.getMaskingInfo(mExtendedAssignment.getId(), pParameter.getStorageSubsystem().getSubsystemId());
            this.indicateModifiedEntity(TResMaskingInfoTable.getTablename(), String.valueOf(mInfo.getMaskingInfoId()));
            String[] mTargetPortWWPNs = mExtendedAssignment.getSubsystemPorts();
            for (int j = 0; j < mTargetPortWWPNs.length; ++j) {
                Port mTargetPort = ExternalKeyManager.getPort((String)mTargetPortWWPNs[j], (int)pParameter.getStorageSubsystem().getSubsystemId(), (DBConnection)this.cDBConnection);
                mProperties = new Hashtable();
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "INITIATOR_PORT_ID", pInitiatorPortID);
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "TARGET_PORT_ID", new Integer(mTargetPort.getPortId()));
                String bLUNID = mExtendedAssignment.getVolumeDeviceNumber();
                if (bLUNID != null && bLUNID.toLowerCase().startsWith("0x")) {
                    bLUNID = bLUNID.substring(2);
                }
                if (bLUNID != null && bLUNID != "") {
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "DEVICE_LUN_ID", new Integer(Integer.parseInt(bLUNID, 16)));
                    DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "HOST_LUN_ID", new Integer(Integer.parseInt(bLUNID, 16)));
                }
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "VOLUME_ID", new Integer(pVolumeID));
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "MASKING_INFO_ID", new Integer(mInfo.getMaskingInfoId()));
                mRes = pProcessor.handleEntity(bScannerID, "DataPath", mProperties);
                this.indicateModifiedEntity(TResDataPathTable.getTablename(), (String)mRes.getInsertedRows().get("MASKING_INFO_ID"));
                DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getInsertedRows()));
                DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getUpdatedRows()));
            }
            this.commit();
            mChangeDetection.complete(this.cDBConnection, mTouchedEntities, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
        }
        catch (Exception e) {
            mLTH.traceError("Internal Error: Exception", (Throwable)e);
            this.rollback();
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntity(ArrayList pCOPs, String pType, ConfigurationParameter pParameter, DiskCIMProcessor pProcessor, JobInfo pJobInfo) throws DiskManagerTimeoutException, DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"updateEntity", (Object[])new Object[]{pCOPs, pParameter, pProcessor, pJobInfo});
        try {
            ChangeDetection mChangeDetection = new ChangeDetection(this.cDBConnection);
            HashMap mTouchedEntities = new HashMap();
            for (int i = 0; i < pCOPs.size(); ++i) {
                CIMObjectPath mCOP = (CIMObjectPath)pCOPs.get(i);
                CIMInstance mInstance = pParameter.getCIMClientWrapper().getInstance(mCOP, false, true, mLTH);
                Hashtable mProperties = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mInstance);
                mProperties.put("originalcimclassname", pType);
                Request request = Router.getRouter().getRequest(pJobInfo.getDiscoverRequest());
                String bScannerID = null;
                if (request != null) {
                    bScannerID = request.getScannerId();
                }
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mProperties, "ref_toplevelsystem_id", new Integer(pParameter.getStorageSubsystem().getSubsystemId()));
                MapperResult mRes = pProcessor.handleEntity(bScannerID, mCOP.getObjectName(), mProperties);
                DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getInsertedRows()));
                DiskMonitorHelper.addEntriesToInternalList(mTouchedEntities, MapperResult.convertRowsToIdentifiers((Map)mRes.getUpdatedRows()));
            }
            this.commit();
            mChangeDetection.complete(this.cDBConnection, mTouchedEntities, PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString());
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMappings(AsyncResult pAsyncResult, AssignmentParameter pParameter) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteMappings", (Object[])new Object[]{pAsyncResult});
        try {
            this.updateMappings(pAsyncResult, pParameter, false);
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataPath(Integer pHostID, int pVolumeID) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteDataPath", (Object[])new Object[]{pHostID, new Integer(pVolumeID)});
        try {
            Hashtable mFilterHash = new Hashtable();
            if (pHostID != null) {
                ColumnInfo mColumnInfoIPID = DataPath.getColumnInfo((String)"INITIATOR_PORT_ID");
                DBHelperCreateAndUpdate.putObjectIntoHashtable(mFilterHash, mColumnInfoIPID, pHostID);
            }
            this.indicateRemovedEntity(DataPath.getTablename(), String.valueOf(pVolumeID));
            ColumnInfo mColumnInfoVID = DataPath.getColumnInfo((String)"VOLUME_ID");
            DBHelperCreateAndUpdate.putObjectIntoHashtable(mFilterHash, mColumnInfoVID, Integer.toString(pVolumeID));
            DataPath.deletes((DBConnection)this.cDBConnection, mFilterHash);
            this.commit();
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected void rollback() {
        if (this.cDBConnection != null) {
            LogTraceHelper mLTH = null;
            try {
                this.cDBConnection.rollback();
            }
            catch (SQLException e) {
                mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"rollback", null);
                mLTH.traceError("Internal error: SQLException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
            }
            finally {
                if (mLTH != null) {
                    mLTH.exit(null);
                }
            }
        }
    }

    protected static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)DiskActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    protected void indicateCreatedEntity(String pTableName, String pAutoID) {
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleNewDevice(this.cToken.getJobId(), pTableName, pAutoID);
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleDeviceStateChange(this.cToken.getJobId(), pTableName, pAutoID, 0, 1);
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleModelUpdate(this.cToken.getJobId());
    }

    protected void indicateRemovedEntity(String pTableName, String pAutoID) {
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleDeviceStateChange(this.cToken.getJobId(), pTableName, pAutoID, 1, 0);
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleModelUpdate(this.cToken.getJobId());
    }

    protected void indicateModifiedEntity(String pTableName, String pAutoID) {
        DBHelperCreateAndUpdate.getEventMonitorProxy().handleModelUpdate(this.cToken.getJobId());
    }
}

