/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.CIM.MappingManagementEMC11;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagementSMIS11;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginSMIS11;
import org.eclipse.aperi.disk.control.util.DeleteStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageConfigurationPluginEMC11
extends StorageConfigurationPluginSMIS11 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getDefaultSupportedVolumeSizeRange(StoragePool pStoragePool, CIMObjectPath pStoragePoolCIMOP) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getDefaultSupportedVolumeSizeRange", (Object[])new Object[]{pStoragePool, pStoragePoolCIMOP});
        long[] mResult = new long[]{-1L, -1L, -1L};
        try {
            mResult[0] = 1L;
            mResult[1] = pStoragePool.getTotalAvailableSpace() * 512L;
            mResult[2] = 1L;
            long[] lArray = mResult;
            return lArray;
        }
        finally {
            mLTH.exit((Object)mResult);
        }
    }

    public MappingManagement getMappingManagement() {
        if (this.cMappingManagement == null) {
            this.cMappingManagement = this.cParams.getCapability().getOneHwIdPerView() == 0 ? new MappingManagementEMC11(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken()) : new MappingManagementEMC11(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cMappingManagement;
    }

    public PrivilegeManagement getPrivilegeManagement() {
        if (this.cPrivilegeManagement == null) {
            this.cPrivilegeManagement = new PrivilegeManagementSMIS11(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cPrivilegeManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult[] deleteStorageVolumes(DeleteStorageVolumesParameter pParam) throws NotAvailableException, Exception {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"deleteStorageVolumes", (Object[])new Object[]{pParam});
        CIMClientWrapper bCimClient = CIMClientPool.getClient((String)pParam.getCimom().getUserId(), (String)pParam.getCimom().getPassword(), (String)pParam.getCimom().getServiceUrl(), (String)pParam.getCimom().getInteropSchemaNamespace());
        bCimClient.setTimeout(1200000L);
        pParam.setCIMClientWrapper(bCimClient);
        CIMObjectPath[] mStorageVolumeCIMOPs = pParam.getStorageVolumeCIMOPs();
        ArrayList mPCsWithVolumes = new ArrayList();
        ArrayList mVolumesWithoutPCs = new ArrayList();
        mPCsWithVolumes = this.getMappingManagement().retrieveProtocolControllersForVolumes(mStorageVolumeCIMOPs, mVolumesWithoutPCs);
        if (mPCsWithVolumes.size() > 0) {
            String[] mLUNNames = new String[mStorageVolumeCIMOPs.length];
            StorageVolume[] mStorageVolumes = pParam.getStorageVolumes();
            for (int i = 0; i < mStorageVolumes.length; ++i) {
                mLUNNames[i] = mStorageVolumes[i].getName();
            }
            CIMObjectPath[] mPCsWithVolumesArray = new CIMObjectPath[mPCsWithVolumes.size()];
            for (int i = 0; i < mPCsWithVolumes.size(); ++i) {
                mPCsWithVolumesArray[i] = ((ProtocolControllerToPrivileges)mPCsWithVolumes.get(i)).getProtocolController();
            }
            CIMObjectPath[] mNewPCs = this.getMappingManagement().hidePaths(mPCsWithVolumesArray, pParam.getCapability(), mLUNNames, null, null);
            for (int i = 0; i < mPCsWithVolumesArray.length; ++i) {
                ArrayList mVolumes = this.getMappingManagement().retrieveProtocolControllerForUnit(mPCsWithVolumesArray[i]);
                if (mVolumes != null && !mVolumes.isEmpty()) continue;
                pParam.getCIMClientWrapper().deleteInstance(mPCsWithVolumesArray[i], mLTH);
            }
        }
        AsyncResult[] mAllResults = super.deleteStorageVolumes(pParam);
        return mAllResults;
    }
}

