/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.CIM.MappingManagementSMIS11;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;

public class StorageConfigurationPluginSMIS11
extends StorageConfigurationPlugin {
    public MappingManagement getMappingManagement() {
        if (this.cMappingManagement == null) {
            this.cMappingManagement = new MappingManagementSMIS11(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cMappingManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult assignStorageVolumesToWWPNs(AssignStorageVolumesParameter pParams) throws NotAvailableException, ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParams.getToken(), (Object)this, (String)"assignStorageVolumesToWWPNs", (Object[])new Object[]{pParams});
        try {
            pParams.setAPIMethodName("assignStorageVolumesToWWPNs");
            pParams.setAsyncResult(new AsyncResult());
            pParams.getAsyncResult().setSubJobResults(new AsyncResult[0]);
            this.validateAssignAccess(pParams);
            this.logAssignmentMessage("HWN021678I", pParams, mLTH);
            ArrayList mStorageHardwareIDs = this.getHardwareIDManagement().retrieveStorageHardwareIDs(pParams.getInitiatorWWPNs(), false);
            ArrayList mProtocolControllers = this.getMappingManagement().retrieveProtocolControllersForMappings(mStorageHardwareIDs, new ArrayList(), pParams.getVolumeCOPs());
            this.getMappingManagement().mapVolumesToPorts(mProtocolControllers, pParams);
            this.logAssignmentMessage("HWN021679I", pParams, mLTH);
        }
        catch (ServerException e) {
            mLTH.traceError("Internal error: ServerException", (Throwable)e);
            ArrayList bResults = ConfigurationResultHelper.createEmptyMappingResultsForMissingMappings(pParams.getAsyncResult(), pParams.getVolumeIDs(), pParams.getInitiatorWWPNsArray(), pParams.getStorageSubsystemID(), "HWN021679I", "HWN021680E", pParams.getToken());
            ResultHelper.addAsyncSubResultsException((AsyncResult)pParams.getAsyncResult(), (ArrayList)bResults, (int)-1, (SRMMessage)e.getSRMMessage(), (Exception)((Object)e));
            pParams.getAsyncResult().setReturnException((Exception)((Object)e));
        }
        catch (Exception e) {
            mLTH.traceError("Internal error: Exception", (Throwable)e);
            ArrayList bResults = ConfigurationResultHelper.createEmptyMappingResultsForMissingMappings(pParams.getAsyncResult(), pParams.getVolumeIDs(), pParams.getInitiatorWWPNsArray(), pParams.getStorageSubsystemID(), "HWN021679I", "HWN021680E", pParams.getToken());
            SRMMessage bMsg = new SRMMessage("HWN021503E", new String[0]);
            ResultHelper.addAsyncSubResultsException((AsyncResult)pParams.getAsyncResult(), (ArrayList)bResults, (int)-1, (SRMMessage)bMsg, (Exception)e);
            pParams.getAsyncResult().setReturnException(e);
        }
        finally {
            mLTH.exit((Object)pParams.getAsyncResult());
        }
        return pParams.getAsyncResult();
    }
}

