/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.GenericDiscoveryProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.sblim.wbem.cim.CIMInstance;

public class ESSDiscoveryProcessPlugin
extends GenericDiscoveryProcessPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESSDiscoveryProcessPlugin() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"ESSDiscoveryProcessPlugin", null);
        try {
            mLTH.objectCreation(ESSDiscoveryProcessPlugin.class.getName());
            this.cCIMOMExclusions = this.readCimomExclusion(mLTH);
        }
        finally {
            mLTH.exit((Object)this);
        }
    }

    protected void getSpecificDataForDevice(CIMInstance pInstance, StorageDeviceData pData) throws DiscoveryException {
        this.getCluster(pInstance, pData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCluster(CIMInstance pCluster, StorageDeviceData pDeviceData) throws DiscoveryException {
        String mMethodName = "getCluster";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pCluster, pDeviceData});
        try {
            Response mResponse;
            CIMInstance mInstance = null;
            this.cParameters.put("IN_SYSTEM_ESSCLUSTER", pCluster);
            String[] mRegCluster = Router.getRouter().perform("ESSCLUSTER", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mRegCluster);
            JobInfo mJob = (JobInfo)JobEngine.getInstance().getJobs(mRegCluster[1]).get(0);
            if (!mJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mJob, "ESSCLUSTER");
            }
            if ((mResponse = mJob.getResponse()) instanceof Response) {
                Enumeration mEnumRemote = (Enumeration)mResponse.getData();
                while (mEnumRemote.hasMoreElements()) {
                    mInstance = (CIMInstance)mEnumRemote.nextElement();
                    pDeviceData.setDataFromInstance("remoteCluster", mInstance, mLTH);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveSpecificData(StorageDeviceData pData, MapperRouter pMapperRouter, String pSMISVersion, String pScannID, Hashtable pReturnValue) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"saveSpecificData", (Object[])new Object[]{pData, pMapperRouter, pSMISVersion, pScannID, pReturnValue});
        try {
            CIMInstance mInstance = pData.getInstance("remoteCluster");
            if (mInstance != null) {
                Hashtable mParam = CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)mInstance);
                mParam.putAll(pReturnValue);
                this.cDiskCimProcessor.setSMISVersion(pSMISVersion);
                this.cDiskCimProcessor.setInstrumentationVersion(((String[])this.cParameters.get("CIMOM"))[5]);
                this.cDiskCimProcessor.handleEntity(pScannID, mInstance.getClassName(), mParam);
                mLTH.traceInfo("save ESSCluster" + mInstance.getObjectPath().toString());
            }
        }
        catch (org.eclipse.aperi.discovery.interfaces.DiscoveryException pEx) {
            if (pEx.getCause() instanceof SQLException) {
                throw (SQLException)pEx.getCause();
            }
            mLTH.traceInfo("not handeled " + pEx.getCause().getMessage());
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected Capabilities correctCapabilities(StorageDeviceData pData) {
        Capabilities pCap = pData.getCapabilities();
        CIMInstance mInstance = pData.getInstance("");
        String mName = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Name");
        if (mName != null && mName.startsWith("2105")) {
            pCap.setVolumeDeletionSupported(false);
            pData.setCapabilities(pCap);
        }
        return pCap;
    }

    protected String readCimomExclusion(LogTraceHelper pLTH) {
        return this.readRegExForCIMOMExclusion("ESS", pLTH);
    }
}

