/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.ProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.sblim.wbem.cim.CIMInstance;

public class GenericDiscoveryProcessPlugin
extends ProcessPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDiscoveryProcessPlugin() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"GenericDiscoveryProcessPlugin", null);
        try {
            mLTH.objectCreation(GenericDiscoveryProcessPlugin.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    public List collectDeviceData(String pObjectManagerID, String pCIMOMVersion) throws DiscoveryException {
        String mMethodName = "collectDeviceData";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pObjectManagerID});
        LinkedList mDeviceList = new LinkedList();
        LinkedList mReturn = new LinkedList();
        String mScannID = null;
        Response mResponse = null;
        Enumeration mObjMgrEnum = null;
        List mStorageProfileList = null;
        Iterator mStorageProfileIterator = null;
        try {
            if (pObjectManagerID == null) {
                mLTH.traceInfo("(ObjectManagerID) == null -> No connection to the CIMOM: " + ((String[])this.cParameters.get("CIMOM"))[0]);
                List list = null;
                return list;
            }
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(pObjectManagerID).get(0);
            if (!mObjectJob.isSuccessful()) {
                mLTH.traceInfo("ServerProfile not supported");
                List list = null;
                return list;
            }
            mScannID = mObjectJob.getResourceId();
            mResponse = mObjectJob.getResponse();
            mObjMgrEnum = (Enumeration)mResponse.getData();
            mStorageProfileList = this.getStorageProfiles();
            mStorageProfileIterator = mStorageProfileList.iterator();
            CIMInstance mProfileInstance = null;
            String mSubProfile = null;
            while (mStorageProfileIterator.hasNext()) {
                mProfileInstance = (CIMInstance)mStorageProfileIterator.next();
                mSubProfile = null;
                if (!this.isUsedProfile(mProfileInstance)) continue;
                List mSystemList = this.getSystemsForProfile(mProfileInstance);
                this.handleComputerSystem(mDeviceList, mProfileInstance, mSubProfile, mSystemList);
            }
            Iterator mDeviceIt = mDeviceList.iterator();
            int mCurrentDevice = 0;
            while (mDeviceIt.hasNext()) {
                Object[] mArray = (Object[])mDeviceIt.next();
                ++mCurrentDevice;
                this.setCIMOMVersion(pCIMOMVersion, (StorageDeviceData)mArray[0], mLTH);
                this.getCapabilitiesOfDevice((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                if (((StorageDeviceData)mArray[0]).getCapabilities() != null) {
                    ((StorageDeviceData)mArray[0]).getCapabilities().setSMISVersion(((StorageDeviceData)mArray[0]).getSMISVersion());
                }
                this.getProductOfSystem((CIMInstance)mArray[1], (StorageDeviceData)mArray[0], true);
                this.getSAPForSystem((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                this.handleCluster(mArray);
                this.getSoftwareOfDevice((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                this.getSpecificDataForDevice((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                mLTH.traceInfo("NameSpace :" + ((StorageDeviceData)mArray[0]).getNameSpace());
                mLTH.traceInfo(((StorageDeviceData)mArray[0]).getDebugString());
                if (((StorageDeviceData)mArray[0]).getCapabilities() != null) {
                    this.correctCapabilities((StorageDeviceData)mArray[0]);
                }
                this.saveAllInformation(mLTH, mDeviceList, mReturn, mScannID, mCurrentDevice, mArray);
            }
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    private void setCIMOMVersion(String pCIMOMVersion, StorageDeviceData pData, LogTraceHelper pLTH) {
        if (pCIMOMVersion != null) {
            pLTH.traceInfo("Used CIMOM Version:" + pCIMOMVersion);
            pData.setCIMOMVersion(pCIMOMVersion);
        } else {
            pLTH.traceInfo("Used CIMOM Version: null");
        }
    }

    protected String readCimomExclusion(String pString) {
        return null;
    }

    protected void saveAllInformation(LogTraceHelper pLTH, List pDeviceList, List pReturn, String pScannID, int pCurrentDevice, Object[] pArray) throws SQLException {
        Hashtable mSlpKeyReferences = this.saveNameSpace(pLTH, this.getMapperRouter(), pScannID, ((StorageDeviceData)pArray[0]).getNameSpace(), ((StorageDeviceData)pArray[0]).getCIMOMVersion());
        if (!this.checkCIMOMVersion(((StorageDeviceData)pArray[0]).getCIMOMVersion())) {
            pLTH.traceInfo("CIMOMVersion :" + ((StorageDeviceData)pArray[0]).getCIMOMVersion() + " not supported");
            return;
        }
        Hashtable mReturnValues = this.saveSubSystem(pArray, pLTH, this.getMapperRouter(), pScannID, mSlpKeyReferences);
        if (mReturnValues.size() > 0) {
            mReturnValues.putAll(mSlpKeyReferences);
            this.saveProduct(pArray, pLTH, this.getMapperRouter(), pScannID, mReturnValues);
            this.saveNodes(pArray, pLTH, this.getMapperRouter(), pScannID, mReturnValues);
            this.saveSoftware(pArray, pLTH, this.getMapperRouter(), pScannID, mReturnValues);
            this.saveSpecificData((StorageDeviceData)pArray[0], pLTH, this.getMapperRouter(), ((StorageDeviceData)pArray[0]).getSMISVersion(), pScannID, mReturnValues);
            this.saveCapabilities(pArray, this.getMapperRouter(), pScannID, mReturnValues);
            this.cDiskCimProcessor.doCommit(pLTH);
            if (((StorageDeviceData)pArray[0]).getProfile().indexOf("Array") >= 0 || ((StorageDeviceData)pArray[0]).getProfile().indexOf("In Band Virtualization") >= 0) {
                CIMOMSelector.getSelector().activateCimomForSubsystem(Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_cimom2namespaceid")), Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_id")));
            } else if (((StorageDeviceData)pArray[0]).getProfile().indexOf("Switch") >= 0) {
                CIMOMSelector.getSelector().activateCimomForSwitch(Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_cimom2namespaceid")), (String)mReturnValues.get("ref_switch_wwn"));
            } else if (((StorageDeviceData)pArray[0]).getProfile().indexOf("Storage Library") >= 0) {
                CIMOMSelector.getSelector().activateCimomForTapeLibrary(Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_cimom2namespaceid")), Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_id")));
            } else {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)"unsupported profile found", (LogTraceHelper)pLTH);
            }
            pReturn.add((StorageDeviceData)pArray[0]);
        } else {
            pLTH.traceInfo("No additional info returned for SaveSubsystem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCluster(Object[] mArray) throws DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"handleCluste", (Object[])new Object[]{mArray});
        try {
            if (this.supportsSubProfile(((StorageDeviceData)mArray[0]).getSubProfile(), "Cluster") || this.supportsSubProfile(((StorageDeviceData)mArray[0]).getSubProfile(), "Multiple Computer System")) {
                List mNodeList = this.getNodesOfCluster((CIMInstance)mArray[1]);
                Iterator mNodesIt = mNodeList.iterator();
                int mNodeCounter = 0;
                while (mNodesIt.hasNext()) {
                    CIMInstance mNodeInstance = (CIMInstance)mNodesIt.next();
                    this.getProductOfSystem(mNodeInstance, (StorageDeviceData)mArray[0], false);
                    this.getSAPForSystem(mNodeInstance, (StorageDeviceData)mArray[0]);
                    this.getSoftwareOfDevice(mNodeInstance, (StorageDeviceData)mArray[0]);
                    this.getSpecificDataForNode(mNodeInstance, (StorageDeviceData)mArray[0]);
                    ((StorageDeviceData)mArray[0]).setDataFromInstance("node_" + ++mNodeCounter, mNodeInstance, mLTH);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }
}

