/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.ExtentIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;

public class ExtentDeletionHandler
extends ExtentIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_StorageExtent", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR3 = new CIMIndicationHandler.RegistrationData("IBMTSESS_StorageExtent", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR5 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_BackendVolume", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1, mR3, mR5};
    }

    public ExtentDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        block10: {
            DBConnection mConn = null;
            CIMObjectPath mExtentCop = this.getEvent().getSourceCop();
            try {
                String mCreationClassName = (String)mExtentCop.getKey("CreationClassName").getValue().getValue();
                String mSystemCreationClassName = (String)mExtentCop.getKey("SystemCreationClassName").getValue().getValue();
                String mSystemName = (String)mExtentCop.getKey("SystemName").getValue().getValue();
                String mDeviceID = (String)mExtentCop.getKey("DeviceID").getValue().getValue();
                String mCimomId = this.getEvent().getCIMOM().getServiceId();
                String mNamespace = this.getEvent().getCIMNameSpace();
                DBConnPoolDataSource dbpool = DBConnPoolDataSource.getInstance();
                mConn = (DBConnection)dbpool.getPooledConnection();
                try {
                    int[] mSubsystemIds = DiskMonitorHelper.getManagedSubsystems(mConn, mCimomId, mNamespace);
                    StorageExtent mExtent = ExtentDeletionHandler.getExtent(mConn, mCreationClassName, mSystemCreationClassName, mSystemName, mDeviceID, mSubsystemIds);
                    if (mExtent == null) break block10;
                    try {
                        ExtentDeletionHandler.deleteVolume2Extent(mConn, mExtent.getStorageExtentId());
                        ExtentDeletionHandler.detachDiskGroup(mConn, mExtent);
                        mExtent.delete(mConn);
                        mConn.commit();
                        LinkedList<String> mIds = new LinkedList<String>();
                        mIds.add(Integer.toString(mExtent.getStorageExtentId()));
                        HashMap<String, LinkedList<String>> mTouchedEntities = new HashMap<String, LinkedList<String>>();
                        mTouchedEntities.put(TResStorageExtentTable.getTablename(), mIds);
                        Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, StorageExtent.getTablename(), Integer.toString(mExtent.getStorageExtentId()), 1, 0);
                        Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                    }
                    catch (Exception e) {
                        mConn.rollback();
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (mConn != null) {
                        mConn.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return HandlingResult.SUCCESS;
    }
}

