/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class ExtentIndicationHandler
extends CIMIndicationHandler {
    public static final String GENERIC_CLASS = "CIM_StorageExtent";

    public ExtentIndicationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        return null;
    }

    protected static StorageExtent getExtent(DBConnection pConnection, String pCreationClassName, String pSystemCreationClassName, String pSystemName, String pDeviceID, int[] pSubsystems) throws SQLException {
        for (int i = 0; i < pSubsystems.length; ++i) {
            StorageExtent mExtent = new StorageExtent();
            mExtent.setCreationClassName(pCreationClassName);
            mExtent.setSystemCreationClassName(pSystemCreationClassName);
            mExtent.setSystemNames(pSystemName);
            mExtent.setDeviceId(pDeviceID);
            mExtent.setSubsystemId(pSubsystems[i]);
            if (!mExtent.retrieve(pConnection)) continue;
            return mExtent;
        }
        return null;
    }

    protected static void deleteVolume2Extent(DBConnection pConnection, int pAffectedExtent) throws SQLException {
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        htWhere.clear();
        htWhere.put(Volume2extent.getColumnInfo((String)"STORAGE_EXTENT_ID"), String.valueOf(pAffectedExtent));
        Volume2extent.deletes((DBConnection)pConnection, htWhere);
    }

    protected static void detachDiskGroup(DBConnection pConnection, StorageExtent pExtent) throws SQLException {
        Hashtable<ColumnInfo, Integer> mParameters = new Hashtable<ColumnInfo, Integer>();
        mParameters.put(TResDiskGroupTable.getColumnInfo((String)"STORAGE_EXTENT_ID"), new Integer(pExtent.getStorageExtentId()));
        String mQueryString = "UPDATE " + TResDiskGroupTable.getTablename() + " SET " + "STORAGE_EXTENT_ID" + " = CAST(NULL AS INTEGER) WHERE " + "STORAGE_EXTENT_ID" + " = (?)";
        int mRc = ComplexQuery.sqlUpdate((DBConnection)pConnection, (String)mQueryString, mParameters);
    }
}

