/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.FCPortIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;

public class FCPortDeletionHandler
extends FCPortIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_FCPort", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1};
    }

    public FCPortDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        block19: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"handle", null);
            CIMObjectPath mFcPortCop = this.getEvent().getSourceCop();
            try {
                DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    HashMap mCopKeyMap = DiskMonitorHelper.getKeyMapFromCOP(mConnection, mFcPortCop);
                    String mSQL = "SELECT PORT_ID FROM " + TResCimkeyPortTable.getTablename() + " WHERE (" + "CREATION_CLASS_NAME_ID" + " = (?) AND " + "DEVICE_ID" + " = (?) AND " + "SYSTEM_CREATION_CLASS_NAME_ID" + " = (?) AND " + "SYSTEM_NAMES_ID" + " = (?))";
                    Hashtable mWhere = new Hashtable();
                    mWhere.put(TResCimkeyPortTable.getColumnInfo((String)"CREATION_CLASS_NAME_ID"), mCopKeyMap.get("CreationClassName"));
                    mWhere.put(TResCimkeyPortTable.getColumnInfo((String)"DEVICE_ID"), mCopKeyMap.get("DeviceID"));
                    mWhere.put(TResCimkeyPortTable.getColumnInfo((String)"SYSTEM_CREATION_CLASS_NAME_ID"), mCopKeyMap.get("SystemCreationClassName"));
                    mWhere.put(TResCimkeyPortTable.getColumnInfo((String)"SYSTEM_NAMES_ID"), mCopKeyMap.get("SystemName"));
                    mLTH.traceHigh(mSQL);
                    DBResultSet mDbResult = ComplexQuery.sqlQuery((DBConnection)mConnection, (String)mSQL, mWhere);
                    try {
                        if (!mDbResult.next()) break block19;
                        try {
                            String mPortId = Integer.toString(mDbResult.getInt("PORT_ID"));
                            boolean bEntityHasDetectableAttribute = false;
                            if (Port.getColumnInfo((String)"DETECTABLE") != null) {
                                bEntityHasDetectableAttribute = true;
                            }
                            if (bEntityHasDetectableAttribute) {
                                FCPortIndicationHandler.changeDetectableAttributeForFCPort(mConnection, "0", new Integer(mPortId));
                            } else {
                                mWhere.clear();
                                mWhere.put(TResCimkeyPortTable.getColumnInfo((String)"PORT_ID"), mPortId);
                                int mDeletedRowCount = CimkeyPort.deletes((DBConnection)mConnection, mWhere);
                                mLTH.traceHigh(Integer.toString(mDeletedRowCount) + "row(s) in " + TResCimkeyPortTable.getTablename() + " deleted.");
                                mWhere.clear();
                                mWhere.put(TResPortTable.getColumnInfo((String)"PORT_ID"), mPortId);
                                mDeletedRowCount = Port.deletes((DBConnection)mConnection, mWhere);
                                mLTH.traceHigh(Integer.toString(mDeletedRowCount) + "row(s) in " + TResPortTable.getTablename() + " deleted.");
                                mWhere.clear();
                                mWhere.put(TResDataPathTable.getColumnInfo((String)"INITIATOR_PORT_ID"), mPortId);
                                mDeletedRowCount = DataPath.deletes((DBConnection)mConnection, mWhere);
                                mLTH.traceHigh(Integer.toString(mDeletedRowCount) + "row(s) in " + TResDataPathTable.getTablename() + " deleted.");
                                mWhere.clear();
                                mWhere.put(TResDataPathTable.getColumnInfo((String)"TARGET_PORT_ID"), mPortId);
                                mDeletedRowCount = DataPath.deletes((DBConnection)mConnection, mWhere);
                                mLTH.traceHigh(Integer.toString(mDeletedRowCount) + "row(s) in " + TResDataPathTable.getTablename() + " deleted.");
                            }
                            mConnection.commit();
                            LinkedList<String> mIds = new LinkedList<String>();
                            mIds.add(mPortId);
                            HashMap<String, LinkedList<String>> mTouchedEntities = new HashMap<String, LinkedList<String>>();
                            mTouchedEntities.put(TResPortTable.getTablename(), mIds);
                            Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, Port.getTablename(), mPortId, 1, 0);
                            Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                        }
                        catch (Exception e) {
                            mConnection.rollback();
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        mDbResult.closeAll();
                    }
                }
                finally {
                    if (mConnection != null) {
                        mConnection.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                mLTH.exit(null);
            }
        }
        return HandlingResult.SUCCESS;
    }
}

