/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProtocolControllerForUnitDeletionHandler
extends CIMIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_ProtocolControllerForUnit", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1};
    }

    public ProtocolControllerForUnitDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        CIMInstance mTopLevelCS;
        CIMObjectPath mProConForUnit = this.getEvent().getSourceCop();
        String mController = (String)mProConForUnit.getKey("Antecedent").getValue().getValue();
        CIMObjectPath mControllerCOP = CIMIndicationEvent.parse((String)mController);
        String mVolume = (String)mProConForUnit.getKey("Dependent").getValue().getValue();
        CIMObjectPath mVolumeCOP = CIMIndicationEvent.parse((String)mVolume);
        try {
            mTopLevelCS = this.getAttachedTopLevelSystem(mControllerCOP);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                StorageSubsystem mSubsystem = this.getSubsystemFromCimInstance(mConnection, mTopLevelCS);
                int mVolumeId = DiskMonitorHelper.getVolumeId(mConnection, this.getEvent(), mVolumeCOP);
                Hashtable<ColumnInfo, String> mWhere = new Hashtable<ColumnInfo, String>();
                mWhere.put(TResMaskingInfoTable.getColumnInfo((String)"CONTOLLER_COP"), mController.toString());
                mWhere.put(TResMaskingInfoTable.getColumnInfo((String)"SUBSYSTEM_ID"), Integer.toString(mSubsystem.getSubsystemId()));
                String mSQL = "SELECT MASKING_INFO_ID FROM " + TResMaskingInfoTable.getTablename() + " WHERE " + "CONTOLLER_COP" + " = (?) AND " + "SUBSYSTEM_ID" + " = (?)";
                DBResultSet mDbResult = ComplexQuery.sqlQuery((DBConnection)mConnection, (String)mSQL, mWhere);
                try {
                    while (mDbResult.next()) {
                        mWhere.clear();
                        mWhere.put(TResDataPathTable.getColumnInfo((String)"MASKING_INFO_ID"), Integer.toString(mDbResult.getInt(1)));
                        mWhere.put(TResDataPathTable.getColumnInfo((String)"VOLUME_ID"), Integer.toString(mVolumeId));
                        DataPath.deletes((DBConnection)mConnection, mWhere);
                    }
                    mConnection.commit();
                    Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, DataPath.getTablename(), Integer.toString(mVolumeId), 1, 0);
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                }
                catch (Exception e) {
                    mConnection.rollback();
                }
                finally {
                    if (mDbResult != null) {
                        mDbResult.closeAll();
                    }
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return HandlingResult.SUCCESS;
    }
}

