/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.DiskActivator;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.SubsystemIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;

public class SubsystemDeletionHandler
extends SubsystemIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_ComputerSystem", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR2 = new CIMIndicationHandler.RegistrationData("IBMTSESS_StorageSystem", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR3 = new CIMIndicationHandler.RegistrationData("IBMTSESS_Cluster", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR4 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_Node", "CIM_InstDeletion");
        CIMIndicationHandler.RegistrationData mR5 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_Cluster", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{mR1, mR2, mR3, mR4, mR5};
    }

    public SubsystemDeletionHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"handle", null);
        try {
            CIMObjectPath mSubsystemCop = this.getEvent().getSourceCop();
            String mName = (String)mSubsystemCop.getKey("Name").getValue().getValue();
            String mCimomId = this.getEvent().getCIMOM().getServiceId();
            String mNamespace = this.getEvent().getCIMNameSpace();
            DBConnection mConn = null;
            String[] mSSkeyAndId = null;
            try {
                mConn = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                int[] mSubsystemIds = DiskMonitorHelper.getManagedSubsystems(mConn, mCimomId, mNamespace);
                mSSkeyAndId = this.getStorageSubsystemKeyAndID(mConn, mName, mSubsystemIds);
                if (StorageSubsystem.getColumnInfo((String)"DETECTABLE") != null) {
                    SubsystemIndicationHandler.changeDetectableAttributeForStorageSystem(mConn, "0", new Integer(mSSkeyAndId[1]));
                } else {
                    Object bObject = DiskActivator._serviceHelper.bindLocal("DiskManagerService");
                    IDiskManagerService bProxy = (IDiskManagerService)bObject;
                    Result[] bResult = bProxy.deleteStorageSubsystems(new String[]{mSSkeyAndId[0]});
                    mLTH.traceInfo(bResult.toString());
                }
                Processor.getEventMonitorProxy().handleDeviceStateChange(pProcessID, StorageSubsystem.getTablename(), mSSkeyAndId[1], 1, 0);
                Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
            }
            catch (Exception pE) {
                throw new RuntimeException(pE);
            }
            finally {
                if (mConn != null) {
                    try {
                        mConn.close();
                    }
                    catch (SQLException pE) {
                        throw new RuntimeException(pE);
                    }
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
        return HandlingResult.SUCCESS;
    }
}

