/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.interfaces.IMessagingService;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.JMSImplLogInfo;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopic;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicConnection;

public class MSTopicPublisher
implements TopicPublisher {
    private MSTopicConnection topicConnection;
    private MSTopic topic;
    private IMessagingService msgProxy;
    private ILogger traceLogger = JMSImplLogInfo.traceLogger;
    private ILogger msgLogger = JMSImplLogInfo.msgLogger;
    private static String className = null;

    public MSTopicPublisher(MSTopicConnection connection, MSTopic topic) throws JMSException {
        className = this.getClass().getName();
        String methodName = "MSTopicPublisher(MSTopicConnection connection, MSTopic topic)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.topicConnection = connection;
        this.topic = topic;
        try {
            this.msgProxy = (IMessagingService)Activator._serviceHelper.bindLocal("MessagingService");
        }
        catch (Exception ex) {
            if (this.msgLogger != null && this.msgLogger.isLogging()) {
                this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_GetProxyFailed");
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "A proxy to the Messaging Service could not be obtained.");
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ex);
            }
            throw new JMSException("A proxy to the Messaging Service could not be obtained.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public Topic getTopic() throws JMSException {
        String methodName = "getTopic()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.topic;
    }

    public void publish(Message message) throws JMSException {
        String methodName = "publish(Message message)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String topic = this.topic.getTopicName();
        try {
            if (!this.msgProxy.isAlive()) {
                if (this.msgLogger != null && this.msgLogger.isLogging()) {
                    this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_Down");
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Messaging Service is not running. Cannot publish events.");
                }
                throw new JMSException("Messaging Service is not running. Cannot publish events.");
            }
            this.msgProxy.publish(topic, message);
        }
        catch (Exception e) {
            if (this.msgLogger != null && this.msgLogger.isLogging()) {
                this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "publish_failed", (Object)topic);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            throw new JMSException("Cannot publish message. Exception: " + e.toString());
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void publish(Message arg0, int arg1, int arg2, long arg3) throws JMSException {
        throw new JMSException("publish(Message arg0, int arg1, int arg2, long arg3) not implemented");
    }

    public void publish(Topic topic, Message message) throws JMSException {
        String methodName = "publish(Topic topic, Message message)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String topicName = topic.getTopicName();
        try {
            if (!this.msgProxy.isAlive()) {
                if (this.msgLogger != null && this.msgLogger.isLogging()) {
                    this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_Down");
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Messaging Service is not running. Cannot publish events.");
                }
                throw new JMSException("Messaging Service is not running. Cannot publish events.");
            }
            this.msgProxy.publish(topicName, message);
        }
        catch (Exception e) {
            if (this.msgLogger != null && this.msgLogger.isLogging()) {
                this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "publish_failed", (Object)topic);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            throw new JMSException("Cannot publish message. Exception: " + e.toString());
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void publish(Topic arg0, Message arg1, int arg2, int arg3, long arg4) throws JMSException {
        throw new JMSException("publish(Topic arg0, Message arg1, int arg2, int arg3, long arg4) not implemented");
    }

    public void close() throws JMSException {
        String methodName = "close()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getDeliveryMode() throws JMSException {
        throw new JMSException("getDeliveryMode() not implemented");
    }

    public boolean getDisableMessageID() throws JMSException {
        throw new JMSException("getDisableMessageID() not implemented");
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        throw new JMSException("getDisableMessageTimestamp() not implemented");
    }

    public int getPriority() throws JMSException {
        throw new JMSException("getPriority() not implemented");
    }

    public long getTimeToLive() throws JMSException {
        throw new JMSException("getTimeToLive() not implemented");
    }

    public void setDeliveryMode(int arg0) throws JMSException {
        throw new JMSException("setDeliveryMode(int arg0) not implemented");
    }

    public void setDisableMessageID(boolean arg0) throws JMSException {
        throw new JMSException("setDisableMessageID(boolean arg0) not implemented");
    }

    public void setDisableMessageTimestamp(boolean arg0) throws JMSException {
        throw new JMSException("setDisableMessageMessageTimestamp(boolean arg0) not implemented");
    }

    public void setPriority(int arg0) throws JMSException {
        throw new JMSException("setPriority(int arg0) not implemented");
    }

    public void setTimeToLive(long arg0) throws JMSException {
        throw new JMSException("setTimeToLive(long arg0) not implemented");
    }
}

