/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.aperi.San.server.guireq.RespEndToEnd;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class EndToEndAdjuster
extends CustomReportDataAdjuster {
    public static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    public static final String DISK_ARRAY = MessageLog.getMessageNoID("STG5272L");
    public static final String LVFS_PATH = MessageLog.getMessageNoID("STG5273L");
    public static final String ARRAY_SIDE_PATH = MessageLog.getMessageNoID("SAG0514L");
    public static final String COMP_LUN_PATH = MessageLog.getMessageNoID("STG5276L");
    public static final String MANUFACTURER = MessageLog.getMessageNoID("STG1105L");
    public static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    public static final String SERIAL_NUMBER = MessageLog.getMessageNoID("STG1107L");
    public static final String PHYSICAL_ALLOC = MessageLog.getMessageNoID("STG5271L");
    public static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    public static final String FREE_SPACE = MessageLog.getMessageNoID("STG1184L");
    public static final String SSTYPE = MessageLog.getMessageNoID("SAG0036L");
    public static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    public static final String LUN_CAPACITY = MessageLog.getMessageNoID("STG6059L");
    public static final String UNALLOCATED = MessageLog.getMessageNoID("STG6083L");
    public static final String ALLOCATED = MessageLog.getMessageNoID("STG6084L");
    public static final String LUN_WWN = MessageLog.getMessageNoID("SAG0620L");
    public static final String DISK = MessageLog.getMessageNoID("STG1240L");
    public static final String[] namesArray1a = new String[]{COMPUTER, DISK_ARRAY, SSTYPE, PHYSICAL_ALLOC, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray1b = new String[]{DISK_ARRAY, SSTYPE, COMPUTER, PHYSICAL_ALLOC, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray2a = new String[]{COMPUTER, COMP_LUN_PATH, DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_WWN, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray2b = new String[]{DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_WWN, COMPUTER, COMP_LUN_PATH, LUN_CAPACITY, ALLOCATED, UNALLOCATED};
    public static final String[] namesArray3a = new String[]{COMPUTER, DISK_ARRAY, SSTYPE, DISK, MANUFACTURER, MODEL, SERIAL_NUMBER, PHYSICAL_ALLOC};
    public static final String[] namesArray3b = new String[]{DISK_ARRAY, SSTYPE, DISK, MANUFACTURER, MODEL, SERIAL_NUMBER, COMPUTER, PHYSICAL_ALLOC};
    public static final String[] namesArray4a = new String[]{COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, DISK_ARRAY, SSTYPE};
    public static final String[] namesArray4b = new String[]{DISK_ARRAY, SSTYPE, COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE};
    public static final String[] namesArray5a = new String[]{COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, COMP_LUN_PATH, DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_CAPACITY, LUN_WWN};
    public static final String[] namesArray5b = new String[]{DISK_ARRAY, SSTYPE, ARRAY_SIDE_PATH, LUN_CAPACITY, LUN_WWN, COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, COMP_LUN_PATH};
    public static final String[] namesArray6a = new String[]{COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, DISK_ARRAY, SSTYPE, MANUFACTURER, MODEL, SERIAL_NUMBER, PHYSICAL_ALLOC};
    public static final String[] namesArray6b = new String[]{DISK_ARRAY, SSTYPE, DISK, MANUFACTURER, MODEL, SERIAL_NUMBER, COMPUTER, LVFS_PATH, CAPACITY, FREE_SPACE, PHYSICAL_ALLOC};
    public String[] namesArray;
    public final int COMPUTER_COL;
    public final int DISK_ARRAY_COL;
    public final int SS_TYPE_COL;
    public final int LVFS_PATH_COL;
    public final int ARRAY_SIDE_PATH_COL;
    public final int COMP_LUN_PATH_COL;
    public final int MANUFACTURER_COL;
    public final int MODEL_COL;
    public final int SERIAL_NUMBER_COL;
    public final int PHYSICAL_ALLOC_COL;
    public final int CAPACITY_COL;
    public final int FREE_SPACE_COL;
    public final int LUN_ALLOCATED_COL;
    public final int LUN_CAPACITY_COL;
    public final int LUN_WWN_COL;
    public final int DISK_COL;
    public GuiReportReq grr;
    public RespEndToEnd[] endArray;
    public RespEndToEnd endNode;
    private int[] rendererArray;
    private MutableLong[] mLong;
    private boolean computerFirst = false;
    private boolean batch = false;
    private boolean checkDups = false;
    private boolean checkLUNDups = false;
    private int rows;
    public int frozenRows = 0;

    public EndToEndAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        if (grr.bySubtype <= 0) {
            grr.bySubtype = grr.reportSubtype == 12 || grr.reportSubtype == 73 ? 75 : 12;
        }
        if (grr.reportSubtype == 12 && grr.bySubtype == 74) {
            this.namesArray = namesArray1a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 1;
            this.SS_TYPE_COL = 2;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = 3;
            this.CAPACITY_COL = 4;
            this.FREE_SPACE_COL = 6;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 5;
            this.DISK_COL = -777;
            this.computerFirst = true;
        } else if (grr.reportSubtype == 74 && grr.bySubtype == 12) {
            this.namesArray = namesArray1b;
            this.COMPUTER_COL = 2;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = 3;
            this.CAPACITY_COL = 4;
            this.FREE_SPACE_COL = 6;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 5;
            this.DISK_COL = -777;
        } else if (grr.reportSubtype == 12 && grr.bySubtype == 75) {
            this.namesArray = namesArray2a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 2;
            this.SS_TYPE_COL = 3;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = 4;
            this.LUN_WWN_COL = 5;
            this.COMP_LUN_PATH_COL = 1;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 6;
            this.FREE_SPACE_COL = 8;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 7;
            this.DISK_COL = -777;
            this.computerFirst = true;
        } else if (grr.reportSubtype == 75 && grr.bySubtype == 12) {
            this.namesArray = namesArray2b;
            this.COMPUTER_COL = 4;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = 2;
            this.LUN_WWN_COL = 3;
            this.COMP_LUN_PATH_COL = 5;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 6;
            this.FREE_SPACE_COL = 8;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = 7;
            this.DISK_COL = -777;
        } else if (grr.reportSubtype == 12 && grr.bySubtype == 76) {
            this.namesArray = namesArray3a;
            this.COMPUTER_COL = 0;
            this.DISK_COL = 3;
            this.DISK_ARRAY_COL = 1;
            this.SS_TYPE_COL = 2;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = 4;
            this.MODEL_COL = 5;
            this.SERIAL_NUMBER_COL = 6;
            this.PHYSICAL_ALLOC_COL = 7;
            this.CAPACITY_COL = -777;
            this.FREE_SPACE_COL = -777;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.computerFirst = true;
        } else if (grr.reportSubtype == 76 && grr.bySubtype == 12) {
            this.namesArray = namesArray3b;
            this.COMPUTER_COL = 6;
            this.DISK_ARRAY_COL = 0;
            this.DISK_COL = 2;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = -777;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = 3;
            this.MODEL_COL = 4;
            this.SERIAL_NUMBER_COL = 5;
            this.PHYSICAL_ALLOC_COL = 7;
            this.CAPACITY_COL = -777;
            this.FREE_SPACE_COL = -777;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
        } else if (grr.reportSubtype == 73 && grr.bySubtype == 74) {
            this.namesArray = namesArray4a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 4;
            this.SS_TYPE_COL = 5;
            this.LVFS_PATH_COL = 1;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 2;
            this.FREE_SPACE_COL = 3;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.checkDups = true;
            this.computerFirst = true;
        } else if (grr.reportSubtype == 74 && grr.bySubtype == 73) {
            this.namesArray = namesArray4b;
            this.COMPUTER_COL = 2;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = 3;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 4;
            this.FREE_SPACE_COL = 5;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.checkDups = true;
        } else if (grr.reportSubtype == 73 && grr.bySubtype == 75) {
            this.namesArray = namesArray5a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 5;
            this.SS_TYPE_COL = 6;
            this.LVFS_PATH_COL = 1;
            this.ARRAY_SIDE_PATH_COL = 7;
            this.LUN_WWN_COL = 9;
            this.COMP_LUN_PATH_COL = 4;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 2;
            this.FREE_SPACE_COL = 3;
            this.LUN_CAPACITY_COL = 8;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.computerFirst = true;
            this.checkDups = true;
            this.checkLUNDups = true;
        } else if (grr.reportSubtype == 75 && grr.bySubtype == 73) {
            this.namesArray = namesArray5b;
            this.COMPUTER_COL = 5;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = 6;
            this.ARRAY_SIDE_PATH_COL = 2;
            this.LUN_WWN_COL = 4;
            this.COMP_LUN_PATH_COL = 9;
            this.MANUFACTURER_COL = -777;
            this.MODEL_COL = -777;
            this.SERIAL_NUMBER_COL = -777;
            this.PHYSICAL_ALLOC_COL = -777;
            this.CAPACITY_COL = 7;
            this.FREE_SPACE_COL = 8;
            this.LUN_CAPACITY_COL = 3;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.checkDups = true;
            this.checkLUNDups = true;
        } else if (grr.reportSubtype == 73 && grr.bySubtype == 76) {
            this.namesArray = namesArray6a;
            this.COMPUTER_COL = 0;
            this.DISK_ARRAY_COL = 4;
            this.SS_TYPE_COL = 5;
            this.LVFS_PATH_COL = 1;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.MANUFACTURER_COL = 6;
            this.MODEL_COL = 7;
            this.SERIAL_NUMBER_COL = 8;
            this.PHYSICAL_ALLOC_COL = 9;
            this.CAPACITY_COL = 2;
            this.FREE_SPACE_COL = 3;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.DISK_COL = -777;
            this.computerFirst = true;
            this.checkDups = true;
        } else {
            this.namesArray = namesArray6b;
            this.COMPUTER_COL = 6;
            this.DISK_ARRAY_COL = 0;
            this.SS_TYPE_COL = 1;
            this.LVFS_PATH_COL = 7;
            this.ARRAY_SIDE_PATH_COL = -777;
            this.LUN_WWN_COL = -777;
            this.COMP_LUN_PATH_COL = -777;
            this.DISK_COL = 2;
            this.MANUFACTURER_COL = 3;
            this.MODEL_COL = 4;
            this.SERIAL_NUMBER_COL = 5;
            this.PHYSICAL_ALLOC_COL = 10;
            this.CAPACITY_COL = 8;
            this.FREE_SPACE_COL = 9;
            this.LUN_CAPACITY_COL = -777;
            this.LUN_ALLOCATED_COL = -777;
            this.checkDups = true;
        }
        this.rendererArray = new int[this.namesArray.length];
        if (this.PHYSICAL_ALLOC_COL >= 0) {
            this.rendererArray[this.PHYSICAL_ALLOC_COL] = 7;
        }
        if (this.CAPACITY_COL >= 0) {
            this.rendererArray[this.CAPACITY_COL] = 7;
        }
        if (this.FREE_SPACE_COL >= 0) {
            this.rendererArray[this.FREE_SPACE_COL] = 7;
        }
        if (this.LUN_CAPACITY_COL >= 0) {
            this.rendererArray[this.LUN_CAPACITY_COL] = 7;
        }
        if (this.LUN_ALLOCATED_COL >= 0) {
            this.rendererArray[this.LUN_ALLOCATED_COL] = 7;
        }
        this.frozenColumns = 1;
        this.namesArray = this.getCustomizedColNames(this.namesArray);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        if (this.computerFirst) {
            Arrays.sort(this.endArray, this.frozenRows, this.endArray.length, new ComputerSorter());
        } else {
            Arrays.sort(this.endArray, this.frozenRows, this.endArray.length, new DiskArraySorter());
        }
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.endArray = (RespEndToEnd[])dataArray;
        this.rows = this.endArray.length;
        if (this.rows > 1) {
            this.addTotal();
        }
        if (this.mLong == null) {
            this.mLong = new MutableLong[this.rows];
        }
        for (int i = 0; i < this.rows; ++i) {
            this.mLong[i] = new MutableLong();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rows; ++i) {
            this.endNode = this.endArray[i];
            this.endNode.reePhysicalAlloc *= 512L;
            this.endNode.reeCapacity *= 512L;
            this.endNode.reeLUNCapacity *= 512L;
            this.endNode.reeFreeSpace *= 512L;
        }
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        ColumnDescriptor col = colArray[this.SS_TYPE_COL];
        col.cdValidValue = ColumnDescriptor.SS_TYPES;
    }

    public void replaceArray(Object dataArray) {
        this.endArray = (RespEndToEnd[])dataArray;
    }

    public Object getArray() {
        return this.endArray;
    }

    public int getNumberRows() {
        return this.endArray.length;
    }

    public int getNumberColumns() {
        return this.namesArray.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getCellData(int rowNum, int colNum) {
        Object data;
        if (colNum == this.COMPUTER_COL) {
            data = this.endArray[rowNum].reeComputer;
        } else if (colNum == this.DISK_ARRAY_COL) {
            data = this.endArray[rowNum].reeDiskArray;
        } else if (colNum == this.SS_TYPE_COL) {
            data = this.endArray[rowNum].reeOSType > 0 ? (this.endArray[rowNum].reeManufacturer != null && this.endArray[rowNum].reeManufacturer.length() > 0 ? (this.endArray[rowNum].reeManufacturer.toUpperCase().indexOf("HEWLETT") >= 0 || this.endArray[rowNum].reeManufacturer.toUpperCase().indexOf("HP") >= 0 ? MessageLog.getMessageNoID(Constants.OSTYPES[18]) : MessageLog.getMessageNoID(Constants.OSTYPES[this.endArray[rowNum].reeOSType])) : MessageLog.getMessageNoID(Constants.OSTYPES[this.endArray[rowNum].reeOSType])) : " ";
        } else if (colNum == this.LVFS_PATH_COL) {
            data = this.endArray[rowNum].reeLVFSPath;
        } else if (colNum == this.ARRAY_SIDE_PATH_COL) {
            if (this.endArray[rowNum].reeArraySidePath == null) {
                data = UNKNOWN;
            } else {
                int index;
                data = this.endArray[rowNum].reeArraySidePath;
                if (this.endArray[rowNum].reeOSType == 21 && (index = ((String)data).indexOf(":")) > 0) {
                    data = ((String)data).substring(0, index);
                }
                if (this.endArray[rowNum].reeOSType == 12) {
                    data = data.toString().substring(1);
                }
            }
        } else if (colNum == this.LUN_WWN_COL) {
            data = this.endArray[rowNum].reeLUNWWN == null ? UNKNOWN : this.endArray[rowNum].reeLUNWWN;
        } else if (colNum == this.COMP_LUN_PATH_COL) {
            data = this.endArray[rowNum].reeCompLUNPath;
        } else if (colNum == this.MANUFACTURER_COL) {
            data = Util.isEmpty(this.endArray[rowNum].reeManufacturer) ? UNKNOWN : this.endArray[rowNum].reeManufacturer;
        } else if (colNum == this.MODEL_COL) {
            data = Util.isEmpty(this.endArray[rowNum].reeModel) ? UNKNOWN : this.endArray[rowNum].reeModel;
        } else if (colNum == this.SERIAL_NUMBER_COL) {
            data = Util.isEmpty(this.endArray[rowNum].reeSerialNumber) ? UNKNOWN : this.endArray[rowNum].reeSerialNumber;
        } else if (colNum == this.PHYSICAL_ALLOC_COL) {
            this.mLong[rowNum].value = this.endArray[rowNum].reePhysicalAlloc;
            data = this.mLong[rowNum];
        } else if (colNum == this.CAPACITY_COL) {
            this.mLong[rowNum].value = this.endArray[rowNum].reeCapacity;
            data = this.mLong[rowNum];
        } else if (colNum == this.FREE_SPACE_COL) {
            this.mLong[rowNum].value = this.endArray[rowNum].reeFreeSpace;
            data = this.mLong[rowNum];
        } else if (colNum == this.LUN_CAPACITY_COL) {
            this.mLong[rowNum].value = this.endArray[rowNum].reeLUNCapacity;
            data = this.mLong[rowNum];
        } else if (colNum == this.LUN_ALLOCATED_COL) {
            this.mLong[rowNum].value = this.endArray[rowNum].reeFreeSpace < 0L ? -1L : this.endArray[rowNum].reeCapacity - this.endArray[rowNum].reeFreeSpace;
            data = this.mLong[rowNum];
        } else {
            data = colNum == this.DISK_COL ? this.endArray[rowNum].reeArraySidePath : null;
        }
        return data;
    }

    private void addTotal() {
        StringBuffer buf;
        HashMap<String, String> lunDupMap;
        boolean skipLV = false;
        boolean skipLUN = false;
        HashMap<MutableInteger, MutableInteger> dupMap = this.checkDups ? new HashMap<MutableInteger, MutableInteger>() : null;
        if (this.checkLUNDups) {
            lunDupMap = new HashMap<String, String>();
            buf = new StringBuffer(100);
        } else {
            lunDupMap = null;
            buf = null;
        }
        this.bHasTotalRow = true;
        RespEndToEnd[] plusArray = new RespEndToEnd[this.rows + 1];
        plusArray[0] = this.endNode = new RespEndToEnd();
        if (this.computerFirst) {
            this.endNode.reeComputer = MessageLog.getMessageNoID("STG4136L");
            this.endNode.reeDiskArray = " ";
        } else {
            this.endNode.reeComputer = " ";
            this.endNode.reeDiskArray = MessageLog.getMessageNoID("STG4136L");
        }
        this.endNode.reeLVFSPath = " ";
        this.endNode.reeArraySidePath = " ";
        this.endNode.reeCompLUNPath = " ";
        this.endNode.reeManufacturer = "  ";
        this.endNode.reeModel = "  ";
        this.endNode.reeSerialNumber = "  ";
        this.endNode.reeLUNWWN = "  ";
        this.endNode.reeOSType = (short)-1;
        for (int ix = 0; ix < this.rows; ++ix) {
            if (this.checkDups) {
                int id = (int)this.endArray[ix].reeFilesystemID;
                if (id <= 0) {
                    id = this.endArray[ix].reeLogicalDiskID;
                }
                if (id <= 0) {
                    skipLV = true;
                } else {
                    skipLV = false;
                    MutableInteger ml = new MutableInteger(id);
                    Object o = dupMap.get(ml);
                    if (o != null) {
                        skipLV = true;
                    } else {
                        dupMap.put(ml, ml);
                    }
                }
            }
            if (this.checkLUNDups) {
                skipLUN = false;
                buf.setLength(0);
                buf.append(this.endArray[ix].reeDiskArray);
                buf.append(this.endArray[ix].reeArraySidePath);
                String lunName = buf.toString();
                Object o = lunDupMap.get(lunName);
                if (o != null) {
                    skipLUN = true;
                } else {
                    lunDupMap.put(lunName, lunName);
                }
            }
            if (this.endArray[ix].reePhysicalAlloc > 0L) {
                this.endNode.reePhysicalAlloc += this.endArray[ix].reePhysicalAlloc;
            }
            if (!skipLV) {
                if (this.endArray[ix].reeCapacity > 0L) {
                    this.endNode.reeCapacity += this.endArray[ix].reeCapacity;
                }
                if (this.endArray[ix].reeFreeSpace > 0L) {
                    this.endNode.reeFreeSpace += this.endArray[ix].reeFreeSpace;
                }
            }
            if (!skipLUN) {
                this.endNode.reeLUNCapacity += this.endArray[ix].reeLUNCapacity;
            }
            plusArray[ix + 1] = this.endArray[ix];
        }
        this.endArray = plusArray;
        this.frozenRows = 1;
        ++this.rows;
    }

    private class DiskArraySorter
    implements Comparator {
        private DiskArraySorter() {
        }

        public int compare(Object o1, Object o2) {
            RespEndToEnd r1 = (RespEndToEnd)o1;
            RespEndToEnd r2 = (RespEndToEnd)o2;
            return r1.reeDiskArray.compareTo(r2.reeDiskArray);
        }
    }

    private class ComputerSorter
    implements Comparator {
        private ComputerSorter() {
        }

        public int compare(Object o1, Object o2) {
            RespEndToEnd r1 = (RespEndToEnd)o1;
            RespEndToEnd r2 = (RespEndToEnd)o2;
            return r1.reeComputer.compareTo(r2.reeComputer);
        }
    }
}

