/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.San.common.EndToEndAdjuster;
import org.eclipse.aperi.San.common.EndToEndGrapher;
import org.eclipse.aperi.San.server.guireq.RespEndToEnd;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class EndToEndTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
TJCTableMouseInterface,
AskForRowIconInterface,
ActionListener,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespEndToEnd[] data;
    private EndToEndAdjuster adjuster;
    private EndToEndGrapher grapher;
    private boolean hasHistory;

    public EndToEndTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        this.hasHistory = grr.reportSubtype == 73 || grr.bySubtype == 73;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.setLayout(new BorderLayout());
        this.adjuster = new EndToEndAdjuster(grr);
        this.grapher = new EndToEndGrapher();
    }

    public void handleResponse(short status, Response response) {
        this.data = status <= 4 ? (RespEndToEnd[])response.responseData : null;
        int cnt = this.data != null ? this.data.length : 0;
        if (cnt == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespEndToEnd[])this.adjuster.getArray();
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        if (this.hasHistory) {
            this.table.setRowIcon(13, false);
        }
        this.table.setMouseListener(this);
        this.table.iconChanger = this;
        if (this.adjuster.frozenRows > 0) {
            this.table.setFrozenRows(this.adjuster.frozenRows);
            this.table.setFrozenRowBackground(Color.yellow);
        }
        if (this.adjuster.frozenColumns > 0) {
            this.table.setFrozenColumns(this.adjuster.frozenColumns);
        }
        this.table.setBaseTableModel(new EndToEndModel());
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart && this.hasHistory) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public boolean select(int viewRow, int viewCol) {
        boolean result;
        if (!this.hasHistory) {
            result = false;
        } else {
            int row = this.table.getDataRow(viewRow);
            result = this.data[row].reeFilesystemID > 0L;
        }
        return result;
    }

    public void selectionChanged(boolean state) {
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (this.hasHistory) {
            boolean enabled = this.table.rowsSelected();
            JPopupMenu menu = new JPopupMenu();
            JMenuItem mi = menu.add(MessageLog.getMessageNoID("STG5105L"));
            mi.setActionCommand("STG5105L");
            mi.setEnabled(enabled);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5107L"));
            mi.setActionCommand("STG5107L");
            mi.setEnabled(enabled);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5109L"));
            mi.setActionCommand("STG5109L");
            mi.setEnabled(enabled);
            mi.addActionListener(this);
            menu.show(c, x, y);
            menu.requestFocus();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        EndToEndTable result = this.hasHistory ? this : null;
        return result;
    }

    public void doubleClick(int dataRow, int dataCol) {
        this.showDefaultChart(dataRow);
    }

    public void showDefaultChart(int dataRow) {
        if (!this.changeIcon(dataRow)) {
            int[] rows = new int[]{dataRow};
            this.createHistory("STG5105L", rows);
        }
    }

    public void showJumpChart() {
        int[] rows = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            rows[i] = this.table.getDataRow(i);
        }
        this.createHistory("STG5105L", rows);
    }

    public void actionPerformed(ActionEvent event) {
        this.createHistory(event.getActionCommand(), this.table.getSelectedRows());
    }

    private void createHistory(String actionCommand, int[] rows) {
        if (rows.length > 0) {
            GuiReportReq newGrr = this.grapher.createHistory(this.grr, this.data, rows, actionCommand);
            this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", newGrr, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(newGrr.historyTitle), this);
        }
    }

    public boolean changeIcon(int dataRow) {
        return !this.hasHistory || this.data[dataRow].reeFilesystemID <= 0L;
    }

    public EndToEndTable(String a, String b, String c, String d) {
    }

    public Object[] getChoices(int reportType, int reportSubtype) {
        Object[] array = null;
        if (reportSubtype == 73 || reportSubtype == 74) {
            array = new Object[3];
            String[] messageArray = new String[]{"STG5105L", "STG5107L", "STG5109L"};
            byte[] labelArray = new byte[]{1, 1, 1};
            byte[] reportArray = new byte[]{1, 3, 5};
            array[0] = messageArray;
            array[1] = labelArray;
            array[2] = reportArray;
        }
        return array;
    }

    public Object[] getCharts(int reportType, int reportSubtype) {
        return null;
    }

    public int[] getGraphID(String selectedCommand) {
        return null;
    }

    private class EndToEndModel
    extends BaseTableModel {
        public EndToEndModel() {
            this.columnNames = ((EndToEndTable)EndToEndTable.this).adjuster.namesArray;
            this.rowCount = EndToEndTable.this.data.length;
            this.commonAdjuster = EndToEndTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return EndToEndTable.this.adjuster.getCellData(row, EndToEndTable.this.adjuster.translateColumn(col));
        }
    }
}

