/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.San.gui.DiskArrayData;
import org.eclipse.aperi.San.gui.HostPathTable;
import org.eclipse.aperi.San.gui.LogicalUnitDDI;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeData;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LUNData
implements GuiRequestor,
ChangeListener {
    private static String MB = MessageLog.getMessageNoID("GEN0189T");
    private LogicalUnitDDI ddi;
    private NameList computer;
    private int lunID;
    private JTabbedPane tabs;

    public LUNData(int pLUNID, NameList pComputer, LogicalUnitDDI pDDI) {
        this.lunID = pLUNID;
        this.computer = pComputer;
        this.ddi = pDDI;
    }

    public JComponent getComponent() {
        if (this.tabs == null) {
            Request request = GuiRequest.makeLogicalUnitRequest(this.computer.nlID, this.lunID);
            GuiClient.doRequest(this, request);
            this.tabs = new JTabbedPane();
        }
        return this.tabs;
    }

    private static void addAttribute(Container panel, GridBagConstraints c, String msgID, String optionalParm) {
        Object[] parms = optionalParm == null ? null : new Object[]{optionalParm};
        String s = MessageLog.getMessageNoID(msgID, parms);
        LUNData.addAttributeX(panel, c, s);
    }

    private static void addAttributeX(Container panel, GridBagConstraints c, String attribute) {
        JLabel label = new JLabel(attribute);
        label.setForeground(Color.black);
        label.setFont(BaseTree.plainFont);
        panel.add((Component)label, c);
    }

    private Component makeTopPanel(LogicalDisk ld) {
        byte replicationMode;
        String msgID;
        String ldType;
        String lunName;
        boolean isCKD = false;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.left = 40;
        c.insets.top = 30;
        c.anchor = 17;
        if (this.computer.nlID2 == 21) {
            lunName = ld.ldPath;
            int index = ld.ldPath.indexOf(":");
            if (index > 0) {
                lunName = ld.ldPath.substring(0, index);
            }
            DiskArrayData.addItem(panel, c, "SAG0077L", lunName);
            c.insets.top = 0;
            c.insets.bottom = 12;
            DiskArrayData.addItem(panel, c, "STG4500L", this.computer.nlName);
            c.insets.bottom = 0;
            DiskArrayData.addItem(panel, c, "STG1162L", Util.formatBytes(ld.ldCapacity * 512L));
            DiskArrayData.addItem(panel, c, "STG6054L", Util.formatBytes(ld.ldOverhead * 512L));
            ldType = LogicalDisk.VDISK_TYPES[ld.ldType];
        } else {
            if (this.computer.nlID2 == 15 || this.computer.nlID2 == 18) {
                DiskArrayData.addItem(panel, c, "SAG0514L", ld.ldName);
                c.insets.top = 0;
                DiskArrayData.addItem(panel, c, "SAG0619L", ld.ldPath);
            } else if (this.computer.nlID2 == 12 || this.computer.nlID2 == 25 || this.computer.nlID2 == 27) {
                lunName = ld.ldPath;
                if (this.computer.nlID2 == 12 && lunName.startsWith("0")) {
                    isCKD = true;
                }
                if (this.computer.nlID2 == 25 || this.computer.nlID2 == 27) {
                    isCKD = LogicalDisk.isCKD(ld.ldStorageType);
                    lunName = !Util.isEmpty(lunName) ? lunName + " (" + ld.ldDeviceId + ")" : "(" + ld.ldDeviceId + ")";
                }
                DiskArrayData.addItem(panel, c, "SAG0514L", lunName);
            } else if (this.computer.nlID2 == 14) {
                DiskArrayData.addItem(panel, c, "SAG0514L", ld.ldName);
            } else {
                DiskArrayData.addItem(panel, c, "SAG0514L", ld.ldPath);
            }
            c.insets.top = 0;
            c.insets.bottom = 12;
            DiskArrayData.addItem(panel, c, "STG4201L", this.computer.nlName);
            c.insets.bottom = 0;
            DiskArrayData.addItem(panel, c, "STG1162L", Util.formatBytes(ld.ldCapacity << 9));
            DiskArrayData.addItem(panel, c, "STG6054L", Util.formatBytes(ld.ldOverhead << 9));
            ldType = LogicalDisk.TYPES[ld.ldType];
        }
        c.insets.bottom = 12;
        DiskArrayData.addItem(panel, c, "STG1132L", ldType);
        if (ld.ldRaid != -1) {
            DiskArrayData.addItem(panel, c, "STG7568L", VolGroup.CONFIGS[ld.ldRaid]);
        }
        c.insets.bottom = 0;
        String s = MessageLog.getMessageNoID("STG3257L");
        JLabel label = new JLabel(s);
        label.setForeground(Color.black);
        label.setFont(BaseTree.boldFont);
        c.gridwidth = 0;
        panel.add((Component)label, c);
        c.insets.left = 60;
        if (ld.isSnapshot()) {
            String parm = ld.ldSnapSource != null ? ld.ldSnapSource.ldPath : null;
            msgID = parm != null ? "SAG0013L" : "SAG0012L";
            LUNData.addAttribute(panel, c, msgID, parm);
        }
        if (ld.isVCMDB()) {
            LUNData.addAttribute(panel, c, "SAG0014L", null);
        }
        if ((replicationMode = ld.getReplicationMode()) != 0) {
            msgID = replicationMode == 1 ? "SAG0015L" : "SAG0016L";
            LUNData.addAttribute(panel, c, msgID, null);
        }
        if (ld.notExposed()) {
            LUNData.addAttribute(panel, c, "SAG0017L", null);
        } else {
            LUNData.addAttribute(panel, c, "SAG0201L", null);
        }
        if (isCKD) {
            LUNData.addAttributeX(panel, c, "CKD");
        }
        panel.add(Box.createVerticalStrut(14), c);
        GuiUtil.completePanel(panel);
        return panel;
    }

    public void handleResponse(short status, Response response) {
        JPanel container;
        boolean isEnabled;
        if (status > 4) {
            return;
        }
        LogicalDisk ld = (LogicalDisk)response.responseData;
        Component topPanel = this.makeTopPanel(ld);
        JPanel mainTab = new JPanel(new BorderLayout());
        mainTab.add(topPanel, "North");
        mainTab.add((Component)LogicalVolumeData.getLvTree(ld, (short)this.computer.nlID2), "Center");
        String s = MessageLog.getMessageNoID("STG5275L");
        this.tabs.addTab(s, mainTab);
        boolean bl = isEnabled = ld.ldHostPaths != null;
        if (isEnabled) {
            container = new HostPathTable(ld.ldHostPaths);
        } else {
            s = MessageLog.getMessageNoID("STG0020M");
            JLabel label = new JLabel(s);
            label.setForeground(Color.black);
            label.setFont(BaseTree.boldFont);
            container = new JPanel(new GridBagLayout());
            container.add((Component)label, new GridBagConstraints());
        }
        s = MessageLog.getMessageNoID("SAG0019L");
        this.tabs.addTab(s, container);
        this.tabs.setEnabledAt(1, isEnabled);
        this.tabs.setSelectedIndex(this.ddi.tabIndex);
        this.tabs.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent event) {
        this.ddi.tabIndex = this.tabs.getSelectedIndex();
    }
}

