/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.San.common.LunWWNAdjuster;
import org.eclipse.aperi.San.gui.LogicalUnitDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class LunWWNTable
extends JPanel
implements GuiRequestor {
    private MegaTable lunWWNTable = new MegaTable();
    private GuiReportReq grr;
    private Lun[] lunArray;
    private LunWWNAdjuster adjuster;
    private ReportingDDI ddi;

    public LunWWNTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new LunWWNAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        if (status <= 4) {
            this.lunArray = (Lun[])response.responseData;
        }
        int cnt = 0;
        if (this.lunArray != null) {
            cnt = this.lunArray.length;
        }
        if (cnt == 0) {
            if (this.ddi != null) {
                this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            } else {
                this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            }
            return;
        }
        this.adjuster.adjust(this.lunArray, false);
        this.lunArray = (Lun[])this.adjuster.getArray();
        this.lunWWNTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.lunWWNTable.setMouseListener(new SelectionListener());
        this.lunWWNTable.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.lunWWNTable.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.lunWWNTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.lunWWNTable.setRowIcon(10, true);
        if (this.adjuster.frozenRows > 0) {
            this.lunWWNTable.setFrozenRows(this.adjuster.frozenRows);
        }
        this.lunWWNTable.setBaseTableModel(new LunWWNTableModel());
        this.lunWWNTable.setAsFirstColumn(this.adjuster.getFirstColumn());
        this.add((Component)this.lunWWNTable, "Center");
        if (this.ddi != null) {
            this.ddi.addRowCount(this.adjuster);
        }
    }

    public class SelectionListener
    extends TJCTableMouseAdapter {
        public boolean select(int viewRow, int viewCol) {
            return viewRow >= ((LunWWNTable)LunWWNTable.this).adjuster.frozenRows;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if (dataRow >= ((LunWWNTable)LunWWNTable.this).adjuster.frozenRows) {
                Lun lun = LunWWNTable.this.lunArray[dataRow];
                NameList subsystem = new NameList();
                subsystem.nlID = lun.lunDaID;
                subsystem.nlName = lun.lunDaAlias;
                subsystem.nlID2 = lun.lunOSType;
                new LogicalUnitDDI(null, lun.lunID, subsystem, lun.lunName);
            }
        }
    }

    private class LunWWNTableModel
    extends BaseTableModel {
        LunWWNTableModel() {
            this.columnNames = ((LunWWNTable)LunWWNTable.this).adjuster.colNames;
            this.rowCount = LunWWNTable.this.lunArray.length;
            this.commonAdjuster = LunWWNTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return LunWWNTable.this.adjuster.getCellData(row, LunWWNTable.this.adjuster.translateColumn(col));
        }
    }
}

