/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class CustomReportDataAdjuster
extends ReportDataAdjuster {
    protected int[] translateTable;
    protected int[] standardHiddenColumns;
    protected int standardFrozenColumns;
    protected int standardFirstColumn;
    protected String[] standardColNames;
    public int[] hiddenColumns;
    public int frozenColumns;
    public int firstColumn;
    public boolean bHasTotalRow = false;
    public static final String NA = MessageLog.getMessageNoID("GEN0185T");

    public CustomReportDataAdjuster(GuiReportReq grr) {
        this.translateTable = grr.selectedColumns;
    }

    public abstract void adjustInit(Object[] var1, boolean var2);

    public abstract void adjustData();

    public boolean[] getSpannedColumns(String[] colNames) {
        boolean[] spannedColumns = new boolean[colNames.length];
        for (int i = 1; i < colNames.length; ++i) {
            if (colNames[i].length() != 0) continue;
            spannedColumns[i - 1] = true;
        }
        return spannedColumns;
    }

    public ColumnDescriptor getColumnDescriptors() {
        int colCount = this.standardColNames.length;
        int labelRowCount = this.getNumberFrozenRows();
        boolean inSpannedColumn = false;
        ColumnDescriptor[] colArray = new ColumnDescriptor[colCount];
        boolean[] spannedColumns = this.getSpannedColumns(this.standardColNames);
        int[] renderers = this.getRenderers();
        for (int i = 0; i < colCount; ++i) {
            ColumnDescriptor col;
            colArray[i] = col = new ColumnDescriptor();
            col.cdID = (short)i;
            col.cdIsFrozen = i < this.standardFrozenColumns;
            switch (renderers[i]) {
                case 4: 
                case 7: 
                case 8: {
                    col.cdDataType = (short)5;
                    break;
                }
                case 2: {
                    int scale = this.getScale();
                    while ((scale /= 10) > 0) {
                        col.cdScale = (byte)(col.cdScale + 1);
                    }
                }
                case 5: 
                case 6: 
                case 9: {
                    col.cdDataType = (short)2;
                    break;
                }
                case 1: {
                    col.cdDataType = (short)3;
                    break;
                }
                case 3: {
                    col.cdDataType = (short)4;
                    break;
                }
                case 10: {
                    col.cdDataType = (short)2;
                    break;
                }
                default: {
                    col.cdDataType = 1;
                }
            }
            if (spannedColumns[i]) {
                inSpannedColumn = true;
                col.cdShortName = this.makeColName(i, labelRowCount - 1);
                col.cdReportName = col.cdShortName + ": " + this.getCellData(labelRowCount - 1, i);
                continue;
            }
            if (inSpannedColumn) {
                inSpannedColumn = false;
                ColumnDescriptor spannedCol = colArray[i - 1];
                col.cdShortName = spannedCol.cdShortName;
                col.cdReportName = col.cdShortName + ": " + this.getCellData(labelRowCount - 1, i);
                spannedCol.cdTwin = col;
                col.cdTwin = spannedCol;
                continue;
            }
            col.cdReportName = col.cdShortName = this.makeColName(i, labelRowCount);
        }
        this.addValidValues(colArray);
        return this.makeColumnList(colArray);
    }

    protected String[] getCustomizedColNames(String[] colNames) {
        this.standardHiddenColumns = this.hiddenColumns;
        this.standardFrozenColumns = this.frozenColumns;
        this.standardFirstColumn = this.firstColumn;
        this.standardColNames = colNames;
        String[] customColNames = colNames;
        if (this.translateTable != null) {
            customColNames = new String[this.translateTable.length];
            for (int i = 0; i < this.translateTable.length; ++i) {
                customColNames[i] = colNames[this.translateTable[i]];
            }
            if (this.frozenColumns > 0 && this.hiddenColumns != null) {
                this.frozenColumns -= this.hiddenColumns.length;
            }
            this.hiddenColumns = null;
            this.firstColumn = 0;
        }
        return customColNames;
    }

    public int getColumnPosition(int columnID) {
        if (this.translateTable != null) {
            for (int i = 0; i < this.translateTable.length; ++i) {
                if (columnID != this.translateTable[i]) continue;
                return i;
            }
            return -1;
        }
        return columnID;
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
    }

    public void undo() {
    }

    public String[] getLabels() {
        return this.standardColNames;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public boolean columnsAreCustomized() {
        return this.translateTable != null;
    }

    public int translateColumn(int col) {
        return this.translateTable == null ? col : this.translateTable[col];
    }

    public int[] fixColumnArray(int[] columnArray) {
        if (this.translateTable != null) {
            return this.translateTable;
        }
        return super.fixColumnArray(columnArray);
    }

    private String makeColName(int column, int labelRowCount) {
        String colName = this.standardColNames[column];
        for (int i = 0; i < labelRowCount; ++i) {
            String piece = (String)this.getCellData(i, column);
            if (Util.isEmpty(piece)) continue;
            colName = colName + " " + piece;
        }
        return colName;
    }

    private ColumnDescriptor makeColumnList(ColumnDescriptor[] columnArray) {
        if (this.standardFirstColumn > 0) {
            int c = this.standardFirstColumn;
            ColumnDescriptor column = columnArray[this.standardFirstColumn];
            while (c > this.standardFrozenColumns) {
                columnArray[c--] = columnArray[c];
            }
            columnArray[c] = column;
        }
        ColumnDescriptor head = null;
        for (int i = columnArray.length - 1; i >= 0; --i) {
            ColumnDescriptor col = columnArray[i];
            if (this.standardHiddenColumns != null) {
                int j;
                for (j = this.standardHiddenColumns.length - 1; j >= 0 && this.standardHiddenColumns[j] != col.cdID; --j) {
                }
                if (j >= 0) continue;
            }
            col.cdNext = head;
            head = col;
        }
        return head;
    }

    public boolean hasTotalsRow() {
        return this.bHasTotalRow;
    }
}

