/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class EmailAddressFactory {
    private static String rules;
    public static EmailAddressFactory factory;
    public EmailAddressFactory next;
    public boolean substring;
    public short substringStart;
    public short substringEnd;
    public String literal;
    public short sourceType;
    public static final short USERID = 0;
    public static final short LASTNAME = 1;
    public static final short FIRSTNAME = 2;
    public static final short LITERAL = 3;
    public static final String USERNAME_STRING;

    public static synchronized EmailAddressFactory getFactory(Settings settings) throws LocalizableException {
        if (!(factory != null && settings.seEmailAddrRules.equals(rules) || (factory = EmailAddressFactory.parseRules(rules = settings.seEmailAddrRules)) != null)) {
            factory = EmailAddressFactory.makeDefaultFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmailAddressFactory parseRules(String rules) throws LocalizableException {
        StringReader r = new StringReader(rules);
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(r);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(47, 47);
            tokenizer.wordChars(92, 92);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            tokenizer.eolIsSignificant(false);
            tokenizer.slashStarComments(false);
            tokenizer.slashSlashComments(false);
            tokenizer.lowerCaseMode(false);
            EmailAddressFactory emailAddressFactory = EmailAddressFactory.tokenize(tokenizer);
            return emailAddressFactory;
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (Exception e) {}
        }
    }

    public static EmailAddressFactory makeDefaultFactory() {
        return new EmailAddressFactory(0, null, false, 0, 0);
    }

    private static EmailAddressFactory tokenize(StreamTokenizer tokenizer) throws LocalizableException {
        EmailAddressFactory factoryList = null;
        EmailAddressFactory prevFactory = null;
        EmailAddressFactory currFactory = null;
        while (true) {
            if (EmailAddressFactory.nextToken(tokenizer, false, 0) == -1) break;
            if (tokenizer.ttype == -3) {
                if (tokenizer.sval.equalsIgnoreCase("substring") || tokenizer.sval.equals(MessageLog.getMessageNoID("STG6079L"))) {
                    currFactory = EmailAddressFactory.substring(tokenizer);
                } else {
                    short sourceType = EmailAddressFactory.getSourceType(tokenizer.sval);
                    String literalValue = null;
                    if (sourceType == 3) {
                        literalValue = tokenizer.sval;
                    }
                    currFactory = new EmailAddressFactory(sourceType, literalValue, false, 0, 0);
                }
            } else {
                if (tokenizer.ttype == 43) continue;
                EmailAddressFactory.badTokenException(tokenizer);
            }
            if (prevFactory == null) {
                factoryList = currFactory;
            } else {
                prevFactory.next = currFactory;
            }
            prevFactory = currFactory;
        }
        return factoryList;
    }

    private static EmailAddressFactory substring(StreamTokenizer tokenizer) throws LocalizableException {
        int end = Short.MAX_VALUE;
        EmailAddressFactory.nextToken(tokenizer, true, 40);
        EmailAddressFactory.nextToken(tokenizer, true, -3);
        short sourceType = EmailAddressFactory.getSourceType(tokenizer.sval);
        if (sourceType == 3) {
            EmailAddressFactory.badTokenException(tokenizer);
        }
        EmailAddressFactory.nextToken(tokenizer, true, 44);
        EmailAddressFactory.nextToken(tokenizer, true, -3);
        int start = EmailAddressFactory.stringToInt(tokenizer);
        EmailAddressFactory.nextToken(tokenizer, true, 0);
        if (tokenizer.ttype == 44) {
            EmailAddressFactory.nextToken(tokenizer, true, -3);
            end = EmailAddressFactory.stringToInt(tokenizer);
            EmailAddressFactory.nextToken(tokenizer, true, 41);
        } else if (tokenizer.ttype != 41) {
            EmailAddressFactory.badTokenException(tokenizer);
        }
        if (start >= end) {
            throw new LocalizableException("STS0071E", null);
        }
        return new EmailAddressFactory(sourceType, null, true, start, end);
    }

    private static short getSourceType(String token) {
        int sourceType = token.equalsIgnoreCase("firstname") || token.equals(MessageLog.getMessageNoID("STG6075L")) ? 2 : (token.equalsIgnoreCase("lastname") || token.equals(MessageLog.getMessageNoID("STG6076L")) ? 1 : (token.equalsIgnoreCase("userid") || token.equals(MessageLog.getMessageNoID("STG6074L")) ? 0 : 3));
        return (short)sourceType;
    }

    private static int nextToken(StreamTokenizer tokenizer, boolean tokenRequired, int expectedTokenType) throws LocalizableException {
        if (tokenizer.ttype != -1) {
            try {
                tokenizer.nextToken();
            }
            catch (IOException e) {
                throw new NestableException("STS0068E", null, e);
            }
        }
        if (tokenizer.ttype == -1) {
            if (tokenRequired) {
                throw new LocalizableException("STS0069E", null);
            }
        } else {
            if (tokenizer.ttype == 34 || tokenizer.ttype == 39) {
                tokenizer.ttype = -3;
            }
            if (expectedTokenType != 0 && expectedTokenType != tokenizer.ttype) {
                EmailAddressFactory.badTokenException(tokenizer);
            }
        }
        return tokenizer.ttype;
    }

    private static int stringToInt(StreamTokenizer tokenizer) throws LocalizableException {
        try {
            return Integer.parseInt(tokenizer.sval);
        }
        catch (NumberFormatException e) {
            EmailAddressFactory.badTokenException(tokenizer);
            return -1;
        }
    }

    private static void badTokenException(StreamTokenizer tokenizer) throws LocalizableException {
        Object[] args = new Object[]{tokenizer.toString()};
        throw new LocalizableException("STS0070E", args);
    }

    private EmailAddressFactory(short sourceType, String literal, boolean substring, int substringStart, int substringEnd) {
        this.sourceType = sourceType;
        this.literal = literal;
        this.substring = substring;
        this.substringStart = (short)substringStart;
        this.substringEnd = (short)substringEnd;
    }

    private void appendSubstring(String source, StringBuffer buffer) {
        if (this.substringStart >= source.length()) {
            return;
        }
        int end = this.substringEnd > source.length() ? source.length() : (int)this.substringEnd;
        for (int i = this.substringStart; i < end; ++i) {
            buffer.append(source.charAt(i));
        }
    }

    static {
        USERNAME_STRING = MessageLog.getMessageNoID("STG6074L");
    }
}

