/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.LogicalVolumeAdjuster;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeGrapher
extends Grapher {
    String title;
    public static final byte CHART_SIZE = 101;
    public static final byte CHART_SIZE_X = 102;
    public static final String GRAPH_SIZE_SEL = "STG1251T";
    public static final String GRAPH_SIZE = "STG7528L";
    public static final String GRAPH_SIZE_ALL = "STG1276T";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String USED_HIST = "STG5107L";
    public static final String USED_PERCENT_HIST = "STG5108L";
    public static final String FREE_HIST_ALL = "STG7530L";
    public static final String FREE_PCT_HIST_ALL = "STG7531L";
    public static final String USED_HIST_ALL = "STG7537L";
    public static final String USED_PCT_HIST_ALL = "STG7538L";

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        if (grr.chartSubtype > 0) {
            return null;
        }
        this.title = grr.histSubtype == 1 ? FREE_HIST : (grr.histSubtype == 2 ? FREE_PERCENT_HIST : (grr.histSubtype == 3 ? USED_HIST : USED_PERCENT_HIST));
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        AperiChart chart = null;
        if (grr.chartSubtype > 0) {
            chart = this.createChart(grr, pData, rows, pAdjuster, null, gcsr);
        } else {
            GuiReportReq newGrr = this.createHistory(grr, pData, rows, this.title);
            chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        }
        return chart;
    }

    public AperiCustomizableChart createChart(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, ReportingDDI ddi, GuiChartSettingsReq gcsr) {
        Share[] data = (Share[])pData;
        LogicalVolumeAdjuster adjuster = (LogicalVolumeAdjuster)pAdjuster;
        int rowCount = 0;
        for (int c = 0; c < rows.length; ++c) {
            if (data[rows[c]].shFilesystem.fsID <= 0) continue;
            ++rowCount;
        }
        Number[][] chartY = new Number[2][rowCount];
        String[] pointL = new String[rowCount];
        String[] seriesL = new String[2];
        seriesL[0] = LogicalVolumeAdjuster.USED;
        seriesL[1] = LogicalVolumeAdjuster.FREE;
        rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            Share dataRow = data[rows[i]];
            if (dataRow.shFilesystem.fsID <= 0) continue;
            chartY[0][i] = new Long(dataRow.shFilesystem.fsUsedSpace);
            chartY[1][i] = new Long(dataRow.shFilesystem.fsFreeSpace);
            pointL[i] = dataRow.shComputerName + " - " + dataRow.shFilesystem.fsMountPoint;
        }
        AperiCustomizableChart chart = new AperiCustomizableChart(1, 7, chartY, seriesL, pointL, new ChartOptions(), grr);
        if (ddi != null) {
            ddi.addChart(grr, chart, "");
        }
        return chart;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows, String actionCommand) {
        Share[] data = (Share[])pData;
        GuiReportReq newGrr = grr.explode(-1);
        newGrr.reportSubtype = grr.reportSubtype;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        int rowCount = 0;
        for (int c = 0; c < rows.length; ++c) {
            if (data[rows[c]].shFilesystem.fsID <= 0) continue;
            ++rowCount;
        }
        newGrr.selectedResources = new int[rowCount];
        for (int i = 0; i < rows.length; ++i) {
            Share dataRow = data[rows[i]];
            int objectID = dataRow.shFilesystem.fsID;
            if (objectID <= 0) continue;
            newGrr.selectedResources[i] = objectID;
            SpaceHistChart.addLegend(newGrr, dataRow.shComputerName, dataRow.shFilesystem.fsMountPoint, objectID);
        }
        if (actionCommand == FREE_HIST) {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = 1;
            newGrr.historyTitle = "STG5111L";
        } else if (actionCommand == FREE_PERCENT_HIST) {
            newGrr.chartLabelType = (byte)8;
            newGrr.histSubtype = (byte)2;
            newGrr.historyTitle = "STG5112L";
        } else if (actionCommand == USED_HIST) {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = (byte)3;
            newGrr.historyTitle = "STG1278T";
        } else {
            newGrr.chartLabelType = (byte)6;
            newGrr.histSubtype = (byte)4;
            newGrr.historyTitle = "STG5110L";
        }
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        newGrr.reportSubtype = 28;
        return newGrr;
    }
}

