/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.eclipse.aperi.TStorm.common.BatchGraphInterface;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.PrintComponent;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.BasicSocketClient;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class MakeBatchGraph
implements BatchGraphInterface {
    static final String CREATED_BY = MessageLog.getMessageNoID("GEN0192L");
    static final String PRINTED = MessageLog.getMessageNoID("GEN0193L");
    public static final Color BLUE_GREEN = new Color(64, 204, 204);
    public static final Color DUSTY_ROSE = new Color(204, 102, 102);

    public int makeGraph(GuiReportReq grr, ReportDataAdjuster adjuster, Object[] dataArray, FileOutputStream stream, String fileName, byte reportType, String creator, BatchReport batchReport) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(MakeBatchGraph.class.getName(), "makeGraph", "grr, adjuster, dataArray, stream, fileName, reportType, creator, batchReport");
        }
        int returnCode = 8;
        GuiChartSettingsReq gcsr = new GuiChartSettingsReq();
        gcsr.reportId = grr.reportType;
        gcsr.reportSubtype = grr.reportSubtype;
        if (grr.histSubtype > 0) {
            gcsr.chartId = grr.histSubtype;
            gcsr.chartSubtype = grr.histSubtypeRange;
        } else {
            gcsr.chartId = grr.chartSubtype;
        }
        gcsr.creator = creator;
        gcsr.batchId = batchReport.reportID;
        gcsr.reqType = 4;
        gcsr.options = null;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
        request.userName = creator;
        request.flags = (byte)4;
        request.requestData = gcsr;
        Response response = null;
        try {
            response = BasicSocketClient.sendRequest(request, Variables.server, Variables.port);
        }
        catch (Exception e) {
            response = new Response(12, null);
            response.errorMessage = e.getMessage();
        }
        if (response == null || response.status > 4) {
            MessageLog.logMessage("AGT0151E");
        } else {
            gcsr = (GuiChartSettingsReq)response.responseData;
            ChartOptions chartOptions = gcsr.options;
            String className = null;
            Grapher grapher = null;
            try {
                className = GuiReportReq.guiClasses[grr.reportType][6];
                Class<?> rClass = Class.forName(className);
                Class[] argdef = new Class[]{};
                Constructor<?> constr = rClass.getConstructor(argdef);
                Object[] args = new Object[]{};
                grapher = (Grapher)constr.newInstance(args);
            }
            catch (Exception e) {
                Object[] parms = new Object[]{className};
                MessageLog.logMessage("STA2009E", parms);
                System.err.println(e);
                e.printStackTrace();
            }
            if (grapher != null) {
                PrintOptions printOptions = new PrintOptions();
                if (printOptions != null) {
                    int[] rowArray;
                    int number;
                    String title = grapher.getChartType(grr, adjuster);
                    if (chartOptions != null) {
                        title = chartOptions.title;
                        if (grapher.suffix != null) {
                            title = title + " - " + grapher.suffix;
                        }
                    }
                    if (title == null) {
                        title = MessageLog.getMessageNoID(GuiReportReq.guiClasses[grr.reportType][2]) + Util.getString("COLON") + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[grr.reportSubtype][0]);
                    }
                    printOptions.outputType = (byte)3;
                    printOptions.fileName = fileName;
                    printOptions.title = title;
                    if (creator != null) {
                        printOptions.creator = creator;
                    }
                    int dataLength = dataArray.length;
                    if (grr.chartSubtype == 0) {
                        String description = MessageLog.getMessageNoID(GuiReportReq.guiClasses[grr.reportType][2]) + " " + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[grr.reportSubtype][0]);
                        number = chartOptions != null && chartOptions.chartsPerView > 0 ? chartOptions.chartsPerView : 10;
                    } else {
                        boolean useOtherType;
                        number = grapher.graphsPerPage(grr);
                        if (number < 0) {
                            number = 2;
                        }
                        if (useOtherType = grapher.isOtherTypeReport(0)) {
                            number = chartOptions != null && chartOptions.seriesPerChart > 0 ? chartOptions.seriesPerChart : 12;
                            grapher.isOtherTypeReport(number);
                        } else if (chartOptions != null && chartOptions.chartsPerView > 0) {
                            number = chartOptions.chartsPerView;
                        }
                    }
                    int end = dataLength - number;
                    boolean printed = false;
                    int from = 0;
                    boolean otherType = grapher.isOtherTypeReport(number);
                    if (otherType) {
                        rowArray = new int[dataLength];
                        for (int c = 0; c < dataLength; ++c) {
                            rowArray[c] = c;
                        }
                    } else {
                        rowArray = new int[number];
                    }
                    while (from < dataLength) {
                        AperiChart chart;
                        if (!otherType) {
                            if (from > end) {
                                number = dataLength - from;
                                rowArray = new int[number];
                            }
                            for (int to = 0; to < number; ++to) {
                                rowArray[to] = from++;
                            }
                        }
                        if ((chart = grapher.processBatch(grr, dataArray, rowArray, adjuster, gcsr)) == null) {
                            if (!otherType) continue;
                            break;
                        }
                        printed = true;
                        printOptions.defaultWidth = 800;
                        printOptions.defaultHeight = 500;
                        printOptions.htmlChart = chart;
                        if (reportType == 8) continue;
                        PrintComponent.print(printOptions, null, printOptions.creator, title, title, true);
                    }
                    returnCode = printed ? 0 : 4;
                }
                try {
                    stream.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(MakeBatchGraph.class.getName(), "makeGraph", returnCode);
        }
        return returnCode;
    }
}

